/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.curve;

import com.agfa.pacs.listtext.dicomobject.module.curve.Curve;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class CurveModule {
    private List<Curve> curves = new ArrayList<Curve>();

    public static boolean containsModule(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2 = n * 2 << 16;
            if (attributes.contains(0x50003000 + n2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void readFrom(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            Curve curve = Curve.create(attributes, n * 2);
            if (curve != null) {
                this.curves.add(curve);
            }
            ++n;
        }
    }

    public void writeTo(Attributes attributes) {
        int n = 0;
        for (Curve curve : this.curves) {
            curve.setGroup(n);
            attributes.addAll(curve.toDataset());
            n += 2;
        }
    }

    public List<Curve> curves() {
        return this.curves;
    }

    public Curve getCurve(int n) {
        for (Curve curve : this.curves) {
            if (curve.getGroup() != n) continue;
            return curve;
        }
        return null;
    }
}

