/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.general;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.interfaces.IInstanceRef;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class ReferencedSOP
extends AbstractDatasetSource
implements IInstanceRef {
    private String sopInstanceUID;
    private String sopClassUID;
    private ReferencedSeries series;

    private ReferencedSOP(Attributes attributes) {
        this.sopClassUID = this.getString(attributes, 528720);
        this.sopInstanceUID = this.getString(attributes, 528725);
    }

    public ReferencedSOP(String string, String string2) {
        this.sopClassUID = string;
        this.sopInstanceUID = string2;
    }

    public static ReferencedSOP create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(528720) && attributes.contains(528725)) {
            return new ReferencedSOP(attributes);
        }
        return null;
    }

    public ReferencedSeries getSeries() {
        return this.series;
    }

    public void setSeries(ReferencedSeries referencedSeries) {
        this.series = referencedSeries;
    }

    public static List<ReferencedSOP> createList(Attributes attributes, int n) {
        ArrayList<ReferencedSOP> arrayList = new ArrayList<ReferencedSOP>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            ReferencedSOP referencedSOP = ReferencedSOP.create((Attributes)sequence.get(n2));
            if (referencedSOP != null) {
                arrayList.add(referencedSOP);
            }
            ++n2;
        }
        return arrayList;
    }

    public static void storeReferences(Attributes attributes, int n, List<IObjectInfo> list, String string) {
        Sequence sequence = attributes.newSequence(n, list.size());
        for (IObjectInfo iObjectInfo : list) {
            Attributes attributes2 = new Attributes(2);
            attributes2.setString(528725, VR.UI, iObjectInfo.getSOPInstanceUID());
            attributes2.setString(528720, VR.UI, iObjectInfo.getSOPClassUID());
            if (string != null) {
                attributes2.setString(524372, VR.AE, string);
            }
            sequence.add(attributes2);
        }
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    @Override
    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public void setSOPClassUID(String string) {
        this.sopClassUID = string;
    }

    @Override
    public void setSOPInstanceUID(String string) {
        this.sopInstanceUID = string;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.sopClassUID, attributes, 528720, DatasetAccessor.Type.Mandatory);
        this.set(this.sopInstanceUID, attributes, 528725, DatasetAccessor.Type.Mandatory);
        return attributes;
    }
}

