/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.login;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.Log4jInitializer;
import com.agfa.pacs.login.PopulateLog;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.CitrixUtils;
import com.agfa.pacs.tools.ComputerName;
import com.agfa.pacs.tools.StreamUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;

class LogHandler {
    private static LoggingConfigListener configListener = new LoggingConfigListener();
    private static boolean logExists;
    private static final String USE_LOG4J_RESOURCE = "log4j.useResource";
    public static final String REDIRECT_STD_OUT_ERR = "log4j.redirectStdOutErr";
    private static boolean useLog4jResource;
    private static boolean redirectStdOutErr;

    static {
        useLog4jResource = "true".equalsIgnoreCase(System.getProperty(USE_LOG4J_RESOURCE, "false"));
        redirectStdOutErr = "true".equalsIgnoreCase(System.getProperty(REDIRECT_STD_OUT_ERR, "false"));
    }

    LogHandler() {
    }

    public static boolean redirectStdOut() {
        return useLog4jResource && redirectStdOutErr;
    }

    static void prestart() {
        if (!LogHandler.redirectStdOut()) {
            String string = System.getProperty("instanceLogFolder");
            if (string != null) {
                PopulateLog.LOG_FILE_NAME = String.valueOf(string) + "/" + PopulateLog.LOG_FILE_NAME;
            }
            File file = new File(PopulateLog.LOG_FILE_NAME);
            logExists = file.exists();
            Log4jInitializer.initialise();
            LogHandler.applyChangesToFileAppenders();
        }
    }

    static void startLogging() {
        File file = new File("AgfaPegasusWrapper.log");
        if (file.exists()) {
            file.delete();
        }
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().getNode("logging");
        boolean bl = iConfigurationProvider.getBoolean("useServerLogs");
        boolean bl2 = System.getProperties().containsKey("offline");
        if (bl && !bl2) {
            String string = iConfigurationProvider.getString("serverShare");
            if (URLProviderFactory.getProvider().getHost() != null) {
                string = string.replace("@host", URLProviderFactory.getProvider().getHost());
            }
            PopulateLog.setServerLogPath(string);
        }
        LogHandler.configureLog4j(true);
        ConfigurationProviderFactory.getConfig().registerConfigurationChangeListener("logging", (IConfigurationChangeListener)configListener);
    }

    static void applyChangesToFileAppenders() {
        ALogger.getLogger(LogHandler.class);
        Enumeration enumeration = Logger.getRootLogger().getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof RollingFileAppender)) continue;
            RollingFileAppender rollingFileAppender = (RollingFileAppender)e;
            if (CitrixUtils.isRunningInCitrixEnviroment()) {
                rollingFileAppender.setFile(String.valueOf(CitrixUtils.getUniqueSessionName()) + "_" + rollingFileAppender.getFile());
                rollingFileAppender.activateOptions();
            }
            if (!logExists) continue;
            rollingFileAppender.rollOver();
        }
    }

    private static void configureLog4j(boolean bl) {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().getNode("logging");
        String string = iConfigurationProvider.getString("level");
        try {
            Logger logger = Logger.getRootLogger();
            Level level = Level.toLevel((String)string);
            Level level2 = logger.getLevel();
            if (!level.equals((Object)level2)) {
                logger.setLevel(level);
                Logger.getLogger((String)"LogConfig").log((Priority)level, (Object)("Log level set to:" + level.toString()));
            }
        }
        catch (Exception exception) {
            ALogger.getLogger((String)"LogConfig").error("Could not update log level");
        }
    }

    static void stopLogging() {
        Object object;
        if (ApplicationManagement.getInstance().getApplicationType().isAgilityPlatform()) {
            return;
        }
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().getNode("logging");
        boolean bl = iConfigurationProvider.getBoolean("useServerLogs");
        if (!bl) {
            return;
        }
        String string = iConfigurationProvider.getString("serverShare");
        if (!(string = string.replace("@host", URLProviderFactory.getProvider().getHost())).endsWith("\\")) {
            string = String.valueOf(string) + "\\";
        }
        string = String.valueOf(string) + ComputerName.getComputerId() + "\\";
        int n = (int)iConfigurationProvider.getLong("daysToStore");
        LogHandler.cleanOldLogs(string, n);
        string = String.valueOf(string) + PopulateLog.generateTimestamp() + ".log";
        Enumeration enumeration = Logger.getRootLogger().getAllAppenders();
        Object object2 = null;
        while (enumeration.hasMoreElements()) {
            object = (Appender)enumeration.nextElement();
            if (!(object instanceof RollingFileAppender)) continue;
            object2 = object;
            break;
        }
        if (object2 != null) {
            Logger.getRootLogger().removeAppender(object2);
            object2.close();
        }
        try {
            object = new File(PopulateLog.LOG_FILE_NAME);
            StreamUtil.copyFile((File)object, (File)new File(string));
            ((File)object).delete();
        }
        catch (IOException iOException) {
            ALogger.getLogger(LogHandler.class).error("Could not copy log file to server", (Throwable)iOException);
        }
    }

    private static void cleanOldLogs(String string, int n) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
            return;
        }
        File[] fileArray = file.listFiles(new LogFileFilter());
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -n);
        Date date = calendar.getTime();
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file2 = fileArray2[n3];
            Date date2 = new Date(file2.lastModified());
            if (date2.before(date)) {
                file2.delete();
            }
            ++n3;
        }
    }

    private static class LogFileFilter
    implements FilenameFilter {
        private LogFileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(".log");
        }
    }

    private static class LoggingConfigListener
    implements IConfigurationChangeListener {
        private LoggingConfigListener() {
        }

        public void configurationChanged(String string) {
            LogHandler.configureLog4j(false);
        }
    }
}

