/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.imageobject;

import com.agfa.pacs.data.shared.icon.IIconInfo;
import com.agfa.pacs.data.shared.icon.IIconProvider;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.lta.util.imageobject.IImageObjectLoader;
import com.agfa.pacs.listtext.lta.util.imageobject.IImageObjectLoaderListener;
import com.agfa.pacs.listtext.lta.util.imageobject.IImageObjectLoadingPolicy;
import com.agfa.pacs.listtext.lta.util.imageobject.ImageObjectLoadingPolicyException;
import com.agfa.pacs.logging.ALogger;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageObjectLoader
implements IImageObjectLoader {
    public static ALogger logger = ALogger.getLogger(ImageObjectLoader.class);
    public static ThumbnailLoadingPolicy thumbnailLoadingPolicy = new ThumbnailLoadingPolicy();
    public static LargeThumbnailLoadingPolicy largeThumbnailLoadingPolicy = new LargeThumbnailLoadingPolicy();

    @Override
    public List<IImageObjectLoadingPolicy> getSupportedLoadingPolicies() {
        return Arrays.asList(thumbnailLoadingPolicy, largeThumbnailLoadingPolicy);
    }

    @Override
    public List<IImageObjectLoadingPolicy> getSupportedIconLoadingPolicies() {
        return Arrays.asList(thumbnailLoadingPolicy, largeThumbnailLoadingPolicy);
    }

    @Override
    public Map<IObjectInfo, List<Image>> getImagesSync(List<IObjectInfo> list, List<IImageObjectLoadingPolicy> list2, Dimension dimension) {
        ImageObjectLoaderThread imageObjectLoaderThread = new ImageObjectLoaderThread(list, list2, dimension, null);
        imageObjectLoaderThread.run();
        return imageObjectLoaderThread.getResult();
    }

    @Override
    public Cancelable getImagesAsync(List<IObjectInfo> list, List<IImageObjectLoadingPolicy> list2, Dimension dimension, IImageObjectLoaderListener iImageObjectLoaderListener) {
        ImageObjectLoaderThread imageObjectLoaderThread = new ImageObjectLoaderThread(list, list2, dimension, iImageObjectLoaderListener);
        imageObjectLoaderThread.start();
        return imageObjectLoaderThread;
    }

    private boolean isPolicySupported(IImageObjectLoadingPolicy iImageObjectLoadingPolicy) {
        if (iImageObjectLoadingPolicy != null) {
            for (IImageObjectLoadingPolicy iImageObjectLoadingPolicy2 : this.getSupportedLoadingPolicies()) {
                if (!iImageObjectLoadingPolicy2.getPolicyId().equals(iImageObjectLoadingPolicy.getPolicyId())) continue;
                return true;
            }
        }
        return false;
    }

    private class ImageObjectLoaderThread
    extends Thread
    implements Cancelable {
        private boolean running = false;
        private boolean cancelled = false;
        private List<IObjectInfo> objects = null;
        private List<IImageObjectLoadingPolicy> policies = null;
        private IImageObjectLoaderListener iol = null;
        private Dimension dim;
        private Map<IObjectInfo, List<Image>> imageMap = new HashMap<IObjectInfo, List<Image>>();

        public ImageObjectLoaderThread(List<IObjectInfo> list, List<IImageObjectLoadingPolicy> list2, Dimension dimension, IImageObjectLoaderListener iImageObjectLoaderListener) {
            this.objects = list;
            this.policies = list2;
            this.iol = iImageObjectLoaderListener;
            this.dim = dimension;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void cancel() {
            if (!this.isRunning()) {
                this.cancelled = true;
            }
        }

        public Map<IObjectInfo, List<Image>> getResult() {
            return this.imageMap;
        }

        @Override
        public void run() {
            this.running = true;
            this.cancelled = false;
            if (this.iol != null) {
                this.iol.loadingStarted(ImageObjectLoader.this);
            }
            if (this.objects != null && !this.objects.isEmpty() && this.policies != null && !this.policies.isEmpty()) {
                block4: for (IObjectInfo iObjectInfo : this.objects) {
                    if (this.cancelled) break;
                    for (IImageObjectLoadingPolicy iImageObjectLoadingPolicy : this.policies) {
                        Object object;
                        block12: {
                            if (this.cancelled) continue block4;
                            if (ImageObjectLoader.this.isPolicySupported(iImageObjectLoadingPolicy)) {
                                try {
                                    object = iImageObjectLoadingPolicy.getImages(iObjectInfo, this.dim);
                                    if (object == null) {
                                        logger.trace("Loading object image with policy " + iImageObjectLoadingPolicy.getPolicyId() + " failed: Try next policy");
                                        break block12;
                                    }
                                    logger.trace("Object image loaded, policy: " + iImageObjectLoadingPolicy.getPolicyId());
                                    this.imageMap.put(iObjectInfo, (List<Image>)object);
                                    continue block4;
                                }
                                catch (ImageObjectLoadingPolicyException imageObjectLoadingPolicyException) {
                                    logger.trace("Loading object image with policy " + iImageObjectLoadingPolicy.getPolicyId() + " failed: Try next policy", (Throwable)imageObjectLoadingPolicyException);
                                    break block12;
                                }
                            }
                            logger.trace("Loading object image with policy " + iImageObjectLoadingPolicy.getPolicyId() + " failed: Policy not supported, Try next policy");
                        }
                        if (this.policies.indexOf(iImageObjectLoadingPolicy) != this.policies.size() - 1) continue;
                        logger.error("Loading object image failed");
                        object = null;
                        try {
                            IIconProvider iIconProvider = iObjectInfo.getSource().getIconProvider();
                            IIconInfo iIconInfo = iIconProvider.getDefaultIcon(iObjectInfo);
                            object = iIconInfo.getImage();
                            if (this.dim != null) {
                                object = ((Image)object).getScaledInstance(this.dim.width, this.dim.height, 2);
                            }
                        }
                        catch (Exception exception) {}
                        this.imageMap.put(iObjectInfo, object != null ? Collections.singletonList(object) : Collections.EMPTY_LIST);
                    }
                }
            }
            logger.debug(String.valueOf(this.imageMap.size()) + " Image objects loaded");
            this.running = false;
            this.cancelled = false;
            if (this.iol != null) {
                this.iol.loadingFinished(ImageObjectLoader.this, this.imageMap);
            }
        }
    }

    private static class LargeThumbnailLoadingPolicy
    implements IImageObjectLoadingPolicy {
        private LargeThumbnailLoadingPolicy() {
        }

        @Override
        public String getPolicyId() {
            return "LARGE_THUMBNAIL_POLICY";
        }

        @Override
        public List<Image> getImages(IObjectInfo iObjectInfo, Dimension dimension) throws ImageObjectLoadingPolicyException {
            IIconProvider iIconProvider;
            block4: {
                if (!iObjectInfo.getSource().getIdentifier().getType().contains("WADO")) {
                    return thumbnailLoadingPolicy.getImages(iObjectInfo, dimension);
                }
                try {
                    iIconProvider = iObjectInfo.getSource().getIconProvider();
                    if (iIconProvider.isIconAvailable(iObjectInfo)) break block4;
                    return null;
                }
                catch (Exception exception) {
                    throw new ImageObjectLoadingPolicyException(exception);
                }
            }
            IIconInfo iIconInfo = iIconProvider.getIcon(iObjectInfo, 0);
            return Arrays.asList(iIconInfo.getImage());
        }
    }

    private static class ThumbnailLoadingPolicy
    implements IImageObjectLoadingPolicy {
        private ThumbnailLoadingPolicy() {
        }

        @Override
        public String getPolicyId() {
            return "THUMBNAIL_POLICY";
        }

        @Override
        public List<Image> getImages(IObjectInfo iObjectInfo, Dimension dimension) throws ImageObjectLoadingPolicyException {
            IIconInfo iIconInfo;
            block3: {
                try {
                    IIconProvider iIconProvider = iObjectInfo.getSource().getIconProvider();
                    iIconInfo = iIconProvider.getIcon(iObjectInfo, 0);
                    if (iIconInfo != null) break block3;
                    return null;
                }
                catch (Exception exception) {
                    throw new ImageObjectLoadingPolicyException(exception);
                }
            }
            BufferedImage bufferedImage = iIconInfo.getImage();
            return Arrays.asList(bufferedImage);
        }
    }
}

