/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.uiconfig;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.lta.uiconfig.ILTAUIConfiguration;
import com.agfa.pacs.logging.ALogger;

public class LTAUIConfiguration
implements ILTAUIConfiguration {
    private static final ALogger log = ALogger.getLogger(LTAUIConfiguration.class);
    private static final String ROOT = "listtext.lta";
    private boolean fontScalingEnabled;
    private double fontScalingCorrection;
    private ILTAUIConfiguration.ImageScaleType imageScaleType;
    private IConfigurationProvider configProvider = ConfigurationProviderFactory.getConfig();

    public LTAUIConfiguration() {
        this.createConfigurationData();
    }

    public void createConfigurationData() {
        if (this.configProvider == null) {
            return;
        }
        this.fontScalingEnabled = this.createFontScaling(this.configProvider);
        this.fontScalingCorrection = this.createFontScalingCorrection(this.configProvider);
        this.imageScaleType = this.createImageScaleType(this.configProvider);
    }

    @Override
    public boolean getFontScaling() {
        return this.fontScalingEnabled;
    }

    @Override
    public double getFontScalingCorrection() {
        return this.fontScalingCorrection;
    }

    @Override
    public ILTAUIConfiguration.ImageScaleType getImageScaleType() {
        return this.imageScaleType;
    }

    protected ILTAUIConfiguration.ImageScaleType createImageScaleType(IConfigurationProvider iConfigurationProvider) {
        try {
            String string = iConfigurationProvider.getString("listtext.lta.image.scale_type");
            if ("FAST".equalsIgnoreCase(string)) {
                return ILTAUIConfiguration.ImageScaleType.FAST;
            }
            if ("SMOOTH".equalsIgnoreCase(string)) {
                return ILTAUIConfiguration.ImageScaleType.SMOOTH;
            }
            if ("DEFAULT".equalsIgnoreCase(string)) {
                return ILTAUIConfiguration.ImageScaleType.DEFAULT;
            }
            if ("REPLICATE".equalsIgnoreCase(string)) {
                return ILTAUIConfiguration.ImageScaleType.REPLICATE;
            }
            if ("AREA_AVERAGING".equalsIgnoreCase(string)) {
                return ILTAUIConfiguration.ImageScaleType.AREA_AVERAGING;
            }
            return ILTAUIConfiguration.ImageScaleType.FAST;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Config Error", (Throwable)illegalArgumentException);
            return ILTAUIConfiguration.ImageScaleType.FAST;
        }
    }

    protected boolean createFontScaling(IConfigurationProvider iConfigurationProvider) {
        try {
            return iConfigurationProvider.getBoolean("listtext.lta.ui.font.scaling");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Config Error", (Throwable)illegalArgumentException);
            return false;
        }
    }

    protected double createFontScalingCorrection(IConfigurationProvider iConfigurationProvider) {
        try {
            return iConfigurationProvider.getDouble("listtext.lta.ui.font.scale_correction");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Config Error", (Throwable)illegalArgumentException);
            return 1.0;
        }
    }

    protected boolean createShowSplashWindowFlag(IConfigurationProvider iConfigurationProvider) {
        boolean bl = false;
        try {
            bl = iConfigurationProvider.getBoolean("listtext.lta.ui.splashwindow");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Configuring splash-window flag failed!");
        }
        return bl;
    }
}

