/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.listtext.lta.reports.IReportProvider;
import com.agfa.pacs.listtext.lta.reports.ReportType;
import java.util.List;

public abstract class ReportProviderFactory {
    private static ReportProviderFactory implementation;

    public static synchronized ReportProviderFactory getInstance() {
        if (implementation == null) {
            implementation = ReportProviderFactory.initialize();
        }
        return implementation;
    }

    public abstract List<IReportProvider> getReportProviders();

    public abstract List<IReportProvider> getReportProviders(ReportType var1);

    public int getReportProviderCount(ReportType reportType) {
        List<IReportProvider> list = this.getReportProviders(reportType);
        return list != null ? list.size() : 0;
    }

    private static ReportProviderFactory initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)ReportProviderFactory.class.getName()));
            return (ReportProviderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        throw new RuntimeException("Failed to create factory " + ReportProviderFactory.class.getName(), reflectiveOperationException);
    }
}

