/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.SingleObjectDataListener;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.IReportListener;
import com.agfa.pacs.tools.DateUtilities;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.dcm4che3.data.Attributes;

public abstract class AbstractReport
implements IReport {
    protected IObjectInfo reportInfo;
    protected Attributes reportObject;
    private int loadingAttempts = 0;
    private Map<IReport.ReportFlag, Boolean> flags;
    private static int maxLoadingAttempts = 2;
    private List<IReportListener> listener;

    public AbstractReport(IObjectInfo iObjectInfo, Attributes attributes) {
        this.reportInfo = iObjectInfo;
        this.reportObject = attributes;
        this.flags = new HashMap<IReport.ReportFlag, Boolean>(2);
        this.listener = new Vector<IReportListener>();
    }

    @Override
    public Boolean getReportFlag(IReport.ReportFlag reportFlag) {
        return this.flags.get((Object)reportFlag);
    }

    @Override
    public void setReportFlag(IReport.ReportFlag reportFlag, Boolean bl) {
        this.flags.put(reportFlag, bl);
    }

    @Override
    public String getHtmlDigest() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        stringBuilder.append(this.toString());
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    @Override
    public IObjectInfo getReportInfo() {
        return this.reportInfo;
    }

    @Override
    public synchronized Attributes getReportObject() {
        if (this.reportObject == null && this.loadingAttempts < maxLoadingAttempts) {
            this.fireLoadingReportObjectStarted();
            ++this.loadingAttempts;
            this.reportObject = this.loadReportObject(this.reportInfo);
            this.fireLoadingReportObjectFinished();
        }
        return this.reportObject;
    }

    @Override
    public Date getCreationDateTime() {
        return this.getCreationDateTimeInt();
    }

    @Override
    public void addReportListener(IReportListener iReportListener) {
        if (iReportListener != null && !this.listener.contains(iReportListener)) {
            this.listener.add(iReportListener);
        }
    }

    @Override
    public void removeReportListener(IReportListener iReportListener) {
        if (iReportListener != null && this.listener.contains(iReportListener)) {
            this.listener.remove(iReportListener);
        }
    }

    public String toString() {
        String string = this.getTitle();
        Date date = this.getCreationDate();
        IReport.CompletionState completionState = this.getCompletionState();
        IReport.VerificationState verificationState = this.getVerificationState();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (date != null || completionState != null || verificationState != null) {
            stringBuilder.append(" (");
            if (date != null) {
                stringBuilder.append(DateTimeUtils.date2String((Date)date));
                if (completionState != null || verificationState != null) {
                    stringBuilder.append(", ");
                }
            }
            if (completionState != null) {
                stringBuilder.append((Object)completionState);
                if (verificationState != null) {
                    stringBuilder.append(", ");
                }
            }
            if (verificationState != null) {
                stringBuilder.append((Object)verificationState);
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private void fireLoadingReportObjectStarted() {
        for (IReportListener iReportListener : this.listener) {
            iReportListener.loadingReportObjectStarted(this);
        }
    }

    private void fireLoadingReportObjectFinished() {
        for (IReportListener iReportListener : this.listener) {
            iReportListener.loadingReportObjectFinished(this);
        }
    }

    private Date getCreationDateTimeInt() {
        Date date = this.getCreationDate();
        Date date2 = this.getCreationTime();
        if (date != null && date2 != null) {
            return DateUtilities.createDateTime((Date)date, (Date)date2);
        }
        if (date2 == null) {
            return date;
        }
        return date;
    }

    protected Attributes loadReportObject(IObjectInfo iObjectInfo) {
        if (iObjectInfo != null) {
            SingleObjectDataListener singleObjectDataListener = new SingleObjectDataListener(iObjectInfo.getSOPInstanceUID());
            IDicomDataRequest iDicomDataRequest = DicomDataRequester.getInstance().createDicomDataRequest(iObjectInfo, (byte)0);
            iDicomDataRequest.setListener((IDicomDataListener)singleObjectDataListener);
            iDicomDataRequest.setFromCache(false);
            DicomDataRequester.getInstance().addRequest(iDicomDataRequest);
            iDicomDataRequest.waitUntilFinished();
            return singleObjectDataListener.getDataset();
        }
        return null;
    }
}

