/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.integration.audit;

import com.agfa.pacs.logging.ALogger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JEditorPane;
import javax.swing.text.View;

public class DocumentRenderer
implements Printable {
    private static final ALogger log = ALogger.getLogger(DocumentRenderer.class);
    protected int currentPage = -1;
    protected JEditorPane jeditorPane;
    protected double pageEndY = 0.0;
    protected double pageStartY = 0.0;
    protected PageFormat pFormat = new PageFormat();
    protected PrinterJob pJob = PrinterJob.getPrinterJob();

    public void setPageFormatOrientation(int n) {
        this.pFormat.setOrientation(n);
    }

    public void setPrintJobName(String string) {
        this.pJob.setJobName(string);
    }

    public void pageDialog() {
        this.pFormat = this.pJob.pageDialog(this.pFormat);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d = 1.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.getColor();
        this.jeditorPane.setSize((int)pageFormat.getImageableWidth(), Integer.MAX_VALUE);
        this.jeditorPane.validate();
        View view = this.jeditorPane.getUI().getRootView(this.jeditorPane);
        if (this.jeditorPane.getMinimumSize().getWidth() > pageFormat.getImageableWidth()) {
            d = pageFormat.getImageableWidth() / this.jeditorPane.getMinimumSize().getWidth();
            graphics2D.scale(d, d);
        }
        graphics2D.setClip((int)(pageFormat.getImageableX() / d), (int)(pageFormat.getImageableY() / d), (int)(pageFormat.getImageableWidth() / d), (int)(pageFormat.getImageableHeight() / d));
        if (n > this.currentPage) {
            this.currentPage = n;
            this.pageStartY += this.pageEndY;
            this.pageEndY = graphics2D.getClipBounds().getHeight();
        }
        graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
        Rectangle rectangle = new Rectangle(0, (int)(-this.pageStartY), (int)this.jeditorPane.getMinimumSize().getWidth(), (int)this.jeditorPane.getPreferredSize().getHeight());
        if (this.printView(graphics2D, rectangle, view)) {
            return 0;
        }
        this.pageStartY = 0.0;
        this.pageEndY = 0.0;
        this.currentPage = -1;
        return 1;
    }

    public void print(JEditorPane jEditorPane) {
        this.jeditorPane = jEditorPane;
        this.printDialog();
    }

    protected void printDialog() {
        if (this.pJob.printDialog()) {
            this.pJob.setPrintable(this, this.pFormat);
            try {
                this.pJob.print();
            }
            catch (PrinterException printerException) {
                this.pageStartY = 0.0;
                this.pageEndY = 0.0;
                this.currentPage = -1;
                log.error("Error Printing Document", (Throwable)printerException);
            }
        }
    }

    protected boolean printView(Graphics2D graphics2D, Shape shape, View view) {
        boolean bl = false;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0 && !view.getElement().getName().equalsIgnoreCase("td")) {
            int n = 0;
            while (n < view.getViewCount()) {
                View view2;
                Shape shape2 = view.getChildAllocation(n, shape);
                if (shape2 != null && this.printView(graphics2D, shape2, view2 = view.getView(n))) {
                    bl = true;
                }
                ++n;
            }
        } else if (shape.getBounds().getMaxY() >= rectangle.getY()) {
            bl = true;
            if (shape.getBounds().getHeight() > rectangle.getHeight() && shape.intersects(rectangle)) {
                view.paint(graphics2D, shape);
            } else if (shape.getBounds().getY() >= rectangle.getY()) {
                if (shape.getBounds().getMaxY() <= rectangle.getMaxY()) {
                    view.paint(graphics2D, shape);
                } else if (shape.getBounds().getY() < this.pageEndY) {
                    this.pageEndY = shape.getBounds().getY();
                }
            }
        }
        return bl;
    }
}

