/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.inputverifier;

import com.agfa.pacs.listtext.lta.inputverifier.IDateInputVerifier;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.util.DateUtils;

public class TimeInputVerifier
extends InputVerifier
implements IDateInputVerifier {
    private static final DatePrecision PERFECT_PRECISION = new DatePrecision();
    private static DateFormat shortFormat = DateFormat.getTimeInstance(3);

    @Override
    public String dateToFormatString(Date date) {
        return shortFormat.format(date);
    }

    @Override
    public String dateToDicomString(Date date) {
        return DateUtils.formatTM(null, (Date)date);
    }

    @Override
    public String dicomStringToFormatString(String string) throws ParseException {
        return this.dateToFormatString(this.dicomStringToDate(string));
    }

    @Override
    public Date dicomStringToDate(String string) throws ParseException {
        return DateUtils.parseTM(null, (String)string, (boolean)false, (DatePrecision)PERFECT_PRECISION);
    }

    public String formatStringToDicomString(String string) throws ParseException {
        return this.dateToDicomString(this.formatStringToDate(string));
    }

    @Override
    public Date formatStringToDate(String string) throws ParseException {
        return shortFormat.parse(string);
    }

    @Override
    public boolean verify(JComponent jComponent) {
        String string = ((JTextField)jComponent).getText();
        try {
            Date date = this.formatStringToDate(string);
            this.dateToDicomString(date);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

