/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.tagdictionary;

import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.AbstractIntermediateXMLElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Tag;

public class DicomTagDictionary
extends AbstractIntermediateXMLElement {
    private static final ALogger logger = ALogger.getLogger(DicomTagDictionary.class);
    private Map<Integer, DicomTag> currentTags = new HashMap<Integer, DicomTag>();
    private Map<String, DicomTag> allTags = new HashMap<String, DicomTag>();
    private List<DicomTag> tagsInXML = new ArrayList<DicomTag>();

    public DicomTagDictionary() {
        this.readCurrentTags();
    }

    public void addDicomTag(DicomTag dicomTag) {
        this.tagsInXML.add(dicomTag);
        this.allTags.put(dicomTag.getName(), dicomTag);
    }

    public DicomTag getDicomTag(int n) {
        return this.tagsInXML.size() > n && n >= 0 ? this.tagsInXML.get(n) : null;
    }

    public void readCurrentTags() {
        Field[] fieldArray;
        Field[] fieldArray2 = fieldArray = Tag.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            try {
                Integer n3 = field.getInt(null);
                String string = ElementDictionary.keywordOf((int)n3, null);
                DicomTag dicomTag = new DicomTag(field.getName(), string, n3);
                this.currentTags.put(n3, dicomTag);
                this.allTags.put(dicomTag.getName(), dicomTag);
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    List<DicomTag> currentTagsAsList() {
        ArrayList<DicomTag> arrayList = new ArrayList<DicomTag>();
        for (Map.Entry<Integer, DicomTag> entry : this.currentTags.entrySet()) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public void updateXML() {
        this.tagsInXML.clear();
        for (DicomTag dicomTag : this.allTags.values()) {
            this.tagsInXML.add(dicomTag);
        }
    }

    public String descriptionForTag(int n) {
        DicomTag dicomTag = this.currentTags.get(n);
        if (dicomTag != null) {
            return dicomTag.getDescription();
        }
        return null;
    }

    public String nameForTag(int n) {
        DicomTag dicomTag = this.currentTags.get(n);
        if (dicomTag != null) {
            return dicomTag.getName();
        }
        return null;
    }

    public Integer tagForName(String string) {
        if (string == null) {
            return null;
        }
        DicomTag dicomTag = this.allTags.get(string);
        if (dicomTag != null) {
            return dicomTag.getNumber();
        }
        return null;
    }

    public DicomTag dicomTag(int n) {
        DicomTag dicomTag = this.currentTags.get(n);
        return dicomTag;
    }

    public DicomTag dicomTag(String string) {
        DicomTag dicomTag = this.allTags.get(string);
        return dicomTag;
    }

    Collection<DicomTag> getAllTags() {
        return Collections.unmodifiableCollection(this.currentTags.values());
    }

    public int size() {
        return this.currentTags.size();
    }

    public void filterTagsForXML() {
        this.checkForChangedNumbers();
        Iterator<DicomTag> iterator = this.tagsInXML.iterator();
        while (iterator.hasNext()) {
            DicomTag dicomTag = iterator.next();
            DicomTag dicomTag2 = this.currentTags.get(dicomTag.getNumber());
            if (dicomTag2 == null) {
                logger.warn("tag with number " + dicomTag.getNumber() + " and name " + dicomTag.getName() + " not present in current DCM4Chee anymore");
                continue;
            }
            if (dicomTag2.getName().equals(dicomTag.getName())) {
                iterator.remove();
                continue;
            }
            logger.warn("tag name changed from " + dicomTag.getName() + " to " + dicomTag2.getName());
        }
    }

    private void checkForChangedNumbers() {
        HashMap<String, DicomTag> hashMap = new HashMap<String, DicomTag>();
        for (DicomTag dicomTag : this.tagsInXML) {
            hashMap.put(dicomTag.getName(), dicomTag);
        }
        for (DicomTag dicomTag : this.currentTags.values()) {
            DicomTag dicomTag2 = (DicomTag)hashMap.get(dicomTag.getName());
            if (dicomTag2 == null || dicomTag2.getNumber().equals(dicomTag.getNumber())) continue;
            logger.error("tag number for tag " + dicomTag2.getName() + " has been changed from " + dicomTag2.getNumber() + " to " + dicomTag.getNumber());
        }
    }
}

