/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.shutdown;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.shutdown.IShutdownPreparer;
import com.agfa.pacs.listtext.lta.base.shutdown.ShutdownPreparerFactory;
import com.agfa.pacs.listtext.lta.base.shutdown.ShutdownType;
import com.agfa.pacs.listtext.lta.progress.ProgressManagerFactory;
import java.awt.Component;
import java.text.MessageFormat;

public class ShutdownUtil {
    private static final String USE_EXIT_DIALOG_CONFIG_KEY = "impaxee.jvision.MAIN.UseExitDlg";
    private static volatile boolean isShuttingDown;

    private ShutdownUtil() {
    }

    public static boolean isShuttingDown() {
        return isShuttingDown;
    }

    public static void exit(IComponentFactory iComponentFactory, Component component, boolean bl, final ShutdownType shutdownType) {
        boolean bl2 = ProgressManagerFactory.getManager().hasRunningJobs();
        if (bl2 || ShutdownUtil.isUserConfirmationEnabled(shutdownType)) {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            if (bl2) {
                stringBuilder.append(Messages.getString("ShutdownUtil.RunningJobs.Base.Msg"));
                stringBuilder.append('\n');
                stringBuilder.append('\n');
                string = "ShutdownUtil.RunningJobs";
            } else {
                string = "ShutdownUtil";
            }
            String string2 = bl ? Messages.getString(String.valueOf(string) + ".Restart.Msg") : Messages.getString(String.valueOf(string) + ".Exit.Msg");
            stringBuilder.append(MessageFormat.format(string2, Product.getProductName()));
            if (!iComponentFactory.showYesNoDialog(Messages.getString("ShutdownUtil.Dialog.Title"), stringBuilder.toString(), component)) {
                return;
            }
        }
        if (Boolean.parseBoolean(System.getProperty("login.kerberos"))) {
            bl = false;
        }
        if (!Product.isRunningAutoTests() && Boolean.parseBoolean(System.getProperty("feldtest"))) {
            iComponentFactory.showErrorDialog(Messages.getString("ShutdownUtil.ConfigurationNotSavedTitle"), Messages.getString("ShutdownUtil.ConfigurationNotSaved"), component);
        }
        isShuttingDown = true;
        final boolean bl3 = bl;
        EventUtil.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                for (IShutdownPreparer iShutdownPreparer : ShutdownPreparerFactory.getInstance().getShutdownPreparers()) {
                    if (iShutdownPreparer.requestShutdown(shutdownType) || !shutdownType.isShutdownRevocable()) continue;
                    isShuttingDown = false;
                    return;
                }
                ApplicationManagement.getInstance().shutdown(bl3);
            }
        });
    }

    private static boolean isUserConfirmationEnabled(ShutdownType shutdownType) {
        return shutdownType.isUserConfirmationEnabled() && ConfigurationProviderFactory.getConfig().exists(USE_EXIT_DIALOG_CONFIG_KEY) && ConfigurationProviderFactory.getConfig().getBoolean(USE_EXIT_DIALOG_CONFIG_KEY);
    }
}

