/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.pwp;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.pwp.IWPPerson;
import com.agfa.pacs.listtext.swingx.controls.PopupWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class WPUtils {
    public static String formatAsHTML(IWPPerson iWPPerson) {
        StringBuffer stringBuffer = new StringBuffer("<html>");
        stringBuffer.append("<b>").append(iWPPerson.getFullName()).append("</b>").append("<br>");
        String string = iWPPerson.getAttribute("telephoneNumber");
        if (string != null) {
            stringBuffer.append("<u>").append(Messages.getString("WPUtils.Telephone")).append(':').append("</u>  ").append(string).append("<br>");
        }
        if ((string = iWPPerson.getAttribute("mobile")) != null) {
            stringBuffer.append("<u>").append(Messages.getString("WPUtils.MobilePhone")).append(':').append("</u> ").append(string).append("<br>");
        }
        if ((string = iWPPerson.getAttribute("pager")) != null) {
            stringBuffer.append("<u>").append(Messages.getString("WPUtils.Pager")).append(':').append("</u>  ").append(string).append("<br>");
        }
        if ((string = iWPPerson.getAttribute("mail")) != null) {
            stringBuffer.append("<u>").append(Messages.getString("WPUtils.Email")).append(':').append("</u>  ").append(string).append("<br>");
        }
        if ((string = iWPPerson.getAttribute("postalAddress")) != null) {
            stringBuffer.append("<u>").append(Messages.getString("WPUtils.Address")).append(':').append("</u><br>").append(string).append("<br>");
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    public static void displayAsPopup(List<IWPPerson> list, Component component) {
        PopupWindow popupWindow = new PopupWindow(SwingUtilities.windowForComponent(component));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        if (list.size() > 1) {
            JComboBox<IWPPerson> jComboBox = new JComboBox<IWPPerson>(list.toArray(new IWPPerson[list.size()]));
            jComboBox.addActionListener(new PersonChanger(jComboBox, jTextPane));
            jPanel.add(jComboBox, "North");
        }
        jTextPane.setText(WPUtils.formatAsHTML(list.get(0)));
        jPanel.add((Component)jTextPane, "Center");
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        if (list.size() > 1) {
            jPanel.setPreferredSize(GUI.getScaledDimension((int)180, (int)180));
        } else {
            jPanel.setPreferredSize(GUI.getScaledDimension((int)180, (int)150));
        }
        popupWindow.getContentPane().add(jPanel);
        popupWindow.show(component, 0, component.getHeight(), (int)jPanel.getPreferredSize().getWidth() + 20, (int)jPanel.getPreferredSize().getHeight() + 30);
    }

    private static class PersonChanger
    implements ActionListener {
        private JTextPane pane;
        private JComboBox<IWPPerson> cbx;

        public PersonChanger(JComboBox<IWPPerson> jComboBox, JTextPane jTextPane) {
            this.pane = jTextPane;
            this.cbx = jComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IWPPerson iWPPerson = (IWPPerson)this.cbx.getSelectedItem();
            this.pane.setText(WPUtils.formatAsHTML(iWPPerson));
        }
    }
}

