/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.dicominfo;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class TagsTableModel
extends AbstractTableModel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected static final ALogger log = ALogger.getLogger(TagsTableModel.class);
    protected static final String EMPTY_STRING = "";
    protected static final String SPACE_STRING = " ";
    protected static final String BRACKET_RIGHT = "]";
    protected static final String BRACKET_LEFT = "[";
    private static final String title = "IMPAX EE DICOM Tag Export";
    private Color colorDicom;
    private Color colorPrivate;
    private Color colorDicomPrivate;
    private Color colorFgStandard;
    private Color colorBgStandard;
    private String fgColorString;
    private String bgColorString;
    protected String[] columnNames = new String[]{Messages.getString("DcmInfoSetDlg.GroupElement"), Messages.getString("DcmInfoSetDlg.Description"), Messages.getString("DcmInfoSetDlg.Data")};
    private Hashtable<?, ?> tags;
    private Vector<TagEntry> infoData;
    private Vector<TagEntry> viewedInfoData;
    private JLabel label;
    private StringPos foundLabel = null;
    private IComponentFactory componentFactory;

    protected TagsTableModel(IComponentFactory iComponentFactory) {
        this.componentFactory = iComponentFactory;
        this.initBasics();
    }

    public void initBasics() {
        this.tags = null;
        this.infoData = new Vector();
        this.label = this.componentFactory.createLabel(null);
        this.label.setOpaque(true);
        if (this.componentFactory.isOnColorMonitor()) {
            this.colorDicom = new Color(29, 49, 71);
            this.colorPrivate = new Color(32, 55, 80);
            this.colorDicomPrivate = new Color(35, 60, 86);
            this.colorFgStandard = new Color(255, 255, 255);
            this.colorBgStandard = new Color(20, 32, 45);
            this.fgColorString = Integer.toHexString(Color.RED.getRGB() & 0xFFFFFF);
            this.bgColorString = Integer.toHexString(Color.WHITE.getRGB() & 0xFFFFFF);
        } else {
            this.colorDicom = new Color(10, 10, 10);
            this.colorPrivate = new Color(20, 20, 20);
            this.colorDicomPrivate = new Color(40, 40, 40);
            this.colorFgStandard = new Color(195, 195, 195);
            this.colorBgStandard = new Color(75, 75, 75);
            this.fgColorString = Integer.toHexString(Color.WHITE.getRGB() & 0xFFFFFF);
            this.bgColorString = Integer.toHexString(Color.WHITE.getRGB() & 0xFFFFFF);
        }
    }

    public void setFoundLabel(StringPos stringPos) {
        this.foundLabel = stringPos;
        this.fireTableDataChanged();
    }

    public StringPos getFoundLabel() {
        return this.foundLabel;
    }

    public void show(boolean bl, boolean bl2) {
        this.viewedInfoData = new Vector();
        for (TagEntry tagEntry : this.infoData) {
            boolean bl3;
            boolean bl4 = (tagEntry.flags & 1) != 0;
            boolean bl5 = (tagEntry.flags & 2) != 0;
            boolean bl6 = bl3 = bl4 && !bl5 && bl || bl4 && bl5 && bl2;
            if (!bl3) continue;
            this.viewedInfoData.addElement(tagEntry);
        }
        this.fireTableDataChanged();
    }

    protected void addTagEntry(TagEntry tagEntry) {
        if (this.tags != null && this.tags.containsKey(tagEntry.key)) {
            tagEntry.flags |= 4;
            tagEntry.desc = (String)this.tags.get(tagEntry.key);
        }
        this.infoData.addElement(tagEntry);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.viewedInfoData == null) {
            return 0;
        }
        return this.viewedInfoData.size();
    }

    private String leadingZeroHex(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    protected static String bytesToString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray2[n2];
            String string = Integer.toHexString(by & 0xFF).toUpperCase(Locale.ENGLISH);
            if (string.length() == 1) {
                stringBuilder.append("0");
            }
            stringBuilder.append(string);
            stringBuilder.append(SPACE_STRING);
            if (stringBuilder.length() > 100) {
                stringBuilder.append("...");
                break;
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private String mapNull(String string) {
        if (string != null) {
            return string;
        }
        return BRACKET_LEFT + Messages.getString("DcmInfoSetDlg.None") + BRACKET_RIGHT;
    }

    private int isSubstringIgnoreCase(String string, String string2) {
        String string3 = string.toUpperCase(Locale.getDefault());
        String string4 = string2.toUpperCase(Locale.getDefault());
        return string3.indexOf(string4);
    }

    public StringPos search(String string, int n, int n2, boolean bl) {
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n4 || string == null) {
            return null;
        }
        if (bl) {
            int n5 = n;
            while (n5 >= 0) {
                int n6 = n5 == n ? n2 : this.getColumnCount() - 1;
                int n7 = n6;
                while (n7 >= 0) {
                    String string2 = this.getValueAt(n5, n7).toUpperCase(Locale.getDefault());
                    int n8 = this.isSubstringIgnoreCase(string2, string);
                    if (n8 != -1) {
                        StringPos stringPos = new StringPos(string, n5, n7, n8);
                        this.setFoundLabel(stringPos);
                        return stringPos;
                    }
                    --n7;
                }
                --n5;
            }
        } else {
            int n9 = n;
            while (n9 < n3) {
                int n10 = n9 == n ? n2 : 0;
                int n11 = n10;
                while (n11 < n4) {
                    String string3 = this.getValueAt(n9, n11).toUpperCase(Locale.getDefault());
                    int n12 = this.isSubstringIgnoreCase(string3, string);
                    if (n12 != -1) {
                        StringPos stringPos = new StringPos(string, n9, n11, n12);
                        this.setFoundLabel(stringPos);
                        return stringPos;
                    }
                    ++n11;
                }
                ++n9;
            }
        }
        return null;
    }

    @Override
    public String getValueAt(int n, int n2) {
        TagEntry tagEntry = this.viewedInfoData.elementAt(n);
        switch (n2) {
            case 0: {
                return String.valueOf(this.leadingZeroHex(tagEntry.key >> 16 & 0xFFFF, 4).toUpperCase(Locale.getDefault())) + "," + this.leadingZeroHex((int)(tagEntry.key & 0xFFFF), 4).toUpperCase(Locale.getDefault());
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while (n3 < tagEntry.level) {
                    stringBuffer.append(">");
                    ++n3;
                }
                return stringBuffer.append(SPACE_STRING).append(this.mapNull(tagEntry.desc)).toString();
            }
        }
        return this.mapNull(tagEntry.data[n2 - 2]);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    protected JLabel customizeLabel(Object object, boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        TagEntry tagEntry = this.viewedInfoData.elementAt(n);
        this.label.setText(object.toString());
        if (!object.toString().trim().isEmpty()) {
            this.label.setToolTipText(object.toString());
        } else {
            this.label.setToolTipText(null);
        }
        if (bl) {
            this.label.setForeground(this.colorFgStandard);
            this.label.setBackground(this.colorBgStandard);
        } else {
            this.label.setForeground(Color.WHITE);
            if ((tagEntry.flags & 3) == 3) {
                this.label.setBackground(this.colorDicomPrivate);
            } else if ((tagEntry.flags & 3) == 2) {
                this.label.setBackground(this.colorPrivate);
            } else {
                this.label.setBackground(this.colorDicom);
            }
            if ((tagEntry.flags & 4) == 4) {
                this.label.setBackground(this.label.getBackground().brighter().brighter().brighter());
            }
        }
        if (bl2) {
            String string = this.label.getText();
            if (string.length() >= n3) {
                String string2 = string.substring(0, n3);
                try {
                    string2 = "<html> <font color=\"#" + this.bgColorString + "\">" + string2 + "</font>" + "<b>" + "<font color=\"#" + this.fgColorString + "\">" + string.substring(n3, n4) + "</font>" + "</b>" + "<font color=\"#" + this.bgColorString + "\">" + string.substring(n4) + "</font>" + "</html>";
                    this.label.setText(string2);
                }
                catch (Exception exception) {
                    log.warn("Error setting HTML formatted label in dicom tag table.", (Throwable)exception);
                }
            }
        } else {
            this.label.setForeground(this.colorFgStandard);
        }
        this.label.setVisible(true);
        return this.label;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        if (this.foundLabel != null && this.foundLabel.getRow() == n && this.foundLabel.getColumn() == n2) {
            bl3 = true;
            n3 = this.foundLabel.getColPos();
            n4 = n3 + this.foundLabel.string.length();
        }
        return this.customizeLabel(object, bl, bl3, n, n2, n3, n4);
    }

    public void storeAsHTML(OutputStream outputStream) throws IOException {
        Object object;
        String string;
        String string2;
        String string3 = "<html><head><title>IMPAX EE DICOM Tag Export</title></head><body>";
        outputStream.write(string3.getBytes());
        String string4 = "<h1><p align=\"center\">IMPAX EE DICOM Tag Export</p></h1>";
        outputStream.write(string4.getBytes());
        String string5 = "<table>";
        outputStream.write(string5.getBytes());
        String string6 = "<tr>";
        outputStream.write(string6.getBytes());
        int n = 0;
        while (n < this.getColumnCount()) {
            string2 = "<td><b>" + this.getColumnName(n) + "</b>" + "</td>";
            outputStream.write(string2.getBytes());
            ++n;
        }
        string2 = "</tr>";
        outputStream.write(string2.getBytes());
        int n2 = 0;
        while (n2 < this.getRowCount()) {
            string = "<tr>";
            outputStream.write(string.getBytes());
            n = 0;
            while (n < this.getColumnCount()) {
                object = this.customizeLabelIgnoreSearch(this.getValueAt(n2, n), false, n2, n);
                String string7 = "<td bgcolor=\"" + this.toWebColor(((Component)object).getBackground()) + "\"><font color=\"" + this.toWebColor(((Component)object).getForeground()) + "\">" + ((JLabel)object).getText() + "</font></td>";
                outputStream.write(string7.getBytes());
                ++n;
            }
            object = "</tr>";
            outputStream.write(((String)object).getBytes());
            ++n2;
        }
        string = "</table>";
        outputStream.write(string.getBytes());
        object = "</body>";
        outputStream.write(((String)object).getBytes());
    }

    private String toWebColor(Color color) {
        String string = this.leadingZero(Integer.toHexString(color.getRed()).toUpperCase(Locale.ENGLISH), 2);
        String string2 = this.leadingZero(Integer.toHexString(color.getGreen()).toUpperCase(Locale.ENGLISH), 2);
        String string3 = this.leadingZero(Integer.toHexString(color.getBlue()).toUpperCase(Locale.ENGLISH), 2);
        return "#" + string + string2 + string3;
    }

    private String leadingZero(String string, int n) {
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }

    private JLabel customizeLabelIgnoreSearch(Object object, boolean bl, int n, int n2) {
        return this.customizeLabel(object, bl, false, n, n2, 0, 0);
    }

    static class StringPos {
        private int row;
        private int column;
        private int colPos;
        private String string;

        StringPos(String string, int n, int n2, int n3) {
            this.row = n;
            this.column = n2;
            this.colPos = n3;
            this.string = string;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public int getColPos() {
            return this.colPos;
        }
    }

    protected static class TagEntry {
        public static final int DICOM = 1;
        public static final int PRIVATE = 2;
        public static final int SET = 4;
        public static final int DICOM_PRIVATE = 3;
        public Integer key;
        public String desc;
        public String[] data;
        public int level;
        public int flags;

        public TagEntry(int n, Integer n2, String string, String[] stringArray, int n3) {
            this.level = n;
            this.key = n2;
            this.desc = string;
            this.data = stringArray;
            this.flags = n3;
        }
    }
}

