/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.dicominfo;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.dicominfo.TagsTableModel;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class SimpleTagsTableModel
extends TagsTableModel {
    private static final long serialVersionUID = 1L;

    public SimpleTagsTableModel(Attributes attributes, IComponentFactory iComponentFactory) {
        super(iComponentFactory);
        this.evalDataset(attributes, 0);
    }

    private boolean isSequence(Attributes attributes, int n) {
        Object object = attributes.getValue(n);
        return object instanceof Sequence;
    }

    private boolean isFragment(Attributes attributes, int n) {
        Object object = attributes.getValue(n);
        return object instanceof Fragments;
    }

    private void evalDataset(Attributes attributes, int n) {
        int[] nArray;
        int[] nArray2 = nArray = attributes.tags();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string;
            VR vR;
            int n4 = nArray2[n3];
            int n5 = 1;
            if (TagUtils.isPrivateGroup((int)n4)) {
                n5 |= 2;
            }
            if (TagUtils.groupNumber((int)n4) == 65535) {
                vR = VR.LT;
                string = TagDictionary.getInstance().getPrivateTag(n4).getDescription();
            } else {
                vR = ElementDictionary.vrOf((int)n4, null);
                string = DicomUtils.getStandardNameForTag((int)n4);
            }
            if (string == null) {
                string = "";
            }
            if (!this.isFragment(attributes, n4)) {
                String string2;
                if (this.isSequence(attributes, n4)) {
                    this.addTagEntry(new TagsTableModel.TagEntry(n, n4, string, new String[]{"[" + Messages.getString("DcmInfoSetDlg.ThisIsASequence") + "]"}, n5));
                    string2 = attributes.getSequence(n4);
                    if (string2 != null) {
                        int n6 = 0;
                        while (n6 < string2.size()) {
                            this.evalDataset((Attributes)string2.get(n6), n + 1);
                            if (n6 != string2.size() - 1) {
                                this.addTagEntry(new TagsTableModel.TagEntry(n, -73507, "", new String[]{"[" + Messages.getString("DcmInfoSetDlg.Delimiter") + "]"}, n5));
                            }
                            ++n6;
                        }
                    }
                } else {
                    int n7;
                    int n8;
                    int[] nArray3;
                    Object[] objectArray;
                    string2 = null;
                    if (vR == VR.OB || vR == VR.OW || vR == VR.OF || vR == VR.UN) {
                        try {
                            byte[] byArray = attributes.getBytes(n4);
                            string2 = byArray.length + " bytes - ";
                            if (byArray.length < 64) {
                                try {
                                    string2 = String.valueOf(string2) + new String(byArray);
                                }
                                catch (Exception exception) {
                                    string2 = String.valueOf(string2) + SimpleTagsTableModel.bytesToString(byArray);
                                }
                            } else {
                                string2 = String.valueOf(string2) + SimpleTagsTableModel.bytesToString(byArray);
                            }
                        }
                        catch (IOException iOException) {
                            ALogger.getLogger(SimpleTagsTableModel.class).error("Bulk data error", (Throwable)iOException);
                        }
                    }
                    if (vR == VR.AT) {
                        StringBuilder stringBuilder = new StringBuilder();
                        nArray3 = objectArray = attributes.getInts(n4);
                        n8 = objectArray.length;
                        n7 = 0;
                        while (n7 < n8) {
                            int n9 = nArray3[n7];
                            stringBuilder.append("[");
                            stringBuilder.append(TagUtils.toString((int)n9));
                            stringBuilder.append(" ");
                            stringBuilder.append(ElementDictionary.keywordOf((int)n9, null));
                            stringBuilder.append("]");
                            ++n7;
                        }
                        string2 = stringBuilder.toString();
                    }
                    if (string2 == null) {
                        try {
                            StringBuilder stringBuilder = new StringBuilder();
                            nArray3 = objectArray = (Object[])attributes.getStrings(n4);
                            n8 = objectArray.length;
                            n7 = 0;
                            while (n7 < n8) {
                                int n10 = nArray3[n7];
                                stringBuilder.append((String)n10);
                                stringBuilder.append("\\");
                                ++n7;
                            }
                            if (objectArray.length > 0) {
                                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                            }
                            string2 = stringBuilder.toString();
                        }
                        catch (Exception exception) {
                            log.error("TagsTabelModel " + string + " " + vR, (Throwable)exception);
                        }
                    }
                    this.addTagEntry(new TagsTableModel.TagEntry(n, n4, string, new String[]{string2}, n5));
                }
            }
            ++n3;
        }
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }
}

