/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.dicominfo;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.dicominfo.SimpleTagsTableModel;
import com.agfa.pacs.listtext.lta.base.dicominfo.TagsTableModel;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class CompareTagsTableModel
extends TagsTableModel {
    private static final long serialVersionUID = 1L;
    private int objects;
    private boolean showDiffs;

    public CompareTagsTableModel(List<Attributes> list, boolean bl, IComponentFactory iComponentFactory) {
        super(iComponentFactory);
        this.columnNames = new String[]{Messages.getString("DcmInfoSetDlg.GroupElement"), Messages.getString("DcmInfoSetDlg.Description")};
        this.showDiffs = bl;
        this.objects = this.showDiffs ? list.size() : 1;
        this.evalDataset(list, 0);
    }

    private void evalDataset(List<Attributes> list, int n) {
        int n2;
        Object[] objectArray;
        Object object;
        Attributes attributes2;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Attributes attributes2 : list) {
            object = attributes2.tags();
            objectArray = object;
            int n3 = ((int[])object).length;
            n2 = 0;
            while (n2 < n3) {
                int n4 = objectArray[n2];
                if (attributes2.containsValue(n4)) {
                    hashSet.add(n4);
                }
                ++n2;
            }
        }
        attributes2 = list.get(0);
        Iterator<Object> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            if (ElementDictionary.vrOf((int)n5, null) == VR.SQ || n5 == 2145386512 || attributes2.getVR(n5) == VR.SQ) {
                iterator.remove();
                continue;
            }
            if (!(this.areDifferent(list, n5) ^ this.showDiffs)) continue;
            iterator.remove();
        }
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            String string;
            object = (Integer)iterator2.next();
            n2 = 1;
            if (((Integer)object & 0x10000) != 0) {
                n2 |= 2;
            }
            if ((string = TagUtils.groupNumber((int)((Integer)object)) == 65535 ? TagDictionary.getInstance().getPrivateTag((Integer)object).getDescription() : DicomUtils.getStandardNameForTag((int)((Integer)object))) == null) {
                string = "";
            }
            objectArray = new String[this.objects];
            int n6 = 0;
            while (n6 < this.objects) {
                Attributes attributes3 = list.get(n6);
                objectArray[n6] = attributes3.containsValue(((Integer)object).intValue()) ? (int)this.getData((Integer)object, attributes3) : (int)("[" + Messages.getString("DcmInfoSetDlg.None") + "]");
                ++n6;
            }
            this.addTagEntry(new TagsTableModel.TagEntry(n, (Integer)object, string, (String[])objectArray, n2));
        }
    }

    private String getData(int n, Attributes attributes) {
        int n2;
        int n3;
        int[] nArray;
        Object[] objectArray;
        Object object;
        String string = null;
        VR vR = TagUtils.groupNumber((int)n) == 65535 ? VR.LT : ElementDictionary.vrOf((int)n, null);
        if (vR == VR.OB || vR == VR.OW || vR == VR.OF || vR == VR.UN) {
            try {
                object = attributes.getBytes(n);
                string = ((byte[])object).length + " bytes - " + CompareTagsTableModel.bytesToString((byte[])object);
            }
            catch (IOException iOException) {
                ALogger.getLogger(SimpleTagsTableModel.class).error("Bulk data error", (Throwable)iOException);
            }
        }
        if (vR == VR.AT) {
            object = new StringBuilder();
            nArray = objectArray = attributes.getInts(n);
            n3 = objectArray.length;
            n2 = 0;
            while (n2 < n3) {
                int n4 = nArray[n2];
                ((StringBuilder)object).append("[");
                ((StringBuilder)object).append(TagUtils.toString((int)n4));
                ((StringBuilder)object).append(" ");
                ((StringBuilder)object).append(ElementDictionary.keywordOf((int)n4, null));
                ((StringBuilder)object).append("]");
                ++n2;
            }
            string = ((StringBuilder)object).toString();
        }
        if (string == null) {
            try {
                object = new StringBuilder();
                nArray = objectArray = (Object[])attributes.getStrings(n);
                n3 = objectArray.length;
                n2 = 0;
                while (n2 < n3) {
                    int n5 = nArray[n2];
                    ((StringBuilder)object).append((String)n5);
                    ((StringBuilder)object).append("\\");
                    ++n2;
                }
                if (objectArray.length > 0) {
                    ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
                }
                string = ((StringBuilder)object).toString();
            }
            catch (Exception exception) {
                log.error("TagsTabelModel  " + vR, (Throwable)exception);
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areDifferent(List<Attributes> list, Integer n) {
        try {
            Object object2;
            for (Object object2 : list) {
                if (object2.containsValue(n.intValue())) continue;
                return true;
            }
            object2 = list.get(0).getBytes(n.intValue());
            int n2 = 1;
            while (n2 < list.size()) {
                byte[] byArray = list.get(n2).getBytes(n.intValue());
                if (((Attributes)object2).length != byArray.length) {
                    return true;
                }
                int n3 = 0;
                while (n3 < ((Attributes)object2).length) {
                    if (object2[n3] != byArray[n3]) {
                        return true;
                    }
                    ++n3;
                }
                ++n2;
            }
            return false;
        }
        catch (IOException iOException) {
            ALogger.getLogger(CompareTagsTableModel.class).error("Bulk error", (Throwable)iOException);
            return false;
        }
    }

    @Override
    public String getColumnName(int n) {
        if (n < this.columnNames.length) {
            return this.columnNames[n];
        }
        if (this.showDiffs) {
            return String.valueOf(Messages.getString("DcmInfoSetDlg.Data")) + " " + (n - this.columnNames.length + 1);
        }
        return Messages.getString("DcmInfoSetDlg.SameData");
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length + this.objects;
    }
}

