/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.dicominfo;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.dicominfo.TagsTableModel;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.logging.ALogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class AbstractDicomInfoDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final ALogger log = ALogger.getLogger(AbstractDicomInfoDialog.class);
    private static final String EMPTY_STRING = "";
    private static final String EXTENSION_HTML = ".htm";
    private static final int ICON_HEIGHT_SMALL = 24;
    private static final int ICON_HEIGHT_LARGE = 82;
    private PIconFactory pifSmall;
    private PIconFactory pifLarge;
    private JLabel labelSubsets;
    private JButton buttonClear;
    private JButton buttonPrev;
    private JButton buttonNext;
    private JButton buttonSaveHTML;
    private JButton buttonExit;
    protected JTable tableTags;
    private JScrollPane scrollerTags;
    private JLabel labelSearch;
    private JTextField textSearchField;
    private JCheckBox checkShowDicom;
    private JCheckBox checkShowDicomPrivate;
    private Color colorTextNotFound;
    protected boolean showDicom = true;
    protected boolean showDicomPrivate = true;
    private int aktRow = 0;
    private int aktCol = 0;
    private IComponentFactory componentFactory;

    protected AbstractDicomInfoDialog(Window window, IComponentFactory iComponentFactory) {
        super(window);
        this.componentFactory = iComponentFactory;
        this.pifSmall = new PIconFactory(iComponentFactory, 24);
        this.pifLarge = new PIconFactory(iComponentFactory, 82);
        this.setTitle(Messages.getString("DicomInfoDialog.Title"));
        this.setResizable(true);
        this.setContentPane(this.createPanelContent());
        this.setDefaultCloseOperation(1);
    }

    private JPanel createPanelContent() {
        JPanel jPanel = this.componentFactory.createPanel((LayoutManager)new BorderLayout(5, 5));
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = this.componentFactory.createPanel((LayoutManager)new BorderLayout(5, 5));
        JPanel jPanel3 = this.componentFactory.createPanel((LayoutManager)new GridBagLayout());
        JPanel jPanel4 = this.componentFactory.createPanel((LayoutManager)new GridLayout(1, 1));
        JPanel jPanel5 = this.componentFactory.createPanel((LayoutManager)new BorderLayout());
        JPanel jPanel6 = this.componentFactory.createPanel((LayoutManager)new BorderLayout());
        JPanel jPanel7 = this.componentFactory.createPanel((LayoutManager)new BorderLayout(3, 3));
        JPanel jPanel8 = this.componentFactory.createPanel((LayoutManager)new GridLayout(1, 3, 3, 3));
        jPanel.add((Component)jPanel2, "North");
        MyActionListener myActionListener = new MyActionListener();
        this.checkShowDicom = this.componentFactory.createCheckBox(Messages.getString("DcmInfoSetDlg.DICOM"));
        this.checkShowDicom.setSelected(this.showDicom);
        this.checkShowDicom.addActionListener(myActionListener);
        jPanel5.add((Component)this.checkShowDicom, "Before");
        this.checkShowDicomPrivate = this.componentFactory.createCheckBox(Messages.getString("DcmInfoSetDlg.Private"));
        this.checkShowDicomPrivate.setSelected(this.showDicomPrivate);
        this.checkShowDicomPrivate.addActionListener(myActionListener);
        jPanel5.add((Component)this.checkShowDicomPrivate, "Center");
        jPanel6.add((Component)jPanel5, "Before");
        JPanel jPanel9 = this.getAdvancedComparePanel();
        if (jPanel9 != null) {
            jPanel6.add((Component)jPanel9, "Center");
        }
        this.buttonSaveHTML = this.componentFactory.createButton((Action)new ExportHTMLAction());
        jPanel6.add((Component)this.buttonSaveHTML, "After");
        this.textSearchField = this.componentFactory.createTextField(EMPTY_STRING);
        this.textSearchField.getDocument().addDocumentListener(new MyDocumentListener());
        this.textSearchField.setAction(new TextSearchAction());
        this.textSearchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!AbstractDicomInfoDialog.EMPTY_STRING.equals(((JTextField)keyEvent.getSource()).getText().trim())) {
                    switch (keyEvent.getKeyCode()) {
                        case 40: {
                            AbstractDicomInfoDialog.this.nextSearchResult();
                            break;
                        }
                        case 38: {
                            AbstractDicomInfoDialog.this.previousSearchResult();
                            break;
                        }
                        case 27: {
                            ((JTextField)keyEvent.getSource()).setText(AbstractDicomInfoDialog.EMPTY_STRING);
                        }
                    }
                } else {
                    switch (keyEvent.getKeyCode()) {
                        case 27: {
                            AbstractDicomInfoDialog.this.setVisible(false);
                        }
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        jPanel7.add((Component)this.textSearchField, "Center");
        this.buttonClear = this.componentFactory.createButton((Action)new ClearAction());
        jPanel8.add(this.buttonClear);
        this.buttonPrev = this.componentFactory.createButton((Action)new PreviousAction());
        jPanel8.add(this.buttonPrev);
        this.buttonNext = this.componentFactory.createButton((Action)new NextAction());
        jPanel8.add(this.buttonNext);
        jPanel7.add((Component)jPanel8, "East");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                AbstractDicomInfoDialog.this.textSearchField.requestFocusInWindow();
            }
        });
        jPanel2.add((Component)jPanel3, "Center");
        this.labelSubsets = this.componentFactory.createLabel(String.valueOf(Messages.getString("DcmInfoSetDlg.SubSets")) + ':');
        this.labelSubsets.setHorizontalAlignment(2);
        this.addComponent(jPanel3, 0, 0, 1, 0.0, this.labelSubsets, 0);
        this.addComponent(jPanel3, 1, 0, 1, 1.0, jPanel6, 2);
        this.labelSearch = this.componentFactory.createLabel(String.valueOf(Messages.getString("DcmInfoSetDlg.Search")) + ':');
        this.labelSearch.setHorizontalAlignment(2);
        this.addComponent(jPanel3, 0, 1, 1, 0.0, this.labelSearch, 0);
        this.addComponent(jPanel3, 1, 1, 1, 1.0, jPanel7, 2);
        this.buttonExit = this.componentFactory.createButton((Action)new ExitAction());
        this.buttonExit.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel4.add(this.buttonExit);
        jPanel2.add((Component)jPanel4, "East");
        this.tableTags = this.componentFactory.createTable(null);
        this.tableTags.getTableHeader().setReorderingAllowed(false);
        this.tableTags.getColumnModel().setColumnSelectionAllowed(true);
        this.scrollerTags = new JScrollPane(this.tableTags);
        jPanel.add((Component)this.scrollerTags, "Center");
        this.colorTextNotFound = LTAUtil.isOnColorMonitor() ? new Color(255, 102, 102) : new Color(205, 205, 205);
        this.buttonClear.setEnabled(false);
        this.setSearchButtonsEnabled(false);
        return jPanel;
    }

    protected JPanel getAdvancedComparePanel() {
        return null;
    }

    private void addComponent(JPanel jPanel, int n, int n2, int n3, double d, Component component, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = n4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add(component, gridBagConstraints);
    }

    protected void checkSearch() {
        String string = this.textSearchField.getText();
        if (string != null && string.length() > 0) {
            this.searchTagsAndUpdateSearchField(string, true, false);
        }
    }

    protected boolean searchTagsAndUpdateSearchField(String string, boolean bl, boolean bl2) {
        boolean bl3 = this.searchTags(string, bl, bl2);
        this.setTextSearchFieldBG(bl3);
        this.setSearchButtonsEnabled(true);
        return bl3;
    }

    private void setSearchButtonsEnabled(boolean bl) {
        this.buttonPrev.setEnabled(bl);
        this.buttonNext.setEnabled(bl);
    }

    private void setTextSearchFieldBG(boolean bl) {
        if (!bl) {
            this.textSearchField.setBackground(this.colorTextNotFound);
        } else {
            this.textSearchField.setBackground(Color.WHITE);
        }
    }

    private void previousSearchResult() {
        if (!EMPTY_STRING.equals(this.textSearchField.getText().trim())) {
            TableModel tableModel = this.tableTags.getModel();
            if (tableModel instanceof TagsTableModel) {
                boolean bl;
                TagsTableModel.StringPos stringPos = ((TagsTableModel)tableModel).getFoundLabel();
                --this.aktCol;
                if (this.aktCol < 0) {
                    this.aktCol = tableModel.getColumnCount() - 1;
                    if (this.aktRow > 0) {
                        --this.aktRow;
                    }
                }
                if (!(bl = this.searchTagsAndUpdateSearchField(this.textSearchField.getText(), false, true)) && stringPos != null) {
                    this.aktRow = stringPos.getRow();
                    this.aktCol = stringPos.getColumn();
                }
            }
            this.textSearchField.requestFocusInWindow();
        }
    }

    private void nextSearchResult() {
        if (!EMPTY_STRING.equals(this.textSearchField.getText().trim())) {
            TableModel tableModel = this.tableTags.getModel();
            if (tableModel instanceof TagsTableModel) {
                boolean bl;
                TagsTableModel.StringPos stringPos = ((TagsTableModel)tableModel).getFoundLabel();
                ++this.aktCol;
                this.aktCol %= tableModel.getColumnCount();
                if (this.aktCol == 0 && tableModel.getRowCount() > this.aktRow) {
                    ++this.aktRow;
                }
                if (!(bl = this.searchTagsAndUpdateSearchField(this.textSearchField.getText(), false, false)) && stringPos != null) {
                    this.aktRow = stringPos.getRow();
                    this.aktCol = stringPos.getColumn();
                }
            }
            this.textSearchField.requestFocusInWindow();
        }
    }

    private boolean searchTags(String string, boolean bl, boolean bl2) {
        TableModel tableModel;
        boolean bl3 = false;
        if (bl) {
            this.aktCol = 0;
            this.aktRow = 0;
        }
        if ((tableModel = this.tableTags.getModel()) instanceof TagsTableModel) {
            TagsTableModel tagsTableModel = (TagsTableModel)tableModel;
            TagsTableModel.StringPos stringPos = tagsTableModel.search(string, this.aktRow, this.aktCol, bl2);
            if (stringPos != null) {
                this.aktRow = stringPos.getRow();
                this.aktCol = stringPos.getColumn();
                JViewport jViewport = this.scrollerTags.getViewport();
                Rectangle rectangle = this.tableTags.getCellRect(this.aktRow, 0, true);
                jViewport.setViewPosition(new Point(0, rectangle.y));
                bl3 = true;
            } else {
                bl3 = false;
            }
        }
        return bl3;
    }

    protected void setTableColumnModelPrefs(TagsTableModel tagsTableModel) {
        TableColumnModel tableColumnModel = this.tableTags.getColumnModel();
        tableColumnModel.getColumn(0).setMinWidth(40);
        tableColumnModel.getColumn(0).setPreferredWidth(140);
        tableColumnModel.getColumn(0).setMaxWidth(140);
        tableColumnModel.getColumn(1).setMinWidth(20);
        tableColumnModel.getColumn(1).setPreferredWidth(250);
        tableColumnModel.getColumn(1).setMaxWidth(1000);
        int n = tableColumnModel.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            tableColumnModel.getColumn(n2).setCellRenderer(tagsTableModel);
            ++n2;
        }
    }

    private void showDicomTags(boolean bl) {
        this.showDicom = bl;
        this.checkShowDicom.setSelected(this.showDicom);
        this.notifyTable();
    }

    private void showDicomPrivateTags(boolean bl) {
        this.showDicomPrivate = bl;
        this.checkShowDicomPrivate.setSelected(this.showDicomPrivate);
        this.notifyTable();
    }

    private void notifyTable() {
        TableModel tableModel = this.tableTags.getModel();
        if (tableModel instanceof TagsTableModel) {
            TagsTableModel tagsTableModel = (TagsTableModel)tableModel;
            tagsTableModel.show(this.showDicom, this.showDicomPrivate);
        }
    }

    private class ClearAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ClearAction() {
            super(null, (Icon)AbstractDicomInfoDialog.this.pifSmall.loadIcon(AbstractDicomInfoDialog.class, "close.svg"));
            super.putValue("ShortDescription", Messages.getString("DcmInfoSetDlg.ClearTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDicomInfoDialog.this.textSearchField.setText(AbstractDicomInfoDialog.EMPTY_STRING);
            AbstractDicomInfoDialog.this.textSearchField.requestFocusInWindow();
        }
    }

    private class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ExitAction() {
            super(null, (Icon)AbstractDicomInfoDialog.this.pifLarge.loadIcon(AbstractDicomInfoDialog.class, "2237_close-panel.svg"));
            super.putValue("ShortDescription", Messages.getString("DcmInfoSetDlg.CloseTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDicomInfoDialog.this.setVisible(false);
        }
    }

    private class ExportHTMLAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ExportHTMLAction() {
            super(Messages.getString("DcmInfoSetDlg.Html"), (Icon)AbstractDicomInfoDialog.this.pifSmall.loadIcon(AbstractDicomInfoDialog.class, "2052_Export2.svg"));
            super.putValue("ShortDescription", Messages.getString("DcmInfoSetDlg.HtmlTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return true;
                }

                @Override
                public String getDescription() {
                    return Messages.getString("DcmInfoSetDlg.HTMLFiles");
                }

                public String toString() {
                    return this.getDescription();
                }
            };
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setDialogTitle(Messages.getString("DcmInfoSetDlg.SaveAsHTML"));
            jFileChooser.addChoosableFileFilter(fileFilter);
            jFileChooser.invalidate();
            if (jFileChooser.showSaveDialog(AbstractDicomInfoDialog.this) == 0) {
                Object object;
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                if (!file.getName().endsWith(AbstractDicomInfoDialog.EXTENSION_HTML)) {
                    object = String.valueOf(file.getPath()) + AbstractDicomInfoDialog.EXTENSION_HTML;
                    file = new File((String)object);
                }
                if ((object = AbstractDicomInfoDialog.this.tableTags.getModel()) instanceof TagsTableModel) {
                    TagsTableModel tagsTableModel = (TagsTableModel)object;
                    try {
                        log.info("Storing Dicom Tags as " + file.getAbsolutePath());
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        tagsTableModel.storeAsHTML(bufferedOutputStream);
                        bufferedOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        log.error("Error writing HTML export to file.", (Throwable)exception);
                    }
                }
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AbstractDicomInfoDialog.this.checkShowDicom) {
                AbstractDicomInfoDialog.this.showDicomTags(AbstractDicomInfoDialog.this.checkShowDicom.isSelected());
                return;
            }
            if (actionEvent.getSource() == AbstractDicomInfoDialog.this.checkShowDicomPrivate) {
                AbstractDicomInfoDialog.this.showDicomPrivateTags(AbstractDicomInfoDialog.this.checkShowDicomPrivate.isSelected());
                return;
            }
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            AbstractDicomInfoDialog.this.searchTagsAndUpdateSearchField(AbstractDicomInfoDialog.this.textSearchField.getText(), true, false);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            AbstractDicomInfoDialog.this.searchTagsAndUpdateSearchField(AbstractDicomInfoDialog.this.textSearchField.getText(), true, false);
            AbstractDicomInfoDialog.this.buttonClear.setEnabled(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            AbstractDicomInfoDialog.this.searchTagsAndUpdateSearchField(AbstractDicomInfoDialog.this.textSearchField.getText(), true, false);
            if (AbstractDicomInfoDialog.this.textSearchField.getText().isEmpty()) {
                AbstractDicomInfoDialog.this.setSearchButtonsEnabled(false);
                AbstractDicomInfoDialog.this.buttonClear.setEnabled(false);
            }
        }
    }

    private class NextAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NextAction() {
            super(null, (Icon)AbstractDicomInfoDialog.this.pifSmall.loadIcon(AbstractDicomInfoDialog.class, "next_item.svg"));
            super.putValue("ShortDescription", Messages.getString("DcmInfoSetDlg.NextTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDicomInfoDialog.this.nextSearchResult();
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public PreviousAction() {
            super(null, (Icon)AbstractDicomInfoDialog.this.pifSmall.loadIcon(AbstractDicomInfoDialog.class, "previous_item.svg"));
            super.putValue("ShortDescription", Messages.getString("DcmInfoSetDlg.PreviousTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDicomInfoDialog.this.previousSearchResult();
        }
    }

    private class TextSearchAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public TextSearchAction() {
            super.putValue("ShortDescription", Messages.getString("DcmInfoSetDlg.TextSearchTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDicomInfoDialog.this.nextSearchResult();
        }
    }
}

