/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.task.ITaskTerminationListener;
import com.agfa.pacs.listtext.lta.progress.ProgressManagerFactory;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import com.agfa.pacs.listtext.lta.util.DicomMoveUtils;
import com.agfa.pacs.listtext.lta.util.job.JobControl;
import com.agfa.pacs.logging.ALogger;
import java.util.List;

class SingleCMoveTask
implements Runnable {
    private static final ALogger LOGGER = ALogger.getLogger(SingleCMoveTask.class);
    private static final String NAME = Messages.getString("StudyShare.CMoveTask.Name");
    private final IDicomNode sourceNode;
    private final String destinationAET;
    private final List<IStudyInfo> studies;
    private final ITaskTerminationListener listener;
    private boolean isSuccessful;

    SingleCMoveTask(IDicomNode iDicomNode, String string, List<IStudyInfo> list, ITaskTerminationListener iTaskTerminationListener) {
        this.sourceNode = iDicomNode;
        this.destinationAET = string;
        this.studies = list;
        this.listener = iTaskTerminationListener;
    }

    @Override
    public void run() {
        try {
            this.isSuccessful = this.execute();
        }
        finally {
            this.listener.onTaskFinish();
        }
    }

    boolean isSuccessful() {
        return this.isSuccessful;
    }

    private boolean execute() {
        DicomMoveUtils.MoveResult moveResult;
        ProgressStateModel progressStateModel;
        block4: {
            progressStateModel = ProgressManagerFactory.getManager().createAndAddProgress();
            progressStateModel.setDetailedMessage(JobControl.createDetailedInformation((String)NAME, (String)this.destinationAET, this.studies));
            moveResult = DicomMoveUtils.moveInstancesSync((IDicomNode)this.sourceNode, (String)this.destinationAET, this.studies, (ProgressState)progressStateModel);
            if (moveResult != DicomMoveUtils.MoveResult.MOVE_SUCCESSFUL) break block4;
            progressStateModel.setState(JobState.FINISHED);
            return true;
        }
        try {
            if (moveResult == DicomMoveUtils.MoveResult.MOVE_NOT_CONFIGURED) {
                LOGGER.error("Unknown destination AE Title: " + this.destinationAET);
            }
        }
        catch (Exception exception) {
            LOGGER.error("C-Move to Connect archive failed.", (Throwable)exception);
            progressStateModel.setStateMessage(exception.getLocalizedMessage());
        }
        progressStateModel.setState(JobState.FAILED);
        return false;
    }
}

