/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.auditing.ReferencedData;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.IPermissionTask;
import com.agfa.pacs.listtext.lta.base.connect.IStudySharePermissionOptions;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareParameter;
import com.agfa.pacs.listtext.lta.base.connect.task.AbstractPermissionTask;
import com.agfa.pacs.listtext.lta.base.connect.task.AbstractStudyShareTask;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.EventTypeCode;

class PermissionChangeTask
extends AbstractPermissionTask {
    private static final String NAME = Messages.getString("StudyShare.PermissionChangeTask.Name");
    private static final String ACTION_NAME = "eaModify";
    private final IPermissionTask query;

    PermissionChangeTask(IPermissionTask iPermissionTask, IStudySharePermissionOptions iStudySharePermissionOptions) {
        super(iStudySharePermissionOptions, false, iPermissionTask.getSessionCookie());
        this.query = iPermissionTask;
    }

    public String getInfo() {
        return NAME;
    }

    @Override
    public List<? extends IStudyInfo> getStudies() {
        return this.query.getStudies();
    }

    @Override
    public boolean execute() {
        if (this.query.getResult() == null) {
            return false;
        }
        AuditMessage auditMessage = new AuditMessage();
        EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.SecurityAlert, (String)"E", null, (String)"0", null, (EventTypeCode[])new EventTypeCode[]{AuditMessages.EventTypeCode.SecurityConfiguration});
        auditMessage.setEventIdentification(eventIdentification);
        ReferencedData referencedData = Audit.getInstance().prepareReferencedData(DataInfoUtilities.forAuditing(this.getStudies()));
        referencedData.addToMessage(auditMessage);
        boolean bl = super.execute();
        Audit.getInstance().logAuditMessage(auditMessage, bl ? "0" : "8");
        return bl;
    }

    @Override
    Map<StudyShareParameter, String> getRequestParameters() {
        EnumMap<StudyShareParameter, String> enumMap = new EnumMap<StudyShareParameter, String>(StudyShareParameter.class);
        enumMap.put(StudyShareParameter.EXPIRATION_DATE, Long.toString(this.getRoundedUpExpirationDate()));
        enumMap.put(StudyShareParameter.ACTION, ACTION_NAME);
        enumMap.put(StudyShareParameter.PERMISSION, Integer.toString(this.options.getPermission().getCode()));
        enumMap.put(StudyShareParameter.IDS, this.query.getResult().getInternalIDs());
        return enumMap;
    }

    @Override
    AbstractStudyShareTask.RetrySettings getRetrySettings() {
        return AbstractStudyShareTask.RetrySettings.DEFAULT;
    }
}

