/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.IPermissionTask;
import com.agfa.pacs.listtext.lta.base.connect.IStudyShareData;
import com.agfa.pacs.listtext.lta.base.connect.IStudySharePDFOptions;
import com.agfa.pacs.listtext.lta.base.connect.IStudySharePermissionOptions;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareConfig;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareParameter;
import com.agfa.pacs.listtext.lta.base.connect.task.AbstractStudyShareTask;
import com.agfa.pacs.tools.StreamUtil;
import com.agfa.pacs.tools.TempDirectoryProvider;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentDisposition;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ParseException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcm4che3.data.PersonName;

public class PDFCreationTask
extends AbstractStudyShareTask {
    private static final String NAME = Messages.getString("StudyShare.PDFCreationTask.Name");
    private static final Pattern FORBIDDEN_XML_CHARACTERS = Pattern.compile("<|>|&");
    private final IPermissionTask permissionsTask;
    private final IStudySharePDFOptions pdfOptions;
    private File pdf;
    private List<IStudyInfo> studies;
    private static File webAccessTmpDir;

    public PDFCreationTask(IPermissionTask iPermissionTask, IStudySharePermissionOptions iStudySharePermissionOptions, IStudySharePDFOptions iStudySharePDFOptions, List<IStudyInfo> list) {
        super(iStudySharePermissionOptions, iPermissionTask.getSessionCookie());
        this.permissionsTask = iPermissionTask;
        this.pdfOptions = iStudySharePDFOptions;
        this.studies = list;
    }

    public String getInfo() {
        return NAME;
    }

    public File getPDF() {
        return this.pdf;
    }

    public boolean execute() {
        if (this.permissionsTask.getResult() == null) {
            this.log.warn("No study permission data available.");
            return false;
        }
        try {
            this.executeTask();
        }
        catch (Exception exception) {
            this.log.error("Retrieving PDF with study sharing access data failed.", (Throwable)exception);
            this.pdf = null;
        }
        return this.pdf != null;
    }

    @Override
    String getRequestURLPath() {
        return "portal/servlet/PdfServlet";
    }

    @Override
    Map<StudyShareParameter, String> getRequestParameters() {
        IStudyShareData iStudyShareData = this.permissionsTask.getResult();
        EnumMap<StudyShareParameter, String> enumMap = new EnumMap<StudyShareParameter, String>(StudyShareParameter.class);
        enumMap.put(StudyShareParameter.ACTION, "eaPdf");
        enumMap.put(StudyShareParameter.PATIENT_BIRTHDATE, iStudyShareData.getPatientBirthDate());
        enumMap.put(StudyShareParameter.PDF_DATA, this.createPDFData(iStudyShareData));
        enumMap.put(StudyShareParameter.QR_CODE, Boolean.toString(this.pdfOptions.isQRCodeEnabled()));
        enumMap.put(StudyShareParameter.QR_CODE_SERVLET_URL, this.getInternalURL("portal/servlet/QrCodeServlet?"));
        return enumMap;
    }

    @Override
    AbstractStudyShareTask.RetrySettings getRetrySettings() {
        return AbstractStudyShareTask.RetrySettings.DEFAULT;
    }

    @Override
    boolean readResponse(HttpURLConnection httpURLConnection) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            Object object;
            if (webAccessTmpDir == null) {
                webAccessTmpDir = TempDirectoryProvider.createTempDirectory((String)"webaccess").toFile();
            }
            String string = null;
            String string2 = httpURLConnection.getHeaderField("Content-Disposition");
            if (string2 != null) {
                try {
                    object = new ContentDisposition(string2);
                    String string3 = object.getParameter("filename");
                    if (string3 != null && string3.length() > 0) {
                        string = string3;
                    }
                }
                catch (ParseException parseException) {
                    this.log.error("Failed to parse Content-Disposition on PDF download: " + string2, (Throwable)parseException);
                }
            }
            object = string == null ? File.createTempFile("external-access-", ".pdf", webAccessTmpDir) : new File(webAccessTmpDir, string);
            fileOutputStream = new FileOutputStream((File)object);
            StreamUtil.copyStream((InputStream)httpURLConnection.getInputStream(), (OutputStream)fileOutputStream);
            this.pdf = object;
            return true;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.log.warn("Closing stream failed.", (Throwable)iOException);
                }
            }
        }
    }

    private String createPDFData(IStudyShareData iStudyShareData) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<pdfData>");
        stringBuilder.append("<instDescription>");
        stringBuilder.append(this.removeForbiddenXmlCharacters(this.pdfOptions.getInstitutionName()));
        stringBuilder.append("</instDescription>");
        String string = this.getConfiguredPatientIdentification();
        if (string != null) {
            stringBuilder.append("<patientname>");
            stringBuilder.append(string);
            stringBuilder.append("</patientname>");
        }
        stringBuilder.append("<princDescription>");
        stringBuilder.append(this.removeForbiddenXmlCharacters(this.pdfOptions.getDepartmentName()));
        stringBuilder.append("</princDescription>");
        stringBuilder.append("<access_code>");
        stringBuilder.append(iStudyShareData.getAccessCode());
        stringBuilder.append("</access_code>");
        stringBuilder.append("<permission>");
        stringBuilder.append((Object)this.options.getPermission());
        stringBuilder.append("</permission>");
        stringBuilder.append("<expirationDate>");
        stringBuilder.append(StudyShareParameter.formatDate(this.options.getExpirationDate()));
        stringBuilder.append("</expirationDate>");
        stringBuilder.append("<baseUrl>");
        stringBuilder.append(StudyShareConfig.getExternalBaseURL());
        stringBuilder.append("</baseUrl>");
        stringBuilder.append("<date>");
        stringBuilder.append(StudyShareParameter.formatDate(new Date()));
        stringBuilder.append("</date>");
        stringBuilder.append("<studyCount>");
        stringBuilder.append(iStudyShareData.getStudyCount());
        stringBuilder.append("</studyCount>");
        stringBuilder.append("<defaultText/>");
        stringBuilder.append("</pdfData>");
        return stringBuilder.toString();
    }

    private String getConfiguredPatientIdentification() {
        switch (StudyShareConfig.getPatientIdentificationType()) {
            case NONE: {
                return null;
            }
            case PATIENT_NAME: {
                String string = this.studies.get(0).getAttributes().getString(0x100010);
                return PersonNameUtilities.personNameToHRReverse((PersonName)new PersonName(string, true));
            }
            case PATIENT_ID: {
                return this.studies.get(0).getAttributes().getString(0x100020);
            }
            case PATIENT_INITIALS: {
                return this.getInitialsFromPatientName(this.studies.get(0).getAttributes().getString(0x100010));
            }
        }
        return null;
    }

    private String getInitialsFromPatientName(String string) {
        PersonName personName = new PersonName(string, true);
        String string2 = personName.get(PersonName.Component.GivenName);
        String string3 = personName.get(PersonName.Component.MiddleName);
        String string4 = personName.get(PersonName.Component.FamilyName);
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(string2.substring(0, 1).toUpperCase(Locale.getDefault()));
            stringBuffer.append(".");
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(string3.substring(0, 1).toUpperCase(Locale.getDefault()));
            stringBuffer.append(".");
        }
        if (string4 != null && string4.length() > 0) {
            stringBuffer.append(string4.substring(0, 1).toUpperCase(Locale.getDefault()));
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    private String removeForbiddenXmlCharacters(String string) {
        Matcher matcher = FORBIDDEN_XML_CHARACTERS.matcher(string);
        if (matcher.find()) {
            this.log.warn("Removing forbidden XML characters from string: " + string);
            return matcher.replaceAll("");
        }
        return string;
    }
}

