/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.connect.IStudySharePermissionOptions;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareParameter;
import com.agfa.pacs.listtext.lta.base.connect.task.AbstractPermissionTask;
import java.util.Collections;
import java.util.List;

abstract class AbstractStudyPermissionTask
extends AbstractPermissionTask {
    private final List<IStudyInfo> studies;

    AbstractStudyPermissionTask(List<IStudyInfo> list, IStudySharePermissionOptions iStudySharePermissionOptions, boolean bl) {
        super(iStudySharePermissionOptions, bl);
        this.studies = list;
    }

    @Override
    public List<? extends IStudyInfo> getStudies() {
        return Collections.unmodifiableList(this.studies);
    }

    public String getPatientBirthDate() {
        return StudyShareParameter.formatDate(this.studies.get(0).getPatient().getDate(0x100030));
    }

    public int getStudyCount() {
        return this.studies.size();
    }

    String getStudyUIDs() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IStudyInfo iStudyInfo : this.studies) {
            stringBuilder.append(iStudyInfo.getStudyUID());
            stringBuilder.append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

