/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.pacs.listtext.lta.base.connect.IPermissionTask;
import com.agfa.pacs.listtext.lta.base.connect.IStudyShareData;
import com.agfa.pacs.listtext.lta.base.connect.IStudySharePermissionOptions;
import com.agfa.pacs.listtext.lta.base.connect.exception.StudiesAlreadySharedException;
import com.agfa.pacs.listtext.lta.base.connect.exception.StudyShareAuthenticationException;
import com.agfa.pacs.listtext.lta.base.connect.exception.StudyShareException;
import com.agfa.pacs.listtext.lta.base.connect.task.AbstractStudyShareTask;
import com.agfa.pacs.listtext.lta.base.connect.xml.StudyAccess;
import com.agfa.pacs.listtext.lta.base.connect.xml.XmlUtilities;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.w3c.dom.Node;

abstract class AbstractPermissionTask
extends AbstractStudyShareTask
implements IPermissionTask {
    protected static final String ERROR_NODE_NAME = "error";
    private static final String EMPTY_RESULT_NODE_NAME = "noResult";
    private static final String INSUFFICIENT_STUDY_PERMISSION_ERROR_MESSAGE = "insufficient studypermission for creating webaccess!";
    private IStudyShareData result;
    private final boolean isEmptyResultAllowed;

    AbstractPermissionTask(IStudySharePermissionOptions iStudySharePermissionOptions, boolean bl) {
        super(iStudySharePermissionOptions);
        this.isEmptyResultAllowed = bl;
    }

    AbstractPermissionTask(IStudySharePermissionOptions iStudySharePermissionOptions, boolean bl, String string) {
        super(iStudySharePermissionOptions, string);
        this.isEmptyResultAllowed = bl;
    }

    @Override
    public String getSessionCookie() {
        return super.getSessionCookie();
    }

    @Override
    public IStudyShareData getResult() {
        return this.result;
    }

    void setResult(IStudyShareData iStudyShareData) {
        this.result = iStudyShareData;
    }

    long getRoundedUpExpirationDate() {
        return DateUtils.ceiling((Date)this.options.getExpirationDate(), (int)5).getTime() - 1L;
    }

    public boolean execute() {
        try {
            this.executeTask();
        }
        catch (StudyShareAuthenticationException studyShareAuthenticationException) {
            this.log.warn("Authentication for Internet study shared failed.");
            this.setFailureMessage(studyShareAuthenticationException.getLocalizedMessage());
            this.result = null;
        }
        catch (StudiesAlreadySharedException studiesAlreadySharedException) {
            this.log.warn("Studies have already been shared.");
            this.setFailureMessage(studiesAlreadySharedException.getLocalizedMessage());
            this.result = null;
        }
        catch (Exception exception) {
            this.log.error("Setting study permissions failed.", (Throwable)exception);
            this.result = null;
        }
        return this.result != null;
    }

    @Override
    public String getFailureDescription() {
        return this.getFailureMessage();
    }

    @Override
    String getRequestURLPath() {
        return "portal/servlet/ExternalAccessServlet";
    }

    @Override
    boolean readResponse(HttpURLConnection httpURLConnection) throws IOException, StudyShareException {
        Node node = XmlUtilities.createDocumentRoot(httpURLConnection.getInputStream());
        String string = node.getNodeName().equalsIgnoreCase(ERROR_NODE_NAME) ? XmlUtilities.getNodeValue(node) : XmlUtilities.findNodeValue(node, ERROR_NODE_NAME);
        if (string != null) {
            if (string.equals("External Access already created!")) {
                throw new StudiesAlreadySharedException();
            }
            if (string.equals(INSUFFICIENT_STUDY_PERMISSION_ERROR_MESSAGE)) {
                if (this.isEmptyResultAllowed) {
                    this.result = IStudyShareData.NONE;
                    return true;
                }
                if (this.getRetrySettings().isInsufficientStudyPermissionRetryEnabled()) {
                    this.log.debug("Study permissions not yet set, retrying ...");
                    return false;
                }
            }
            throw new StudyShareException(string);
        }
        this.result = this.isEmptyResultAllowed && node.getNodeName().equalsIgnoreCase(EMPTY_RESULT_NODE_NAME) ? IStudyShareData.NONE : StudyAccess.parseNodes(XmlUtilities.findAllNodes(node, "studyaccess"));
        return true;
    }
}

