/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.IStudyShareAction;
import com.agfa.pacs.listtext.lta.base.connect.IStudyShareSettings;
import com.agfa.pacs.listtext.lta.base.connect.StudiesListTableModel;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareConfig;
import com.agfa.pacs.listtext.lta.base.connect.StudySharePDFOptions;
import com.agfa.pacs.listtext.lta.base.connect.StudySharePermissionOptions;
import com.agfa.pacs.listtext.lta.base.controls.PermissionUtilities;
import com.agfa.pacs.security.permission.Permissions;
import com.agfa.pacs.tools.OpenLink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

abstract class AbstractStudyShareAction
implements IStudyShareAction {
    final IComponentFactory componentFactory;

    AbstractStudyShareAction(IComponentFactory iComponentFactory) {
        this.componentFactory = iComponentFactory;
    }

    @Override
    public boolean isEnabled() {
        return this.hasPermission() && (!StudyShareConfig.getUseSeparateArchive() || StudyShareConfig.getDestinationAET().trim().length() > 0) && StudyShareConfig.getInternalURL().trim().length() > 0 && StudyShareConfig.getExternalBaseURL().trim().length() > 0;
    }

    private boolean hasPermission() {
        return Permissions.getInstance().isAllowed("Export/InternetStudyShare");
    }

    @Override
    public void perform(Component component, List<IStudyInfo> list) {
        if (!this.checkPreconditions(component, list)) {
            return;
        }
        this.performImpl(component, list);
    }

    abstract void performImpl(Component var1, List<IStudyInfo> var2);

    private boolean checkPreconditions(Component component, List<IStudyInfo> list) {
        Object object2;
        if (!this.hasPermission()) {
            PermissionUtilities.showPermissionDeniedDialog(component, null);
            return false;
        }
        if (!this.isEnabled()) {
            this.informUserOfUnfulfilledPrecondition(component, Messages.getString("StudyShareAction.IncompleteConfiguration.Message"));
            return false;
        }
        if (list == null || list.isEmpty()) {
            this.informUserOfUnfulfilledPrecondition(component, Messages.getString("StudyShareAction.EmptySelection.Message"));
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : list) {
            hashSet.add(object2.getPatient().getKey());
        }
        if (hashSet.size() != 1) {
            this.informUserOfUnfulfilledPrecondition(component, Messages.getString("StudyShareAction.MultiPatientSelection.Message"));
            return false;
        }
        object2 = list.get(0).getPatient().getDate(0x100030);
        if (object2 == null) {
            this.informUserOfUnfulfilledPrecondition(component, Messages.getString("StudyShareAction.MissingPatientBirthdate.Message"));
            return false;
        }
        return true;
    }

    JPanel createDialog(List<IStudyInfo> list, Component component, Component component2) {
        JPanel jPanel = this.componentFactory.createPanel((LayoutManager)new BorderLayout(0, this.componentFactory.scaleInt(10)));
        jPanel.add((Component)this.createStudiesPanel(list), "North");
        if (component != null) {
            jPanel.add(component, "Center");
        }
        if (component2 != null) {
            jPanel.add(component2, "South");
        }
        return jPanel;
    }

    private JPanel createStudiesPanel(List<IStudyInfo> list) {
        StudiesListTableModel studiesListTableModel = new StudiesListTableModel(list);
        JPanel jPanel = this.componentFactory.createPanel((LayoutManager)new BorderLayout(0, this.componentFactory.scaleInt(5)));
        jPanel.setBorder(this.componentFactory.createTitledBorder(MessageFormat.format(Messages.getString("StudyShareAction.StudiesPanel.Title"), studiesListTableModel.getPatientName())));
        JTable jTable = this.componentFactory.createTable((TableModel)studiesListTableModel);
        jTable.setRowSelectionAllowed(false);
        jTable.setColumnSelectionAllowed(false);
        jTable.setCellSelectionEnabled(false);
        int n = 600;
        int n2 = 140;
        int n3 = 100;
        jTable.setPreferredScrollableViewportSize(this.componentFactory.scaleDimension(n, 100));
        jTable.getColumnModel().getColumn(0).setPreferredWidth(this.componentFactory.scaleInt(n2));
        jTable.getColumnModel().getColumn(1).setPreferredWidth(this.componentFactory.scaleInt(n - n2 - n3));
        jTable.getColumnModel().getColumn(2).setPreferredWidth(this.componentFactory.scaleInt(n3));
        JScrollPane jScrollPane = this.componentFactory.createScrollPane((Component)jTable);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    StudySharePDFOptions createPDFOptions() {
        StudySharePDFOptions studySharePDFOptions = new StudySharePDFOptions(this.componentFactory);
        studySharePDFOptions.setBorder(this.componentFactory.createTitledBorder(Messages.getString("StudyShareAction.PDFOptionsPanel.Title")));
        return studySharePDFOptions;
    }

    StudySharePermissionOptions createPermissionOptions(IStudyShareSettings iStudyShareSettings, boolean bl) {
        StudySharePermissionOptions studySharePermissionOptions = new StudySharePermissionOptions(this.componentFactory, iStudyShareSettings, bl);
        studySharePermissionOptions.setBorder(this.componentFactory.createTitledBorder(Messages.getString("StudyShareAction.OptionsPanel.Title")));
        return studySharePermissionOptions;
    }

    private void informUserOfUnfulfilledPrecondition(Component component, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("StudyShareAction.UnfulfilledPrecondition.Message"));
        if (string != null) {
            stringBuilder.append('\n');
            stringBuilder.append(string);
        }
        this.showErrorDialog(Messages.getString("StudyShareAction.UnfulfilledPrecondition.Title"), stringBuilder.toString(), component);
    }

    void showAndPrintPDF(File file, Component component, boolean bl) {
        if (bl && !OpenLink.printFile((File)file)) {
            this.showErrorDialog(Messages.getString("StudyShareAction.PrintError.Title"), Messages.getString("StudyShareAction.PrintError.Message"), component);
        }
        OpenLink.openFile((File)file);
    }

    void showErrorDialog(final String string, final String string2, final Component component) {
        EventUtil.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractStudyShareAction.this.componentFactory.showErrorDialog(string, string2, component);
            }
        });
    }
}

