/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.osgi.util.NLS;

public final class BinarySignatureDescriber
implements IContentDescriber,
IExecutableExtension {
    private static final String SIGNATURE = "signature";
    private static final String OFFSET = "offset";
    private static final Object REQUIRED = "required";
    private byte[] signature;
    private int offset;
    private boolean required = true;
    static /* synthetic */ Class class$0;

    public int describe(InputStream inputStream, IContentDescription iContentDescription) throws IOException {
        int n;
        byte[] byArray = new byte[this.signature.length];
        int n2 = n = this.required ? 0 : 1;
        if (inputStream.skip(this.offset) < (long)this.offset) {
            return n;
        }
        if (inputStream.read(byArray) != byArray.length) {
            return n;
        }
        int n3 = 0;
        while (n3 < this.signature.length) {
            if (this.signature[n3] != byArray[n3]) {
                return n;
            }
            ++n3;
        }
        return 2;
    }

    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[0];
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        block12: {
            try {
                if (object instanceof String) {
                    this.signature = BinarySignatureDescriber.parseSignature((String)object);
                    break block12;
                }
                if (!(object instanceof Hashtable)) break block12;
                Hashtable hashtable = (Hashtable)object;
                if (!hashtable.containsKey(SIGNATURE)) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.runtime.content.BinarySignatureDescriber");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    String string2 = NLS.bind((String)ContentMessages.content_badInitializationData, (Object)clazz.getName());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, string2, null));
                }
                this.signature = BinarySignatureDescriber.parseSignature((String)hashtable.get(SIGNATURE));
                if (hashtable.containsKey(OFFSET)) {
                    this.offset = Integer.parseInt((String)hashtable.get(OFFSET));
                }
                if (hashtable.containsKey(REQUIRED)) {
                    this.required = Boolean.valueOf((String)hashtable.get(REQUIRED));
                }
            }
            catch (NumberFormatException numberFormatException) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.content.BinarySignatureDescriber");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String string3 = NLS.bind((String)ContentMessages.content_badInitializationData, (Object)clazz.getName());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, string3, (Throwable)numberFormatException));
            }
        }
    }

    private static byte[] parseSignature(String string) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new Byte((byte)Integer.parseInt(stringTokenizer.nextToken().trim(), 16)));
        }
        byte[] byArray = new byte[arrayList.size()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (Byte)arrayList.get(n);
            ++n;
        }
        return byArray;
    }
}

