/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.util;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.UUID;
import java.util.regex.Pattern;
import org.dcm4che3.data.UID;
import org.dcm4che3.util.ByteUtils;

public class UIDUtils {
    private static final String UUID_ROOT = "2.25";
    private static final Pattern PATTERN = Pattern.compile("[012]((\\.0)|(\\.[1-9]\\d*))+");
    private static String root = "2.25";

    public static final String getRoot() {
        return root;
    }

    public static final void setRoot(String string) {
        UIDUtils.checkRoot(string);
        root = string;
    }

    private static void checkRoot(String string) {
        if (string.length() > 24) {
            throw new IllegalArgumentException("root length > 24");
        }
        if (!UIDUtils.isValid(string)) {
            throw new IllegalArgumentException(string);
        }
    }

    public static boolean isValid(String string) {
        return string.length() <= 64 && PATTERN.matcher(string).matches();
    }

    public static String createUID() {
        return UIDUtils.randomUID(root);
    }

    public static String createNameBasedUID(byte[] byArray) {
        return UIDUtils.nameBasedUID(byArray, root);
    }

    public static String createNameUID(byte[] byArray, String string) {
        UIDUtils.checkRoot(string);
        return UIDUtils.nameBasedUID(byArray, string);
    }

    public static String createUID(String string) {
        UIDUtils.checkRoot(string);
        return UIDUtils.randomUID(string);
    }

    public static String createUIDIfNull(String string) {
        return string == null ? UIDUtils.randomUID(root) : string;
    }

    public static String createUIDIfNull(String string, String string2) {
        UIDUtils.checkRoot(string2);
        return string == null ? UIDUtils.randomUID(string2) : string;
    }

    private static String randomUID(String string) {
        return UIDUtils.toUID(string, UUID.randomUUID());
    }

    private static String nameBasedUID(byte[] byArray, String string) {
        return UIDUtils.toUID(string, UUID.nameUUIDFromBytes(byArray));
    }

    private static String toUID(String string, UUID uUID) {
        byte[] byArray = new byte[17];
        ByteUtils.longToBytesBE(uUID.getMostSignificantBits(), byArray, 1);
        ByteUtils.longToBytesBE(uUID.getLeastSignificantBits(), byArray, 9);
        String string2 = new BigInteger(byArray).toString();
        int n = string.length();
        int n2 = string2.length();
        char[] cArray = new char[n + n2 + 1];
        string.getChars(0, n, cArray, 0);
        cArray[n] = 46;
        string2.getChars(0, n2, cArray, n + 1);
        return new String(cArray);
    }

    public static StringBuilder promptTo(String string, StringBuilder stringBuilder) {
        return stringBuilder.append(string).append(" - ").append(UID.nameOf(string));
    }

    public static String[] findUIDs(String string) {
        Pattern pattern = Pattern.compile(string);
        Field[] fieldArray = UID.class.getFields();
        String[] stringArray = new String[fieldArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < fieldArray.length) {
            Field field = fieldArray[n2];
            if (pattern.matcher(field.getName()).matches()) {
                try {
                    stringArray[n++] = (String)field.get(null);
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return Arrays.copyOf(stringArray, n);
    }
}

