/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.util.TagUtils;

public class AttributesFormat
extends Format {
    private static final long serialVersionUID = 1901510733531643054L;
    private final String pattern;
    private final int[] tags;
    private final int[] index;
    private final Type[] types;
    private final MessageFormat format;

    public AttributesFormat(String string) {
        ArrayList<String> arrayList = this.tokenize(string);
        int n = arrayList.size() / 2;
        this.pattern = string;
        this.tags = new int[n];
        this.index = new int[n];
        this.types = new Type[n];
        this.format = this.buildMessageFormat(arrayList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<String> tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
        int n = 125;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = string2.charAt(0);
            if (c == '{') {
                if (n2++ == 0) {
                    if (n == 125) {
                        arrayList.add("");
                    }
                } else {
                    stringBuilder.append(c);
                }
            } else if (c == '}') {
                if (--n2 == 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                } else {
                    if (n2 <= 0) throw new IllegalArgumentException(string);
                    stringBuilder.append(c);
                }
            } else if (n2 == 0) {
                arrayList.add(string2);
            } else {
                stringBuilder.append(string2);
            }
            n = c;
        }
        return arrayList;
    }

    private MessageFormat buildMessageFormat(ArrayList<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder(this.pattern.length());
        int n = 0;
        int n2 = 0;
        while (n2 < this.tags.length) {
            int n3;
            stringBuilder.append(arrayList.get(n++)).append('{').append(n2);
            String string = arrayList.get(n++);
            int n4 = string.indexOf(44) + 1;
            if (!string.startsWith("now")) {
                n3 = n4 != 0 ? n4 - 1 : string.length();
                int n5 = string.charAt(n3 - 1) == ']' ? string.lastIndexOf(91, n3 - 3) + 1 : 0;
                try {
                    this.tags[n2] = Integer.parseInt(string.substring(0, n5 != 0 ? n5 - 1 : n3), 16);
                    if (n5 != 0) {
                        this.index[n2] = Integer.parseInt(string.substring(n5, n3 - 1));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(this.pattern);
                }
            }
            if (n4 != 0) {
                n3 = string.indexOf(44, n4);
                try {
                    this.types[n2] = Type.valueOf(string.substring(n4, n3 < 0 ? string.length() : n3));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(this.pattern);
                }
                if (this.types[n2] != Type.hash && this.types[n2] != Type.urlencoded) {
                    stringBuilder.append(n4 > 0 ? string.substring(n4 - 1) : string);
                }
            } else {
                this.types[n2] = Type.none;
            }
            stringBuilder.append('}');
            ++n2;
        }
        if (n < arrayList.size()) {
            stringBuilder.append(arrayList.get(n));
        }
        try {
            return new MessageFormat(stringBuilder.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(this.pattern);
        }
    }

    public static AttributesFormat valueOf(String string) {
        return string != null ? new AttributesFormat(string) : null;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format.format(this.toArgs((Attributes)object), stringBuffer, fieldPosition);
    }

    private Object[] toArgs(Attributes attributes) {
        Object[] objectArray = new Object[this.tags.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.types[n].toArg(attributes, this.tags[n], this.index[n]);
            ++n;
        }
        return objectArray;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.pattern;
    }

    private static enum Type {
        none{

            @Override
            Object toArg(Attributes attributes, int n, int n2) {
                return attributes.getString(n, n2);
            }
        }
        ,
        number{

            @Override
            Object toArg(Attributes attributes, int n, int n2) {
                return attributes.getDouble(n, n2, 0.0);
            }
        }
        ,
        date{

            @Override
            Object toArg(Attributes attributes, int n, int n2) {
                return n != 0 ? attributes.getDate(n, n2) : new Date();
            }
        }
        ,
        time{

            @Override
            Object toArg(Attributes attributes, int n, int n2) {
                return n != 0 ? attributes.getDate(n, n2) : new Date();
            }
        }
        ,
        choice{

            @Override
            Object toArg(Attributes attributes, int n, int n2) {
                return attributes.getDouble(n, n2, 0.0);
            }
        }
        ,
        hash{

            @Override
            Object toArg(Attributes attributes, int n, int n2) {
                String string = attributes.getString(n, n2);
                return string != null ? TagUtils.toHexString(string.hashCode()) : null;
            }
        }
        ,
        urlencoded{

            @Override
            Object toArg(Attributes attributes, int n, int n2) {
                String string = attributes.getString(n, n2);
                try {
                    return string != null ? URLEncoder.encode(string, "UTF-8") : null;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new AssertionError((Object)unsupportedEncodingException);
                }
            }
        };


        abstract Object toArg(Attributes var1, int var2, int var3);
    }
}

