/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.service;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IOD;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.ValidationResult;
import org.dcm4che3.net.service.DicomServiceException;

public enum QueryRetrieveLevel {
    PATIENT{

        @Override
        protected IOD queryKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            IOD iOD = new IOD();
            iOD.add(new IOD.DataElement(0x20000D, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            iOD.add(new IOD.DataElement(0x20000E, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            iOD.add(new IOD.DataElement(524312, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            return iOD;
        }

        @Override
        protected IOD retrieveKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            IOD iOD = this.queryKeysIOD(queryRetrieveLevel, bl);
            iOD.add(new IOD.DataElement(0x100020, VR.LO, IOD.DataElementType.TYPE_1, 1, 1, 0));
            return iOD;
        }
    }
    ,
    STUDY{

        @Override
        protected IOD queryKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            IOD iOD = new IOD();
            iOD.add(new IOD.DataElement(0x100020, VR.LO, !bl && queryRetrieveLevel == PATIENT ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            iOD.add(new IOD.DataElement(0x20000E, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            iOD.add(new IOD.DataElement(524312, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            return iOD;
        }

        @Override
        protected IOD retrieveKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            IOD iOD = this.queryKeysIOD(queryRetrieveLevel, bl);
            iOD.add(new IOD.DataElement(0x20000D, VR.UI, IOD.DataElementType.TYPE_1, -1, -1, 0));
            return iOD;
        }
    }
    ,
    SERIES{

        @Override
        protected IOD queryKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            IOD iOD = new IOD();
            iOD.add(new IOD.DataElement(0x100020, VR.LO, !bl && queryRetrieveLevel == PATIENT ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            iOD.add(new IOD.DataElement(0x20000D, VR.UI, !bl ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            iOD.add(new IOD.DataElement(524312, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            return iOD;
        }

        @Override
        protected IOD retrieveKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            IOD iOD = this.queryKeysIOD(queryRetrieveLevel, bl);
            iOD.add(new IOD.DataElement(0x20000E, VR.UI, IOD.DataElementType.TYPE_1, -1, -1, 0));
            return iOD;
        }
    }
    ,
    IMAGE{

        @Override
        protected IOD queryKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            IOD iOD = new IOD();
            iOD.add(new IOD.DataElement(0x100020, VR.LO, !bl && queryRetrieveLevel == PATIENT ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            iOD.add(new IOD.DataElement(0x20000D, VR.UI, !bl ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            iOD.add(new IOD.DataElement(0x20000E, VR.UI, !bl ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            return iOD;
        }

        @Override
        protected IOD retrieveKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            IOD iOD = this.queryKeysIOD(queryRetrieveLevel, bl);
            iOD.add(new IOD.DataElement(524312, VR.UI, IOD.DataElementType.TYPE_1, -1, -1, 0));
            return iOD;
        }
    }
    ,
    FRAME{

        @Override
        protected IOD queryKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected IOD retrieveKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            return IMAGE.retrieveKeysIOD(queryRetrieveLevel, bl);
        }
    };


    private QueryRetrieveLevel() {
    }

    public void validateQueryKeys(Attributes attributes, QueryRetrieveLevel queryRetrieveLevel, boolean bl) throws DicomServiceException {
        QueryRetrieveLevel.check(attributes.validate(this.queryKeysIOD(queryRetrieveLevel, bl)));
    }

    public void validateRetrieveKeys(Attributes attributes, QueryRetrieveLevel queryRetrieveLevel, boolean bl) throws DicomServiceException {
        QueryRetrieveLevel.check(attributes.validate(this.retrieveKeysIOD(queryRetrieveLevel, bl)));
    }

    protected abstract IOD queryKeysIOD(QueryRetrieveLevel var1, boolean var2);

    protected abstract IOD retrieveKeysIOD(QueryRetrieveLevel var1, boolean var2);

    private static void check(ValidationResult validationResult) throws DicomServiceException {
        if (!validationResult.isValid()) {
            throw new DicomServiceException(43264, validationResult.getErrorComment()).setOffendingElements(validationResult.getOffendingElements());
        }
    }

    public static QueryRetrieveLevel valueOf(String string) {
        return Enum.valueOf(QueryRetrieveLevel.class, string);
    }

    /* synthetic */ QueryRetrieveLevel(String string, int n, QueryRetrieveLevel queryRetrieveLevel) {
        this();
    }
}

