/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.pdu;

import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;

public class PresentationContext {
    public static final int ACCEPTANCE = 0;
    public static final int USER_REJECTION = 1;
    public static final int PROVIDER_REJECTION = 2;
    public static final int ABSTRACT_SYNTAX_NOT_SUPPORTED = 3;
    public static final int TRANSFER_SYNTAX_NOT_SUPPORTED = 4;
    private static final String[] RESULTS = new String[]{"0 - acceptance", "1 - user-rejection", "2 - no-reason (provider rejection)", "3 - abstract-syntax-not-supported (provider rejection)", "4 - transfer-syntaxes-not-supported (provider rejection)"};
    private final int pcid;
    private final int result;
    private final String as;
    private final String[] tss;

    public PresentationContext(int n, int n2, String string, String ... stringArray) {
        this.pcid = n;
        this.result = n2;
        this.as = string;
        this.tss = stringArray;
    }

    public PresentationContext(int n, String string, String ... stringArray) {
        this(n, 0, string, stringArray);
    }

    public PresentationContext(int n, int n2, String string) {
        this(n, n2, null, string);
    }

    private static String resultAsString(int n) {
        try {
            return RESULTS[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return Integer.toString(n);
        }
    }

    public final int getPCID() {
        return this.pcid;
    }

    public final int getResult() {
        return this.result;
    }

    public boolean isAccepted() {
        return this.result == 0;
    }

    public final String getAbstractSyntax() {
        return this.as;
    }

    public final String[] getTransferSyntaxes() {
        return this.tss;
    }

    public boolean containsTransferSyntax(String string) {
        String[] stringArray = this.tss;
        int n = this.tss.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string.equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getTransferSyntax() {
        return this.tss[0];
    }

    public int length() {
        int n = 4;
        if (this.as != null) {
            n += 4 + this.as.length();
        }
        String[] stringArray = this.tss;
        int n2 = this.tss.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            n += 4 + string.length();
            ++n3;
        }
        return n;
    }

    public String toString() {
        return this.promptTo(new StringBuilder()).toString();
    }

    StringBuilder promptTo(StringBuilder stringBuilder) {
        stringBuilder.append("  PresentationContext[id: ").append(this.pcid).append(StringUtils.LINE_SEPARATOR);
        if (this.as != null) {
            UIDUtils.promptTo(this.as, stringBuilder.append("    as: "));
        } else {
            stringBuilder.append("    result: ").append(PresentationContext.resultAsString(this.result));
        }
        stringBuilder.append(StringUtils.LINE_SEPARATOR);
        String[] stringArray = this.tss;
        int n = this.tss.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            UIDUtils.promptTo(string, stringBuilder.append("    ts: ")).append(StringUtils.LINE_SEPARATOR);
            ++n2;
        }
        return stringBuilder.append("  ]");
    }
}

