/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.pdu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.dcm4che3.data.Implementation;
import org.dcm4che3.net.pdu.CommonExtendedNegotiation;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.pdu.RoleSelection;
import org.dcm4che3.net.pdu.UserIdentityAC;
import org.dcm4che3.net.pdu.UserIdentityRQ;
import org.dcm4che3.util.IntHashMap;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;

public abstract class AAssociateRQAC {
    protected byte[] reservedBytes = new byte[32];
    protected int protocolVersion = 1;
    protected int maxPDULength = 16378;
    protected int maxOpsInvoked = 1;
    protected int maxOpsPerformed = 1;
    protected String calledAET;
    protected String callingAET;
    protected String applicationContext = "1.2.840.10008.3.1.1.1";
    protected String implClassUID = Implementation.getClassUID();
    protected String implVersionName = Implementation.getVersionName();
    protected UserIdentityRQ userIdentityRQ;
    protected UserIdentityAC userIdentityAC;
    protected final ArrayList<PresentationContext> pcs = new ArrayList();
    protected final IntHashMap<PresentationContext> pcidMap = new IntHashMap();
    protected final LinkedHashMap<String, RoleSelection> roleSelMap = new LinkedHashMap();
    protected final LinkedHashMap<String, ExtendedNegotiation> extNegMap = new LinkedHashMap();
    protected final LinkedHashMap<String, CommonExtendedNegotiation> commonExtNegMap = new LinkedHashMap();

    public void checkCallingAET() {
        if (this.callingAET == null) {
            throw new IllegalStateException("Calling AET not initalized");
        }
    }

    public void checkCalledAET() {
        if (this.calledAET == null) {
            throw new IllegalStateException("Called AET not initalized");
        }
    }

    public final int getProtocolVersion() {
        return this.protocolVersion;
    }

    public final void setProtocolVersion(int n) {
        this.protocolVersion = n;
    }

    public final byte[] getReservedBytes() {
        return (byte[])this.reservedBytes.clone();
    }

    public final void setReservedBytes(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("reservedBytes.length: " + byArray.length);
        }
        System.arraycopy(byArray, 0, this.reservedBytes, 0, 32);
    }

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final void setCalledAET(String string) {
        if (string.length() > 16) {
            throw new IllegalArgumentException("calledAET: " + string);
        }
        this.calledAET = string;
    }

    public final String getCallingAET() {
        return this.callingAET;
    }

    public final void setCallingAET(String string) {
        if (string.length() > 16) {
            throw new IllegalArgumentException("callingAET: " + string);
        }
        this.callingAET = string;
    }

    public final String getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.applicationContext = string;
    }

    public final int getMaxPDULength() {
        return this.maxPDULength;
    }

    public final void setMaxPDULength(int n) {
        this.maxPDULength = n;
    }

    public final int getMaxOpsInvoked() {
        return this.maxOpsInvoked;
    }

    public final void setMaxOpsInvoked(int n) {
        this.maxOpsInvoked = n;
    }

    public final int getMaxOpsPerformed() {
        return this.maxOpsPerformed;
    }

    public final void setMaxOpsPerformed(int n) {
        this.maxOpsPerformed = n;
    }

    public final boolean isAsyncOps() {
        return this.maxOpsInvoked != 1 || this.maxOpsPerformed != 1;
    }

    public final String getImplClassUID() {
        return this.implClassUID;
    }

    public final void setImplClassUID(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.implClassUID = string;
    }

    public final String getImplVersionName() {
        return this.implVersionName;
    }

    public final void setImplVersionName(String string) {
        this.implVersionName = string;
    }

    public final UserIdentityRQ getUserIdentityRQ() {
        return this.userIdentityRQ;
    }

    public void setUserIdentityRQ(UserIdentityRQ userIdentityRQ) {
        this.userIdentityRQ = userIdentityRQ;
    }

    public final UserIdentityAC getUserIdentityAC() {
        return this.userIdentityAC;
    }

    public void setUserIdentityAC(UserIdentityAC userIdentityAC) {
        this.userIdentityAC = userIdentityAC;
    }

    public List<PresentationContext> getPresentationContexts() {
        return Collections.unmodifiableList(this.pcs);
    }

    public int getNumberOfPresentationContexts() {
        return this.pcs.size();
    }

    public PresentationContext getPresentationContext(int n) {
        return this.pcidMap.get(n);
    }

    public void addPresentationContext(PresentationContext presentationContext) {
        int n = presentationContext.getPCID();
        if (this.pcidMap.containsKey(n)) {
            throw new IllegalStateException("Already contains Presentation Context with pid: " + n);
        }
        this.pcidMap.put(n, presentationContext);
        this.pcs.add(presentationContext);
    }

    public boolean removePresentationContext(PresentationContext presentationContext) {
        if (!this.pcs.remove(presentationContext)) {
            return false;
        }
        this.pcidMap.remove(presentationContext.getPCID());
        return true;
    }

    public Collection<RoleSelection> getRoleSelections() {
        return Collections.unmodifiableCollection(this.roleSelMap.values());
    }

    public RoleSelection getRoleSelectionFor(String string) {
        return this.roleSelMap.get(string);
    }

    public RoleSelection addRoleSelection(RoleSelection roleSelection) {
        return this.roleSelMap.put(roleSelection.getSOPClassUID(), roleSelection);
    }

    public RoleSelection removeRoleSelectionFor(String string) {
        return (RoleSelection)this.roleSelMap.remove(string);
    }

    public Collection<ExtendedNegotiation> getExtendedNegotiations() {
        return Collections.unmodifiableCollection(this.extNegMap.values());
    }

    public ExtendedNegotiation getExtNegotiationFor(String string) {
        return this.extNegMap.get(string);
    }

    public ExtendedNegotiation addExtendedNegotiation(ExtendedNegotiation extendedNegotiation) {
        return this.extNegMap.put(extendedNegotiation.getSOPClassUID(), extendedNegotiation);
    }

    public ExtendedNegotiation removeExtendedNegotiationFor(String string) {
        return (ExtendedNegotiation)this.extNegMap.remove(string);
    }

    public Collection<CommonExtendedNegotiation> getCommonExtendedNegotiations() {
        return Collections.unmodifiableCollection(this.commonExtNegMap.values());
    }

    public CommonExtendedNegotiation getCommonExtendedNegotiationFor(String string) {
        return this.commonExtNegMap.get(string);
    }

    public CommonExtendedNegotiation addCommonExtendedNegotiation(CommonExtendedNegotiation commonExtendedNegotiation) {
        return this.commonExtNegMap.put(commonExtendedNegotiation.getSOPClassUID(), commonExtendedNegotiation);
    }

    public CommonExtendedNegotiation removeCommonExtendedNegotiationFor(String string) {
        return (CommonExtendedNegotiation)this.commonExtNegMap.remove(string);
    }

    public int length() {
        int n = 68;
        n += 4 + this.applicationContext.length();
        for (PresentationContext presentationContext : this.pcs) {
            n += 4 + presentationContext.length();
        }
        return n += 4 + this.userInfoLength();
    }

    public int userInfoLength() {
        int n = 8;
        n += 4 + this.implClassUID.length();
        if (this.isAsyncOps()) {
            n += 8;
        }
        for (RoleSelection object : this.roleSelMap.values()) {
            n += 4 + object.length();
        }
        if (this.implVersionName != null) {
            n += 4 + this.implVersionName.length();
        }
        for (ExtendedNegotiation extendedNegotiation : this.extNegMap.values()) {
            n += 4 + extendedNegotiation.length();
        }
        for (CommonExtendedNegotiation commonExtendedNegotiation : this.commonExtNegMap.values()) {
            n += 4 + commonExtendedNegotiation.length();
        }
        if (this.userIdentityRQ != null) {
            n += 4 + this.userIdentityRQ.length();
        }
        if (this.userIdentityAC != null) {
            n += 4 + this.userIdentityAC.length();
        }
        return n;
    }

    protected StringBuilder promptTo(String string, StringBuilder stringBuilder) {
        stringBuilder.append(string).append(StringUtils.LINE_SEPARATOR).append("  calledAET: ").append(this.calledAET).append(StringUtils.LINE_SEPARATOR).append("  callingAET: ").append(this.callingAET).append(StringUtils.LINE_SEPARATOR).append("  applicationContext: ");
        UIDUtils.promptTo(this.applicationContext, stringBuilder).append(StringUtils.LINE_SEPARATOR).append("  implClassUID: ").append(this.implClassUID).append(StringUtils.LINE_SEPARATOR).append("  implVersionName: ").append(this.implVersionName).append(StringUtils.LINE_SEPARATOR).append("  maxPDULength: ").append(this.maxPDULength).append(StringUtils.LINE_SEPARATOR).append("  maxOpsInvoked/maxOpsPerformed: ").append(this.maxOpsInvoked).append("/").append(this.maxOpsPerformed).append(StringUtils.LINE_SEPARATOR);
        if (this.userIdentityRQ != null) {
            this.userIdentityRQ.promptTo(stringBuilder).append(StringUtils.LINE_SEPARATOR);
        }
        if (this.userIdentityAC != null) {
            this.userIdentityAC.promptTo(stringBuilder).append(StringUtils.LINE_SEPARATOR);
        }
        for (PresentationContext object : this.pcs) {
            object.promptTo(stringBuilder).append(StringUtils.LINE_SEPARATOR);
        }
        for (RoleSelection roleSelection : this.roleSelMap.values()) {
            roleSelection.promptTo(stringBuilder).append(StringUtils.LINE_SEPARATOR);
        }
        for (ExtendedNegotiation extendedNegotiation : this.extNegMap.values()) {
            extendedNegotiation.promptTo(stringBuilder).append(StringUtils.LINE_SEPARATOR);
        }
        for (CommonExtendedNegotiation commonExtendedNegotiation : this.commonExtNegMap.values()) {
            commonExtendedNegotiation.promptTo(stringBuilder).append(StringUtils.LINE_SEPARATOR);
        }
        return stringBuilder.append("]");
    }
}

