/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.DeviceExtension;

public class AuditRecordRepository
extends DeviceExtension {
    private static final long serialVersionUID = -2279487409324427161L;
    private Boolean installed;
    private final List<Connection> conns = new ArrayList<Connection>(1);

    public boolean isInstalled() {
        return this.device != null && this.device.isInstalled() && (this.installed == null || this.installed != false);
    }

    public final Boolean getInstalled() {
        return this.installed;
    }

    public void setInstalled(Boolean bl) {
        if (bl != null && bl.booleanValue() && this.device != null && !this.device.isInstalled()) {
            throw new IllegalStateException("owning device not installed");
        }
        this.installed = bl;
    }

    public void addConnection(Connection connection) {
        if (!connection.getProtocol().isSyslog()) {
            throw new IllegalArgumentException("Audit Record Repository does not support protocol " + (Object)((Object)connection.getProtocol()));
        }
        if (this.device != null && this.device != connection.getDevice()) {
            throw new IllegalStateException(connection + " not contained by " + this.device.getDeviceName());
        }
        this.conns.add(connection);
    }

    public boolean removeConnection(Connection connection) {
        return this.conns.remove(connection);
    }

    public List<Connection> getConnections() {
        return this.conns;
    }

    @Override
    public void reconfigure(DeviceExtension deviceExtension) {
        this.reconfigure((AuditRecordRepository)deviceExtension);
    }

    private void reconfigure(AuditRecordRepository auditRecordRepository) {
        this.setInstalled(auditRecordRepository.installed);
        this.device.reconfigureConnections(this.conns, auditRecordRepository.conns);
    }
}

