/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.PDVInputStream;
import org.dcm4che3.net.pdu.AAbort;
import org.dcm4che3.net.pdu.AAssociateAC;
import org.dcm4che3.net.pdu.AAssociateRJ;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.AAssociateRQAC;
import org.dcm4che3.net.pdu.CommonExtendedNegotiation;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.pdu.RoleSelection;
import org.dcm4che3.net.pdu.UserIdentityAC;
import org.dcm4che3.net.pdu.UserIdentityRQ;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;

class PDUDecoder
extends PDVInputStream {
    private static final String UNRECOGNIZED_PDU = "{}: unrecognized PDU[type={}, len={}]";
    private static final String INVALID_PDU_LENGTH = "{}: invalid length of PDU[type={}, len={}]";
    private static final String INVALID_COMMON_EXTENDED_NEGOTIATION = "{}: invalid Common Extended Negotiation sub-item in PDU[type={}, len={}]";
    private static final String INVALID_USER_IDENTITY = "{}: invalid User Identity sub-item in PDU[type={}, len={}]";
    private static final String INVALID_PDV = "{}: invalid PDV in PDU[type={}, len={}]";
    private static final String UNEXPECTED_PDV_TYPE = "{}: unexpected PDV type in PDU[type={}, len={}]";
    private static final String UNEXPECTED_PDV_PCID = "{}: unexpected pcid in PDV in PDU[type={}, len={}]";
    private static final int MAX_PDU_LEN = 0x1000000;
    private final Association as;
    private final InputStream in;
    private final Thread th;
    private byte[] buf = new byte[16384];
    private int pos;
    private int pdutype;
    private int pdulen;
    private int pcid = -1;
    private int pdvmch;
    private int pdvend;

    public PDUDecoder(Association association, InputStream inputStream) {
        this.as = association;
        this.in = inputStream;
        this.th = Thread.currentThread();
    }

    private int remaining() {
        return this.pdulen + 6 - this.pos;
    }

    private boolean hasRemaining() {
        return this.pos < this.pdulen + 6;
    }

    private int get() {
        if (!this.hasRemaining()) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private void get(byte[] byArray, int n, int n2) {
        if (n2 > this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    private void skip(int n) {
        if (n > this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        this.pos += n;
    }

    private int getUnsignedShort() {
        int n = ByteUtils.bytesToUShortBE(this.buf, this.pos);
        this.pos += 2;
        return n;
    }

    private int getInt() {
        int n = ByteUtils.bytesToIntBE(this.buf, this.pos);
        this.pos += 4;
        return n;
    }

    private byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        this.get(byArray, 0, n);
        return byArray;
    }

    private byte[] decodeBytes() {
        return this.getBytes(this.getUnsignedShort());
    }

    public void nextPDU() throws IOException {
        this.checkThread();
        Association.LOG.trace("{}: waiting for PDU", (Object)this.as);
        this.readFully(0, 10);
        this.pos = 0;
        this.pdutype = this.get();
        this.get();
        this.pdulen = this.getInt();
        Association.LOG.trace("{} >> PDU[type={}, len={}]", new Object[]{this.as, this.pdutype, (long)this.pdulen & 0xFFFFFFFFL});
        switch (this.pdutype) {
            case 1: {
                this.readPDU();
                this.as.onAAssociateRQ((AAssociateRQ)this.decode(new AAssociateRQ()));
                return;
            }
            case 2: {
                this.readPDU();
                this.as.onAAssociateAC((AAssociateAC)this.decode(new AAssociateAC()));
                return;
            }
            case 4: {
                this.readPDU();
                this.as.onPDataTF();
                return;
            }
            case 3: {
                this.checkPDULength(4);
                this.get();
                this.as.onAAssociateRJ(new AAssociateRJ(this.get(), this.get(), this.get()));
                break;
            }
            case 5: {
                this.checkPDULength(4);
                this.as.onAReleaseRQ();
                break;
            }
            case 6: {
                this.checkPDULength(4);
                this.as.onAReleaseRP();
                break;
            }
            case 7: {
                this.checkPDULength(4);
                this.get();
                this.get();
                this.as.onAAbort(new AAbort(this.get(), this.get()));
                break;
            }
            default: {
                this.abort(1, UNRECOGNIZED_PDU);
            }
        }
    }

    private void checkThread() {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
    }

    private void checkPDULength(int n) throws AAbort {
        if (this.pdulen != n) {
            this.abort(6, INVALID_PDU_LENGTH);
        }
    }

    private void readPDU() throws IOException {
        if (this.pdulen < 4 || this.pdulen > 0x1000000) {
            this.abort(6, INVALID_PDU_LENGTH);
        }
        if (6 + this.pdulen > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, 6 + this.pdulen);
        }
        this.readFully(10, this.pdulen - 4);
    }

    private void readFully(int n, int n2) throws IOException {
        StreamUtils.readFully(this.in, this.buf, n, n2);
    }

    private void abort(int n, String string) throws AAbort {
        Association.LOG.warn(string, new Object[]{this.as, this.pdutype, (long)this.pdulen & 0xFFFFFFFFL});
        throw new AAbort(2, n);
    }

    private String getString(int n) {
        if (this.pos + n > this.pdulen + 6) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = n;
        while (n2 > 0 && this.buf[this.pos + n2 - 1] == 0) {
            --n2;
        }
        String string = new String(this.buf, 0, this.pos, n2);
        this.pos += n;
        return string;
    }

    private String decodeString() {
        return this.getString(this.getUnsignedShort());
    }

    private AAssociateRQAC decode(AAssociateRQAC aAssociateRQAC) throws AAbort {
        try {
            aAssociateRQAC.setProtocolVersion(this.getUnsignedShort());
            this.get();
            this.get();
            aAssociateRQAC.setCalledAET(this.getString(16).trim());
            aAssociateRQAC.setCallingAET(this.getString(16).trim());
            aAssociateRQAC.setReservedBytes(this.getBytes(32));
            while (this.pos < this.pdulen) {
                this.decodeItem(aAssociateRQAC);
            }
            this.checkPDULength(this.pos - 6);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.abort(6, INVALID_PDU_LENGTH);
        }
        return aAssociateRQAC;
    }

    private void decodeItem(AAssociateRQAC aAssociateRQAC) throws AAbort {
        int n = this.get();
        this.get();
        int n2 = this.getUnsignedShort();
        switch (n) {
            case 16: {
                aAssociateRQAC.setApplicationContext(this.getString(n2));
                break;
            }
            case 32: 
            case 33: {
                aAssociateRQAC.addPresentationContext(this.decodePC(n2));
                break;
            }
            case 80: {
                this.decodeUserInfo(n2, aAssociateRQAC);
                break;
            }
            default: {
                this.skip(n2);
            }
        }
    }

    private PresentationContext decodePC(int n) {
        int n2 = this.get();
        this.get();
        int n3 = this.get();
        this.get();
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        int n4 = this.pos + n - 4;
        while (this.pos < n4) {
            int n5 = this.get() & 0xFF;
            this.get();
            int n6 = this.getUnsignedShort();
            switch (n5) {
                case 48: {
                    string = this.getString(n6);
                    break;
                }
                case 64: {
                    arrayList.add(this.getString(n6));
                    break;
                }
                default: {
                    this.skip(n6);
                }
            }
        }
        return new PresentationContext(n2, n3, string, arrayList.toArray(new String[arrayList.size()]));
    }

    private void decodeUserInfo(int n, AAssociateRQAC aAssociateRQAC) throws AAbort {
        int n2 = this.pos + n;
        while (this.pos < n2) {
            this.decodeUserInfoSubItem(aAssociateRQAC);
        }
    }

    private void decodeUserInfoSubItem(AAssociateRQAC aAssociateRQAC) throws AAbort {
        int n = this.get();
        this.get();
        int n2 = this.getUnsignedShort();
        switch (n) {
            case 81: {
                aAssociateRQAC.setMaxPDULength(this.getInt());
                break;
            }
            case 82: {
                aAssociateRQAC.setImplClassUID(this.getString(n2));
                break;
            }
            case 83: {
                aAssociateRQAC.setMaxOpsInvoked(this.getUnsignedShort());
                aAssociateRQAC.setMaxOpsPerformed(this.getUnsignedShort());
                break;
            }
            case 84: {
                aAssociateRQAC.addRoleSelection(this.decodeRoleSelection(n2));
                break;
            }
            case 85: {
                aAssociateRQAC.setImplVersionName(this.getString(n2));
                break;
            }
            case 86: {
                aAssociateRQAC.addExtendedNegotiation(this.decodeExtNeg(n2));
                break;
            }
            case 87: {
                aAssociateRQAC.addCommonExtendedNegotiation(this.decodeCommonExtNeg(n2));
                break;
            }
            case 88: {
                aAssociateRQAC.setUserIdentityRQ(this.decodeUserIdentityRQ(n2));
                break;
            }
            case 89: {
                aAssociateRQAC.setUserIdentityAC(this.decodeUserIdentityAC(n2));
                break;
            }
            default: {
                this.skip(n2);
            }
        }
    }

    private RoleSelection decodeRoleSelection(int n) {
        String string = this.decodeString();
        boolean bl = this.get() != 0;
        boolean bl2 = this.get() != 0;
        return new RoleSelection(string, bl, bl2);
    }

    private ExtendedNegotiation decodeExtNeg(int n) {
        int n2 = this.getUnsignedShort();
        String string = this.getString(n2);
        byte[] byArray = this.getBytes(n - n2 - 2);
        return new ExtendedNegotiation(string, byArray);
    }

    private CommonExtendedNegotiation decodeCommonExtNeg(int n) throws AAbort {
        int n2 = this.pos + n;
        String string = this.getString(this.getUnsignedShort());
        String string2 = this.getString(this.getUnsignedShort());
        ArrayList<String> arrayList = new ArrayList<String>(1);
        int n3 = this.getUnsignedShort();
        int n4 = this.pos + n3;
        while (this.pos < n4) {
            arrayList.add(this.decodeString());
        }
        if (this.pos != n4 || this.pos > n2) {
            this.abort(6, INVALID_COMMON_EXTENDED_NEGOTIATION);
        }
        this.skip(n2 - this.pos);
        return new CommonExtendedNegotiation(string, string2, arrayList.toArray(new String[arrayList.size()]));
    }

    private UserIdentityRQ decodeUserIdentityRQ(int n) throws AAbort {
        int n2 = this.pos + n;
        int n3 = this.get() & 0xFF;
        boolean bl = this.get() != 0;
        byte[] byArray = this.decodeBytes();
        byte[] byArray2 = this.decodeBytes();
        if (this.pos != n2) {
            this.abort(6, INVALID_USER_IDENTITY);
        }
        return new UserIdentityRQ(n3, bl, byArray, byArray2);
    }

    private UserIdentityAC decodeUserIdentityAC(int n) throws AAbort {
        int n2 = this.pos + n;
        byte[] byArray = this.decodeBytes();
        if (this.pos != n2) {
            this.abort(6, INVALID_USER_IDENTITY);
        }
        return new UserIdentityAC(byArray);
    }

    public void decodeDIMSE() throws IOException {
        this.checkThread();
        if (this.pcid != -1) {
            return;
        }
        this.nextPDV(1, -1);
        PresentationContext presentationContext = this.as.getPresentationContext(this.pcid);
        if (presentationContext == null) {
            Association.LOG.warn("{}: No Presentation Context with given ID - {}", (Object)this.as, (Object)this.pcid);
            throw new AAbort();
        }
        if (!presentationContext.isAccepted()) {
            Association.LOG.warn("{}: No accepted Presentation Context with given ID - {}", (Object)this.as, (Object)this.pcid);
            throw new AAbort();
        }
        Attributes attributes = this.readCommand();
        Dimse dimse = this.dimseOf(attributes);
        String string = presentationContext.getTransferSyntax();
        if (Dimse.LOG.isInfoEnabled()) {
            Dimse.LOG.info("{} >> {}", (Object)this.as, (Object)dimse.toString(attributes, this.pcid, string));
            Dimse.LOG.debug("Command:\n{}", (Object)attributes);
        }
        if (dimse == Dimse.C_CANCEL_RQ) {
            this.as.onCancelRQ(attributes);
        } else if (Commands.hasDataset(attributes)) {
            this.nextPDV(0, this.pcid);
            if (dimse.isRSP()) {
                Attributes attributes2 = this.readDataset(string);
                Dimse.LOG.debug("Dataset:\n{}", (Object)attributes2);
                this.as.onDimseRSP(dimse, attributes, attributes2);
            } else {
                this.as.onDimseRQ(presentationContext, dimse, attributes, this);
                long l = this.skipAll();
                if (l > 0L) {
                    Association.LOG.debug("{}: Service User did not consume {} bytes of DIMSE data.", (Object)this.as, (Object)l);
                }
            }
            this.skipAll();
        } else if (dimse.isRSP()) {
            this.as.onDimseRSP(dimse, attributes, null);
        } else {
            this.as.onDimseRQ(presentationContext, dimse, attributes, null);
        }
        this.pcid = -1;
    }

    private Dimse dimseOf(Attributes attributes) throws AAbort {
        try {
            return Dimse.valueOf(attributes.getInt(256, 0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Dimse.LOG.info("{}: illegal DIMSE:", (Object)this.as);
            Dimse.LOG.info("\n{}", (Object)attributes);
            throw new AAbort();
        }
    }

    private Attributes readCommand() throws IOException {
        DicomInputStream dicomInputStream = new DicomInputStream(this, "1.2.840.10008.1.2");
        try {
            Attributes attributes = dicomInputStream.readCommand();
            return attributes;
        }
        finally {
            SafeClose.close(dicomInputStream);
        }
    }

    @Override
    public Attributes readDataset(String string) throws IOException {
        DicomInputStream dicomInputStream = new DicomInputStream(this, string);
        try {
            Attributes attributes = dicomInputStream.readDataset(-1, -1);
            return attributes;
        }
        finally {
            SafeClose.close(dicomInputStream);
        }
    }

    private void nextPDV(int n, int n2) throws IOException {
        if (!this.hasRemaining()) {
            this.nextPDU();
            if (this.pdutype != 4) {
                Association.LOG.info("{}: Expected P-DATA-TF PDU but received PDU[type={}]", (Object)this.as, (Object)this.pdutype);
                throw new EOFException();
            }
        }
        if (this.remaining() < 6) {
            this.abort(6, INVALID_PDV);
        }
        int n3 = this.getInt();
        this.pdvend = this.pos + n3;
        if (n3 < 2 || n3 > this.remaining()) {
            this.abort(6, INVALID_PDV);
        }
        this.pcid = this.get();
        this.pdvmch = this.get();
        Association.LOG.trace("{} >> PDV[len={}, pcid={}, mch={}]", new Object[]{this.as, n3, this.pcid, this.pdvmch});
        if ((this.pdvmch & 1) != n) {
            this.abort(5, UNEXPECTED_PDV_TYPE);
        }
        if (n2 != -1 && this.pcid != n2) {
            this.abort(5, UNEXPECTED_PDV_PCID);
        }
    }

    private boolean isLastPDV() throws IOException {
        while (this.pos == this.pdvend) {
            if ((this.pdvmch & 2) != 0) {
                return true;
            }
            this.nextPDV(this.pdvmch & 1, this.pcid);
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        if (this.isLastPDV()) {
            return -1;
        }
        return this.get();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        if (this.isLastPDV()) {
            return -1;
        }
        int n3 = Math.min(n2, this.pdvend - this.pos);
        this.get(byArray, n, n3);
        return n3;
    }

    @Override
    public final int available() {
        return this.pdvend - this.pos;
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        if (l <= 0L || this.isLastPDV()) {
            return 0L;
        }
        int n = (int)Math.min(l, (long)(this.pdvend - this.pos));
        this.skip(n);
        return n;
    }

    @Override
    public void close() throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        this.skipAll();
    }

    @Override
    public long skipAll() throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        long l = 0L;
        while (!this.isLastPDV()) {
            l += (long)(this.pdvend - this.pos);
            this.pos = this.pdvend;
        }
        return l;
    }

    @Override
    public void copyTo(OutputStream outputStream, int n) throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        int n2 = n;
        while (n2 > 0) {
            if (this.isLastPDV()) {
                throw new EOFException("remaining: " + n2);
            }
            int n3 = Math.min(n2, this.pdvend - this.pos);
            outputStream.write(this.buf, this.pos, n3);
            n2 -= n3;
            this.pos += n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyTo(OutputStream var1_1) throws IOException {
        if (this.th == Thread.currentThread()) ** GOTO lbl5
        throw new IllegalStateException("Entered by wrong thread");
lbl-1000:
        // 1 sources

        {
            var1_1.write(this.buf, this.pos, this.pdvend - this.pos);
            this.pos = this.pdvend;
lbl5:
            // 2 sources

            ** while (!this.isLastPDV())
        }
lbl6:
        // 1 sources

    }
}

