/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.AEExtension;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.CompatibleConnection;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.PDVInputStream;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.State;
import org.dcm4che3.net.StorageOptions;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAbort;
import org.dcm4che3.net.pdu.AAssociateAC;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.CommonExtendedNegotiation;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.pdu.RoleSelection;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationEntity
implements Serializable {
    private static final long serialVersionUID = 3883790997057469573L;
    protected static final Logger LOG = LoggerFactory.getLogger(ApplicationEntity.class);
    private Device device;
    private String aet;
    private String description;
    private byte[][] vendorData = new byte[0][];
    private String[] applicationClusters = new String[0];
    private String[] prefCalledAETs = new String[0];
    private String[] prefCallingAETs = new String[0];
    private String[] supportedCharacterSets = new String[0];
    private boolean acceptor = true;
    private boolean initiator = true;
    private Boolean installed;
    private final LinkedHashSet<String> acceptedCallingAETs = new LinkedHashSet();
    private final List<Connection> conns = new ArrayList<Connection>(1);
    private final HashMap<String, TransferCapability> scuTCs = new HashMap();
    private final HashMap<String, TransferCapability> scpTCs = new HashMap();
    private final HashMap<Class<? extends AEExtension>, AEExtension> extensions = new HashMap();
    private transient DimseRQHandler dimseRQHandler;

    public ApplicationEntity(String string) {
        this.setAETitle(string);
    }

    public final Device getDevice() {
        return this.device;
    }

    void setDevice(Device device) {
        if (device != null) {
            if (this.device != null) {
                throw new IllegalStateException("already owned by " + this.device.getDeviceName());
            }
            for (Connection connection : this.conns) {
                if (connection.getDevice() == device) continue;
                throw new IllegalStateException(connection + " not owned by " + device.getDeviceName());
            }
        }
        this.device = device;
    }

    public final String getAETitle() {
        return this.aet;
    }

    public void setAETitle(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("AE title cannot be empty");
        }
        Device device = this.device;
        if (device != null) {
            device.removeApplicationEntity(this.aet);
        }
        this.aet = string;
        if (device != null) {
            device.addApplicationEntity(this);
        }
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final byte[][] getVendorData() {
        return this.vendorData;
    }

    public final void setVendorData(byte[] ... byArray) {
        this.vendorData = byArray;
    }

    public String[] getApplicationClusters() {
        return this.applicationClusters;
    }

    public void setApplicationClusters(String ... stringArray) {
        this.applicationClusters = stringArray;
    }

    public String[] getPreferredCalledAETitles() {
        return this.prefCalledAETs;
    }

    public void setPreferredCalledAETitles(String ... stringArray) {
        this.prefCalledAETs = stringArray;
    }

    public String[] getPreferredCallingAETitles() {
        return this.prefCallingAETs;
    }

    public void setPreferredCallingAETitles(String ... stringArray) {
        this.prefCallingAETs = stringArray;
    }

    public String[] getAcceptedCallingAETitles() {
        return this.acceptedCallingAETs.toArray(new String[this.acceptedCallingAETs.size()]);
    }

    public void setAcceptedCallingAETitles(String ... stringArray) {
        this.acceptedCallingAETs.clear();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.acceptedCallingAETs.add(string);
            ++n2;
        }
    }

    public boolean isAcceptedCallingAETitle(String string) {
        return this.acceptedCallingAETs.isEmpty() || this.acceptedCallingAETs.contains(string);
    }

    public String[] getSupportedCharacterSets() {
        return this.supportedCharacterSets;
    }

    public void setSupportedCharacterSets(String ... stringArray) {
        this.supportedCharacterSets = stringArray;
    }

    public final boolean isAssociationAcceptor() {
        return this.acceptor;
    }

    public final void setAssociationAcceptor(boolean bl) {
        this.acceptor = bl;
    }

    public final boolean isAssociationInitiator() {
        return this.initiator;
    }

    public final void setAssociationInitiator(boolean bl) {
        this.initiator = bl;
    }

    public boolean isInstalled() {
        return this.device != null && this.device.isInstalled() && (this.installed == null || this.installed != false);
    }

    public final Boolean getInstalled() {
        return this.installed;
    }

    public void setInstalled(Boolean bl) {
        this.installed = bl;
    }

    public DimseRQHandler getDimseRQHandler() {
        DimseRQHandler dimseRQHandler = this.dimseRQHandler;
        if (dimseRQHandler != null) {
            return dimseRQHandler;
        }
        Device device = this.device;
        return device != null ? device.getDimseRQHandler() : null;
    }

    public final void setDimseRQHandler(DimseRQHandler dimseRQHandler) {
        this.dimseRQHandler = dimseRQHandler;
    }

    private void checkInstalled() {
        if (!this.isInstalled()) {
            throw new IllegalStateException("Not installed");
        }
    }

    private void checkDevice() {
        if (this.device == null) {
            throw new IllegalStateException("Not attached to Device");
        }
    }

    void onDimseRQ(Association association, PresentationContext presentationContext, Dimse dimse, Attributes attributes, PDVInputStream pDVInputStream) throws IOException {
        DimseRQHandler dimseRQHandler = this.getDimseRQHandler();
        if (dimseRQHandler == null) {
            LOG.error("DimseRQHandler not initalized");
            throw new AAbort();
        }
        dimseRQHandler.onDimseRQ(association, presentationContext, dimse, attributes, pDVInputStream);
    }

    public void addConnection(Connection connection) {
        if (connection.getProtocol() != Connection.Protocol.DICOM) {
            throw new IllegalArgumentException("protocol != DICOM - " + (Object)((Object)connection.getProtocol()));
        }
        if (this.device != null && this.device != connection.getDevice()) {
            throw new IllegalStateException(connection + " not contained by Device: " + this.device.getDeviceName());
        }
        this.conns.add(connection);
    }

    public boolean removeConnection(Connection connection) {
        return this.conns.remove(connection);
    }

    public List<Connection> getConnections() {
        return this.conns;
    }

    public TransferCapability addTransferCapability(TransferCapability transferCapability) {
        transferCapability.setApplicationEntity(this);
        TransferCapability transferCapability2 = (transferCapability.getRole() == TransferCapability.Role.SCU ? this.scuTCs : this.scpTCs).put(transferCapability.getSopClass(), transferCapability);
        if (transferCapability2 != null && transferCapability2 != transferCapability) {
            transferCapability2.setApplicationEntity(null);
        }
        return transferCapability2;
    }

    public TransferCapability removeTransferCapabilityFor(String string, TransferCapability.Role role) {
        TransferCapability transferCapability = (role == TransferCapability.Role.SCU ? this.scuTCs : this.scpTCs).remove(string);
        if (transferCapability != null) {
            transferCapability.setApplicationEntity(null);
        }
        return transferCapability;
    }

    public Collection<TransferCapability> getTransferCapabilities() {
        ArrayList<TransferCapability> arrayList = new ArrayList<TransferCapability>(this.scuTCs.size() + this.scpTCs.size());
        arrayList.addAll(this.scpTCs.values());
        arrayList.addAll(this.scuTCs.values());
        return arrayList;
    }

    public Collection<TransferCapability> getTransferCapabilitiesWithRole(TransferCapability.Role role) {
        return (role == TransferCapability.Role.SCU ? this.scuTCs : this.scpTCs).values();
    }

    public TransferCapability getTransferCapabilityFor(String string, TransferCapability.Role role) {
        return (role == TransferCapability.Role.SCU ? this.scuTCs : this.scpTCs).get(string);
    }

    protected PresentationContext negotiate(AAssociateRQ aAssociateRQ, AAssociateAC aAssociateAC, PresentationContext presentationContext) {
        String string = presentationContext.getAbstractSyntax();
        TransferCapability transferCapability = this.roleSelection(aAssociateRQ, aAssociateAC, string);
        int n = presentationContext.getPCID();
        if (transferCapability == null) {
            return new PresentationContext(n, 3, presentationContext.getTransferSyntax());
        }
        String[] stringArray = presentationContext.getTransferSyntaxes();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (transferCapability.containsTransferSyntax(string2)) {
                byte[] byArray = this.negotiate(aAssociateRQ.getExtNegotiationFor(string), transferCapability);
                if (byArray != null) {
                    aAssociateAC.addExtendedNegotiation(new ExtendedNegotiation(string, byArray));
                }
                return new PresentationContext(n, 0, string2);
            }
            ++n3;
        }
        return new PresentationContext(n, 4, presentationContext.getTransferSyntax());
    }

    private TransferCapability roleSelection(AAssociateRQ aAssociateRQ, AAssociateAC aAssociateAC, String string) {
        RoleSelection roleSelection = aAssociateRQ.getRoleSelectionFor(string);
        if (roleSelection == null) {
            return this.getTC(this.scpTCs, string, aAssociateRQ);
        }
        RoleSelection roleSelection2 = aAssociateAC.getRoleSelectionFor(string);
        if (roleSelection2 != null) {
            return this.getTC(roleSelection2.isSCU() ? this.scpTCs : this.scuTCs, string, aAssociateRQ);
        }
        TransferCapability transferCapability = null;
        TransferCapability transferCapability2 = null;
        boolean bl = roleSelection.isSCU() && (transferCapability2 = this.getTC(this.scpTCs, string, aAssociateRQ)) != null;
        boolean bl2 = roleSelection.isSCP() && (transferCapability = this.getTC(this.scuTCs, string, aAssociateRQ)) != null;
        aAssociateAC.addRoleSelection(new RoleSelection(string, bl, bl2));
        return bl ? transferCapability2 : transferCapability;
    }

    private TransferCapability getTC(HashMap<String, TransferCapability> hashMap, String string, AAssociateRQ aAssociateRQ) {
        TransferCapability transferCapability = hashMap.get(string);
        if (transferCapability != null) {
            return transferCapability;
        }
        CommonExtendedNegotiation commonExtendedNegotiation = aAssociateRQ.getCommonExtendedNegotiationFor(string);
        if (commonExtendedNegotiation != null) {
            String[] stringArray = commonExtendedNegotiation.getRelatedGeneralSOPClassUIDs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                transferCapability = hashMap.get(string2);
                if (transferCapability != null) {
                    return transferCapability;
                }
                ++n2;
            }
            transferCapability = hashMap.get(commonExtendedNegotiation.getServiceClassUID());
            if (transferCapability != null) {
                return transferCapability;
            }
        }
        return hashMap.get("*");
    }

    private byte[] negotiate(ExtendedNegotiation extendedNegotiation, TransferCapability transferCapability) {
        if (extendedNegotiation == null) {
            return null;
        }
        StorageOptions storageOptions = transferCapability.getStorageOptions();
        if (storageOptions != null) {
            return storageOptions.toExtendedNegotiationInformation();
        }
        EnumSet<QueryOption> enumSet = transferCapability.getQueryOptions();
        if (enumSet != null) {
            EnumSet<QueryOption> enumSet2 = QueryOption.toOptions(extendedNegotiation);
            enumSet2.retainAll(enumSet);
            return QueryOption.toExtendedNegotiationInformation(enumSet2);
        }
        return null;
    }

    public Association connect(Connection connection, Connection connection2, AAssociateRQ aAssociateRQ) throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        this.checkDevice();
        this.checkInstalled();
        if (aAssociateRQ.getCallingAET() == null) {
            aAssociateRQ.setCallingAET(this.aet);
        }
        aAssociateRQ.setMaxOpsInvoked(connection.getMaxOpsInvoked());
        aAssociateRQ.setMaxOpsPerformed(connection.getMaxOpsPerformed());
        aAssociateRQ.setMaxPDULength(connection.getReceivePDULength());
        Socket socket = connection.connect(connection2);
        Association association = new Association(this, connection, socket);
        association.write(aAssociateRQ);
        association.waitForLeaving(State.Sta5);
        return association;
    }

    public Association connect(Connection connection, AAssociateRQ aAssociateRQ) throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        return this.connect(this.findCompatibelConnection(connection), connection, aAssociateRQ);
    }

    public Connection findCompatibelConnection(Connection connection) throws IncompatibleConnectionException {
        for (Connection connection2 : this.conns) {
            if (!connection2.isInstalled() || !connection2.isCompatible(connection)) continue;
            return connection2;
        }
        throw new IncompatibleConnectionException("No compatible connection to " + connection + " available on " + this);
    }

    public CompatibleConnection findCompatibelConnection(ApplicationEntity applicationEntity) throws IncompatibleConnectionException {
        for (Connection connection : applicationEntity.conns) {
            if (!connection.isInstalled() || !connection.isServer()) continue;
            for (Connection connection2 : this.conns) {
                if (!connection2.isInstalled() || !connection2.isCompatible(connection)) continue;
                return new CompatibleConnection(connection2, connection);
            }
        }
        throw new IncompatibleConnectionException("No compatible connection to " + applicationEntity + " available on " + this);
    }

    public Association connect(ApplicationEntity applicationEntity, AAssociateRQ aAssociateRQ) throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        CompatibleConnection compatibleConnection = this.findCompatibelConnection(applicationEntity);
        if (aAssociateRQ.getCalledAET() == null) {
            aAssociateRQ.setCalledAET(applicationEntity.getAETitle());
        }
        return this.connect(compatibleConnection.getLocalConnection(), compatibleConnection.getRemoteConnection(), aAssociateRQ);
    }

    public String toString() {
        return this.promptTo(new StringBuilder(512), "").toString();
    }

    public StringBuilder promptTo(StringBuilder stringBuilder, String string) {
        String string2 = String.valueOf(string) + "  ";
        StringUtils.appendLine(stringBuilder, string, "ApplicationEntity[title: ", this.aet);
        StringUtils.appendLine(stringBuilder, string2, "desc: ", this.description);
        StringUtils.appendLine(stringBuilder, string2, "acceptor: ", this.acceptor);
        StringUtils.appendLine(stringBuilder, string2, "initiator: ", this.initiator);
        StringUtils.appendLine(stringBuilder, string2, "installed: ", this.getInstalled());
        for (Connection serializable : this.conns) {
            serializable.promptTo(stringBuilder, string2).append(StringUtils.LINE_SEPARATOR);
        }
        for (TransferCapability transferCapability : this.getTransferCapabilities()) {
            transferCapability.promptTo(stringBuilder, string2).append(StringUtils.LINE_SEPARATOR);
        }
        return stringBuilder.append(string).append(']');
    }

    void reconfigure(ApplicationEntity applicationEntity) {
        this.setApplicationEntityAttributes(applicationEntity);
        this.device.reconfigureConnections(this.conns, applicationEntity.conns);
        this.reconfigureTransferCapabilities(applicationEntity);
        this.reconfigureAEExtensions(applicationEntity);
    }

    private void reconfigureTransferCapabilities(ApplicationEntity applicationEntity) {
        this.scuTCs.clear();
        this.scuTCs.putAll(applicationEntity.scuTCs);
        this.scpTCs.clear();
        this.scpTCs.putAll(applicationEntity.scpTCs);
    }

    private void reconfigureAEExtensions(ApplicationEntity applicationEntity) {
        Iterator<Class<? extends AEExtension>> object2 = this.extensions.keySet().iterator();
        while (object2.hasNext()) {
            if (applicationEntity.extensions.containsKey(object2.next())) continue;
            object2.remove();
        }
        for (AEExtension aEExtension : applicationEntity.extensions.values()) {
            Class<?> clazz = aEExtension.getClass();
            AEExtension aEExtension2 = this.extensions.get(clazz);
            if (aEExtension2 == null) {
                try {
                    aEExtension2 = (AEExtension)clazz.newInstance();
                    this.addAEExtension(aEExtension2);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to instantiate " + clazz.getName(), exception);
                }
            }
            aEExtension2.reconfigure(aEExtension);
        }
    }

    protected void setApplicationEntityAttributes(ApplicationEntity applicationEntity) {
        this.setDescription(applicationEntity.description);
        this.setVendorData(applicationEntity.vendorData);
        this.setApplicationClusters(applicationEntity.applicationClusters);
        this.setPreferredCalledAETitles(applicationEntity.prefCalledAETs);
        this.setPreferredCallingAETitles(applicationEntity.prefCallingAETs);
        this.setAcceptedCallingAETitles(applicationEntity.getAcceptedCallingAETitles());
        this.setSupportedCharacterSets(applicationEntity.supportedCharacterSets);
        this.setAssociationAcceptor(applicationEntity.acceptor);
        this.setAssociationInitiator(applicationEntity.initiator);
        this.setInstalled(applicationEntity.installed);
    }

    public void setAcceptedCallingAETitles(Collection<String> collection) {
        collection.clear();
        collection.addAll(collection);
    }

    public void addAEExtension(AEExtension aEExtension) {
        Class<?> clazz = aEExtension.getClass();
        if (this.extensions.containsKey(clazz)) {
            throw new IllegalStateException("already contains AE Extension:" + clazz);
        }
        aEExtension.setApplicationEntity(this);
        this.extensions.put(clazz, aEExtension);
    }

    public boolean removeAEExtension(AEExtension aEExtension) {
        if (this.extensions.remove(aEExtension.getClass()) == null) {
            return false;
        }
        aEExtension.setApplicationEntity(null);
        return true;
    }

    public Collection<AEExtension> listAEExtensions() {
        return this.extensions.values();
    }

    public <T extends AEExtension> T getAEExtension(Class<T> clazz) {
        return (T)this.extensions.get(clazz);
    }

    public <T extends AEExtension> T getAEExtensionNotNull(Class<T> clazz) {
        T t = this.getAEExtension(clazz);
        if (t == null) {
            throw new IllegalStateException("No " + clazz.getName() + " configured for AE: " + this.aet);
        }
        return t;
    }
}

