/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.TagUtils;

public class DicomOutputStream
extends FilterOutputStream {
    private static final byte[] DICM = new byte[]{68, 73, 67, 77};
    private byte[] preamble = new byte[128];
    private boolean explicitVR;
    private boolean bigEndian;
    private DicomEncodingOptions encOpts = DicomEncodingOptions.DEFAULT;
    private final byte[] buf = new byte[12];

    public DicomOutputStream(OutputStream outputStream, String string) throws IOException {
        super(outputStream);
        this.switchTransferSyntax(string);
    }

    public DicomOutputStream(File file) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(file)), "1.2.840.10008.1.2.1");
    }

    public final void setPreamble(byte[] byArray) {
        if (byArray.length != 128) {
            throw new IllegalArgumentException("preamble.length=" + byArray.length);
        }
        this.preamble = (byte[])byArray.clone();
    }

    public final boolean isExplicitVR() {
        return this.explicitVR;
    }

    public final boolean isBigEndian() {
        return this.bigEndian;
    }

    public final DicomEncodingOptions getEncodingOptions() {
        return this.encOpts;
    }

    public final void setEncodingOptions(DicomEncodingOptions dicomEncodingOptions) {
        if (dicomEncodingOptions == null) {
            throw new NullPointerException();
        }
        this.encOpts = dicomEncodingOptions;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public void writeCommand(Attributes attributes) throws IOException {
        if (this.explicitVR || this.bigEndian) {
            throw new IllegalStateException("explicitVR=" + this.explicitVR + ", bigEndian=" + this.bigEndian);
        }
        attributes.writeGroupTo(this, 0);
    }

    public void writeFileMetaInformation(Attributes attributes) throws IOException {
        if (!this.explicitVR || this.bigEndian) {
            throw new IllegalStateException("explicitVR=" + this.explicitVR + ", bigEndian=" + this.bigEndian);
        }
        String string = attributes.getString(131088, null);
        this.write(this.preamble);
        this.write(DICM);
        attributes.writeGroupTo(this, 131072);
        this.switchTransferSyntax(string);
    }

    public void writeDataset(Attributes attributes, Attributes attributes2) throws IOException {
        if (attributes != null) {
            this.writeFileMetaInformation(attributes);
        }
        if (attributes2.bigEndian() != this.bigEndian || this.encOpts.groupLength || !this.encOpts.undefSequenceLength || !this.encOpts.undefItemLength) {
            attributes2 = new Attributes(attributes2, this.bigEndian);
        }
        if (this.encOpts.groupLength) {
            attributes2.calcLength(this.encOpts, this.explicitVR);
        }
        attributes2.writeTo(this);
    }

    private void switchTransferSyntax(String string) throws IOException {
        this.bigEndian = string.equals("1.2.840.10008.1.2.2");
        boolean bl = this.explicitVR = !string.equals("1.2.840.10008.1.2");
        if (string.equals("1.2.840.10008.1.2.1.99") || string.equals("1.2.840.10008.1.2.4.95")) {
            this.out = new DeflaterOutputStream(this.out, new Deflater(-1, true));
        }
    }

    public void writeHeader(int n, VR vR, int n2) throws IOException {
        int n3;
        byte[] byArray = this.buf;
        ByteUtils.tagToBytes(n, byArray, 0, this.bigEndian);
        if (!TagUtils.isItem(n) && this.explicitVR) {
            ByteUtils.shortToBytesBE(vR.code(), byArray, 4);
            n3 = vR.headerLength();
            if (n3 == 8) {
                ByteUtils.shortToBytes(n2, byArray, 6, this.bigEndian);
            } else {
                byArray[7] = 0;
                byArray[6] = 0;
                ByteUtils.intToBytes(n2, byArray, 8, this.bigEndian);
            }
        } else {
            ByteUtils.intToBytes(n2, byArray, 4, this.bigEndian);
            n3 = 8;
        }
        this.out.write(byArray, 0, n3);
    }

    public void writeAttribute(int n, VR vR, Object object, SpecificCharacterSet specificCharacterSet) throws IOException {
        if (object instanceof Value) {
            this.writeAttribute(n, vR, (Value)object);
        } else {
            this.writeAttribute(n, vR, object instanceof byte[] ? (byte[])object : vR.toBytes(object, specificCharacterSet));
        }
    }

    public void writeAttribute(int n, VR vR, byte[] byArray) throws IOException {
        int n2 = byArray.length & 1;
        this.writeHeader(n, vR, byArray.length + n2);
        this.out.write(byArray);
        if (n2 > 0) {
            this.out.write(vR.paddingByte());
        }
    }

    public void writeAttribute(int n, VR vR, Value value) throws IOException {
        if (value instanceof BulkData && this.out instanceof ObjectOutputStream) {
            this.writeHeader(n, vR, 64507);
            ((BulkData)value).serializeTo((ObjectOutputStream)this.out);
        } else {
            int n2 = value.getEncodedLength(this.encOpts, this.explicitVR, vR);
            this.writeHeader(n, vR, n2);
            value.writeTo(this, vR);
            if (n2 == -1) {
                this.writeHeader(-73507, null, 0);
            }
        }
    }

    public void writeGroupLength(int n, int n2) throws IOException {
        byte[] byArray = this.buf;
        ByteUtils.tagToBytes(n, byArray, 0, this.bigEndian);
        if (this.explicitVR) {
            ByteUtils.shortToBytesBE(VR.UL.code(), byArray, 4);
            ByteUtils.shortToBytes(4, byArray, 6, this.bigEndian);
        } else {
            ByteUtils.intToBytes(4, byArray, 4, this.bigEndian);
        }
        ByteUtils.intToBytes(n2, byArray, 8, this.bigEndian);
        this.out.write(byArray, 0, 12);
    }

    public void finish() throws IOException {
        if (this.out instanceof DeflaterOutputStream) {
            ((DeflaterOutputStream)this.out).finish();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        catch (IOException iOException) {}
        super.close();
    }
}

