/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.stream;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

public class ImageInputStreamAdapter
extends InputStream {
    private final ImageInputStream iis;
    private long markedPos;
    private IOException markException;

    public ImageInputStreamAdapter(ImageInputStream imageInputStream) {
        this.iis = imageInputStream;
    }

    @Override
    public int read() throws IOException {
        return this.iis.read();
    }

    @Override
    public synchronized void mark(int n) {
        try {
            this.markedPos = this.iis.getStreamPosition();
            this.markException = null;
        }
        catch (IOException iOException) {
            this.markException = iOException;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.iis.read(byArray, n, n2);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markException != null) {
            throw this.markException;
        }
        this.iis.seek(this.markedPos);
    }

    @Override
    public long skip(long l) throws IOException {
        return this.iis.skipBytes((int)l);
    }
}

