/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec.jpeg;

import org.dcm4che3.util.ByteUtils;

public class SOFSegment {
    private final byte[] data;
    private final int offset;
    private final int numComponents;

    public SOFSegment(byte[] byArray, int n) {
        this.data = byArray;
        this.offset = n;
        this.numComponents = byArray[n + 8] & 0xFF;
        this.getQTableSelector(this.numComponents - 1);
    }

    public int offset() {
        return this.offset;
    }

    public int getMarker() {
        return this.data[this.offset] & 0xFF;
    }

    public int getHeaderLength() {
        return ByteUtils.bytesToUShortBE(this.data, this.offset + 1);
    }

    public int getPrecision() {
        return this.data[this.offset + 3] & 0xFF;
    }

    public int getY() {
        return ByteUtils.bytesToUShortBE(this.data, this.offset + 4);
    }

    public int getX() {
        return ByteUtils.bytesToUShortBE(this.data, this.offset + 6);
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getComponentID(int n) {
        return this.data[this.offset + 9 + n * 3] & 0xFF;
    }

    public int getXSubsampling(int n) {
        return this.data[this.offset + 10 + n * 3] >> 4 & 0xF;
    }

    public int getYSubsampling(int n) {
        return this.data[this.offset + 10 + n * 3] & 0xF;
    }

    public int getQTableSelector(int n) {
        return this.data[this.offset + 11 + n * 3] & 0xFF;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SOF").append(this.getMarker() - 192).append("[Lf=").append(this.getHeaderLength()).append(", P=").append(this.getPrecision()).append(", Y=").append(this.getY()).append(", X=").append(this.getX()).append(", Nf=").append(this.numComponents);
        int n = 0;
        while (n < this.numComponents) {
            stringBuilder.append(", C").append(n + 1).append('=').append(this.getComponentID(n)).append(", H").append(n + 1).append('=').append(this.getXSubsampling(n)).append(", V").append(n + 1).append('=').append(this.getYSubsampling(n)).append(", Tq").append(n + 1).append('=').append(this.getQTableSelector(n));
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

