/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.util.HashMap;

public enum TransferSyntaxType {
    NATIVE{

        @Override
        public boolean isPixeldataEncapsulated() {
            return false;
        }
    }
    ,
    JPEG_BASELINE{

        @Override
        public int getMaxBitsStored() {
            return 8;
        }
    }
    ,
    JPEG_EXTENDED{

        @Override
        public int getMaxBitsStored() {
            return 12;
        }
    }
    ,
    JPEG_LOSSLESS,
    JPEG_2000{

        @Override
        public boolean canEncodeSigned() {
            return true;
        }
    }
    ,
    RLE{

        @Override
        public int getPlanarConfiguration() {
            return 1;
        }
    }
    ,
    JPIP{

        @Override
        public boolean isPixeldataEncapsulated() {
            return false;
        }
    }
    ,
    MPEG{

        @Override
        public int getMaxBitsStored() {
            return 8;
        }
    };

    private static final HashMap<String, TransferSyntaxType> map;

    static {
        map = new HashMap();
        map.put("1.2.840.10008.1.2", NATIVE);
        map.put("1.2.840.10008.1.2.1", NATIVE);
        map.put("1.2.840.10008.1.2.1.99", NATIVE);
        map.put("1.2.840.10008.1.2.2", NATIVE);
        map.put("1.2.840.10008.1.2.4.50", JPEG_BASELINE);
        map.put("1.2.840.10008.1.2.4.51", JPEG_EXTENDED);
        map.put("1.2.840.10008.1.2.4.57", JPEG_LOSSLESS);
        map.put("1.2.840.10008.1.2.4.70", JPEG_LOSSLESS);
        map.put("1.2.840.10008.1.2.4.80", JPEG_LOSSLESS);
        map.put("1.2.840.10008.1.2.4.81", JPEG_LOSSLESS);
        map.put("1.2.840.10008.1.2.4.90", JPEG_2000);
        map.put("1.2.840.10008.1.2.4.91", JPEG_2000);
        map.put("1.2.840.10008.1.2.4.92", JPEG_2000);
        map.put("1.2.840.10008.1.2.4.93", JPEG_2000);
        map.put("1.2.840.10008.1.2.4.94", JPIP);
        map.put("1.2.840.10008.1.2.4.95", JPIP);
        map.put("1.2.840.10008.1.2.4.100", MPEG);
        map.put("1.2.840.10008.1.2.4.101", MPEG);
        map.put("1.2.840.10008.1.2.4.102", MPEG);
        map.put("1.2.840.10008.1.2.4.103", MPEG);
        map.put("1.2.840.10008.1.2.5", RLE);
    }

    private TransferSyntaxType() {
    }

    public boolean isPixeldataEncapsulated() {
        return true;
    }

    public boolean canEncodeSigned() {
        return false;
    }

    public int getPlanarConfiguration() {
        return 0;
    }

    public int getMaxBitsStored() {
        return 16;
    }

    public static TransferSyntaxType forUID(String string) {
        return map.get(string);
    }

    /* synthetic */ TransferSyntaxType(String string, int n, TransferSyntaxType transferSyntaxType) {
        this();
    }
}

