/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageInputStream;
import org.dcm4che3.imageio.stream.SegmentedInputImageStream;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decompressor {
    private static final Logger LOG = LoggerFactory.getLogger(Decompressor.class);
    protected final Attributes dataset;
    protected final String tsuid;
    protected final TransferSyntaxType tstype;
    protected Fragments pixeldataFragments;
    protected File file;
    protected int rows;
    protected int cols;
    protected int samples;
    protected PhotometricInterpretation pmi;
    protected int bitsAllocated;
    protected int bitsStored;
    protected boolean banded;
    protected boolean signed;
    protected int frames;
    protected int frameLength;
    protected int length;
    protected BufferedImage bi;
    protected ImageReader decompressor;
    protected ImageReadParam readParam;
    protected PatchJPEGLS patchJpegLS;

    public Decompressor(Attributes attributes, String string) {
        if (string == null) {
            throw new NullPointerException("tsuid");
        }
        this.dataset = attributes;
        this.tsuid = string;
        this.tstype = TransferSyntaxType.forUID(string);
        Object object = attributes.getValue(2145386512);
        if (object == null) {
            return;
        }
        if (this.tstype == null) {
            throw new IllegalArgumentException("Unknown Transfer Syntax: " + string);
        }
        this.rows = attributes.getInt(2621456, 0);
        this.cols = attributes.getInt(2621457, 0);
        this.samples = attributes.getInt(0x280002, 0);
        this.pmi = PhotometricInterpretation.fromString(attributes.getString(2621444, "MONOCHROME2"));
        this.bitsAllocated = attributes.getInt(2621696, 8);
        this.bitsStored = attributes.getInt(2621697, this.bitsAllocated);
        this.banded = attributes.getInt(2621446, 0) != 0;
        this.signed = attributes.getInt(2621699, 0) != 0;
        this.frames = attributes.getInt(0x280008, 1);
        this.frameLength = this.rows * this.cols * this.samples * (this.bitsAllocated >>> 3);
        this.length = this.frameLength * this.frames;
        if (object instanceof Fragments) {
            if (!this.tstype.isPixeldataEncapsulated()) {
                throw new IllegalArgumentException("Encapusulated Pixel Datawith Transfer Syntax: " + string);
            }
            this.pixeldataFragments = (Fragments)object;
            int n = this.pixeldataFragments.size();
            if (this.frames == 1 ? n < 2 : n != this.frames + 1) {
                throw new IllegalArgumentException("Number of Pixel Data Fragments: " + n + " does not match " + this.frames);
            }
            this.file = ((BulkData)this.pixeldataFragments.get(1)).getFile();
            ImageReaderFactory.ImageReaderParam imageReaderParam = ImageReaderFactory.getImageReaderParam(string);
            if (imageReaderParam == null) {
                throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + string);
            }
            this.decompressor = ImageReaderFactory.getImageReader(imageReaderParam);
            LOG.debug("Decompressor: {}", (Object)this.decompressor.getClass().getName());
            this.readParam = this.decompressor.getDefaultReadParam();
            this.patchJpegLS = imageReaderParam.patchJPEGLS;
        } else {
            this.file = ((BulkData)object).getFile();
        }
    }

    public void dispose() {
        if (this.decompressor != null) {
            this.decompressor.dispose();
        }
        this.decompressor = null;
    }

    public boolean decompress() {
        if (this.decompressor == null) {
            return false;
        }
        if (this.tstype == TransferSyntaxType.RLE) {
            this.bi = this.createBufferedImage(this.bitsStored, true, this.signed);
        }
        this.dataset.setValue(2145386512, VR.OW, new Value(){

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public byte[] toBytes(VR vR, boolean bl) throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Decompressor.this.writeTo(byteArrayOutputStream);
                return byteArrayOutputStream.toByteArray();
            }

            @Override
            public void writeTo(DicomOutputStream dicomOutputStream, VR vR) throws IOException {
                Decompressor.this.writeTo(dicomOutputStream);
            }

            @Override
            public int calcLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
                return this.getEncodedLength(dicomEncodingOptions, bl, vR);
            }

            @Override
            public int getEncodedLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
                return Decompressor.this.length + 1 & 0xFFFFFFFE;
            }
        });
        if (this.samples > 1) {
            this.dataset.setString(2621444, VR.CS, this.pmi.decompress().toString());
            this.dataset.setInt(2621446, VR.US, this.tstype.getPlanarConfiguration());
        }
        return true;
    }

    public static boolean decompress(Attributes attributes, String string) {
        return new Decompressor(attributes, string).decompress();
    }

    protected BufferedImage createBufferedImage(int n, boolean bl, boolean bl2) {
        int n2 = this.bitsAllocated > 8 ? (bl2 ? 2 : 1) : 0;
        ComponentColorModel componentColorModel = this.samples == 1 ? new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{n}, false, false, 1, n2) : new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{n, n, n}, false, false, 1, n2);
        ComponentSampleModel componentSampleModel = bl ? new BandedSampleModel(n2, this.cols, this.rows, this.samples) : new PixelInterleavedSampleModel(n2, this.cols, this.rows, this.samples, this.cols * this.samples, this.bandOffsets());
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, null);
        return new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    private int[] bandOffsets() {
        int[] nArray = new int[this.samples];
        int n = 0;
        while (n < this.samples) {
            nArray[n] = n;
            ++n;
        }
        return nArray;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        FileImageInputStream fileImageInputStream = this.createImageInputStream();
        try {
            int n = 0;
            while (n < this.frames) {
                this.writeFrameTo(fileImageInputStream, n, outputStream);
                ++n;
            }
            if ((this.length & 1) != 0) {
                outputStream.write(0);
            }
        }
        catch (Throwable throwable) {
            try {
                fileImageInputStream.close();
            }
            catch (IOException iOException) {}
            this.decompressor.dispose();
            throw throwable;
        }
        try {
            fileImageInputStream.close();
        }
        catch (IOException iOException) {}
        this.decompressor.dispose();
    }

    public FileImageInputStream createImageInputStream() throws IOException {
        return new FileImageInputStream(this.file);
    }

    public void writeFrameTo(ImageInputStream imageInputStream, int n, OutputStream outputStream) throws IOException {
        Decompressor.writeTo(this.decompressFrame(imageInputStream, n).getRaster(), outputStream);
    }

    protected BufferedImage decompressFrame(ImageInputStream imageInputStream, int n) throws IOException {
        SegmentedInputImageStream segmentedInputImageStream = new SegmentedInputImageStream(imageInputStream, this.pixeldataFragments, n);
        this.decompressor.setInput(this.patchJpegLS != null ? new PatchJPEGLSImageInputStream(segmentedInputImageStream, this.patchJpegLS) : segmentedInputImageStream);
        this.readParam.setDestination(this.bi);
        long l = System.currentTimeMillis();
        this.bi = this.decompressor.read(0, this.readParam);
        long l2 = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decompressed frame #{} 1:{} in {} ms", new Object[]{n + 1, Float.valueOf((float)Decompressor.sizeOf(this.bi) / (float)segmentedInputImageStream.getStreamPosition()), l2 - l});
        }
        return this.bi;
    }

    static int sizeOf(BufferedImage bufferedImage) {
        DataBuffer dataBuffer = bufferedImage.getData().getDataBuffer();
        return dataBuffer.getSize() * dataBuffer.getNumBanks() * (DataBuffer.getDataTypeSize(dataBuffer.getDataType()) >>> 3);
    }

    private static void writeTo(Raster raster, OutputStream outputStream) throws IOException {
        SampleModel sampleModel = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        switch (dataBuffer.getDataType()) {
            case 0: {
                Decompressor.writeTo(sampleModel, ((DataBufferByte)dataBuffer).getBankData(), outputStream);
                break;
            }
            case 1: {
                Decompressor.writeTo(sampleModel, ((DataBufferUShort)dataBuffer).getData(), outputStream);
                break;
            }
            case 2: {
                Decompressor.writeTo(sampleModel, ((DataBufferShort)dataBuffer).getData(), outputStream);
                break;
            }
            case 3: {
                Decompressor.writeTo(sampleModel, ((DataBufferInt)dataBuffer).getData(), outputStream);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Datatype: " + dataBuffer.getDataType());
            }
        }
    }

    private static void writeTo(SampleModel sampleModel, byte[][] byArray, OutputStream outputStream) throws IOException {
        int n = sampleModel.getHeight();
        int n2 = sampleModel.getWidth();
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
        int n3 = n2 * componentSampleModel.getPixelStride();
        int n4 = componentSampleModel.getScanlineStride();
        if (componentSampleModel.getBandOffsets()[0] != 0) {
            Decompressor.bgr2rgb(byArray[0]);
        }
        byte[][] byArray2 = byArray;
        int n5 = byArray.length;
        int n6 = 0;
        while (n6 < n5) {
            byte[] byArray3 = byArray2[n6];
            int n7 = 0;
            int n8 = 0;
            while (n7 < n) {
                outputStream.write(byArray3, n8, n3);
                ++n7;
                n8 += n4;
            }
            ++n6;
        }
    }

    private static void bgr2rgb(byte[] byArray) {
        int n = 0;
        int n2 = 2;
        while (n2 < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n2];
            byArray[n2] = by;
            n += 3;
            n2 += 3;
        }
    }

    private static void writeTo(SampleModel sampleModel, short[] sArray, OutputStream outputStream) throws IOException {
        int n = sampleModel.getHeight();
        int n2 = sampleModel.getWidth();
        int n3 = ((ComponentSampleModel)sampleModel).getScanlineStride();
        byte[] byArray = new byte[n2 * 2];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            int n6 = n4 * n3;
            while (n5 < byArray.length) {
                short s = sArray[n6++];
                byArray[n5++] = (byte)s;
                byArray[n5++] = (byte)(s >> 8);
            }
            outputStream.write(byArray);
            ++n4;
        }
    }

    private static void writeTo(SampleModel sampleModel, int[] nArray, OutputStream outputStream) throws IOException {
        int n = sampleModel.getHeight();
        int n2 = sampleModel.getWidth();
        int n3 = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        byte[] byArray = new byte[n2 * 3];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            int n6 = n4 * n3;
            while (n5 < byArray.length) {
                int n7 = nArray[n6++];
                byArray[n5++] = (byte)(n7 >> 16);
                byArray[n5++] = (byte)(n7 >> 8);
                byArray[n5++] = (byte)n7;
            }
            outputStream.write(byArray);
            ++n4;
        }
    }
}

