/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.image.Overlays;
import org.dcm4che3.imageio.codec.CompressionVerificationException;
import org.dcm4che3.imageio.codec.Decompressor;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.ImageWriterFactory;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageOutputStream;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compressor
extends Decompressor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Compressor.class);
    private BulkData pixeldata;
    private ImageWriter compressor;
    private ImageReader verifier;
    private PatchJPEGLS patchJPEGLS;
    private ImageWriteParam compressParam;
    private ImageInputStream iis;
    private IOException ex;
    private int[] embeddedOverlays;
    private int maxPixelValueError = -1;
    private int avgPixelValueBlockSize = 1;
    private BufferedImage bi2;
    private ImageReadParam verifyParam;

    public Compressor(Attributes attributes, String string) {
        super(attributes, string);
        Object object = attributes.getValue(2145386512);
        if (object == null) {
            return;
        }
        if (object instanceof BulkData) {
            this.pixeldata = (BulkData)object;
            if (this.pmi.isSubSambled()) {
                throw new UnsupportedOperationException("Unsupported Photometric Interpretation: " + (Object)((Object)this.pmi));
            }
            if (this.pixeldata.length < this.length) {
                throw new IllegalArgumentException("Pixel data too short: " + this.pixeldata.length + " instead " + this.length + " bytes");
            }
        }
        this.embeddedOverlays = Overlays.getEmbeddedOverlayGroupOffsets(attributes);
    }

    public boolean compress(String string, Property ... propertyArray) throws IOException {
        Object object;
        if (string == null) {
            throw new NullPointerException("desttsuid");
        }
        if (this.frames == 0) {
            return false;
        }
        ImageWriterFactory.ImageWriterParam imageWriterParam = ImageWriterFactory.getImageWriterParam(string);
        if (imageWriterParam == null) {
            throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + string);
        }
        this.compressor = ImageWriterFactory.getImageWriter(imageWriterParam);
        LOG.debug("Compressor: {}", (Object)this.compressor.getClass().getName());
        this.patchJPEGLS = imageWriterParam.patchJPEGLS;
        this.compressParam = this.compressor.getDefaultWriteParam();
        int n = 0;
        Object object2 = this.cat(imageWriterParam.getImageWriteParams(), propertyArray);
        int n2 = ((Property[])object2).length;
        int n3 = 0;
        while (n3 < n2) {
            object = object2[n3];
            String string2 = ((Property)object).getName();
            if (string2.equals("maxPixelValueError")) {
                this.maxPixelValueError = ((Number)((Property)object).getValue()).intValue();
            } else if (string2.equals("avgPixelValueBlockSize")) {
                this.avgPixelValueBlockSize = ((Number)((Property)object).getValue()).intValue();
            } else {
                if (n++ == 0) {
                    this.compressParam.setCompressionMode(2);
                }
                ((Property)object).setAt(this.compressParam);
            }
            ++n3;
        }
        if (this.maxPixelValueError >= 0) {
            object = ImageReaderFactory.getImageReaderParam(string);
            if (object == null) {
                throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + string);
            }
            this.verifier = ImageReaderFactory.getImageReader((ImageReaderFactory.ImageReaderParam)object);
            this.verifyParam = this.verifier.getDefaultReadParam();
            LOG.debug("Verifier: {}", (Object)this.verifier.getClass().getName());
        }
        object = TransferSyntaxType.forUID(string);
        if (this.decompressor == null || this.tstype == TransferSyntaxType.RLE) {
            this.bi = this.createBufferedImage(Math.min(this.bitsStored, ((TransferSyntaxType)((Object)object)).getMaxBitsStored()), this.tstype == TransferSyntaxType.RLE || this.banded, this.signed && ((TransferSyntaxType)((Object)object)).canEncodeSigned());
        }
        Fragments fragments = this.dataset.newFragments(2145386512, VR.OB, this.frames + 1);
        fragments.add(Value.NULL);
        n2 = 0;
        while (n2 < this.frames) {
            object2 = new CompressedFrame(n2);
            if (this.embeddedOverlays.length != 0) {
                ((CompressedFrame)object2).compress();
            }
            fragments.add(object2);
            ++n2;
        }
        if (this.samples > 1) {
            this.dataset.setString(2621444, VR.CS, (this.decompressor != null ? this.pmi.decompress() : this.pmi).compress(string).toString());
            this.dataset.setInt(2621446, VR.US, ((TransferSyntaxType)((Object)object)).getPlanarConfiguration());
        }
        int[] nArray = this.embeddedOverlays;
        int n4 = this.embeddedOverlays.length;
        int n5 = 0;
        while (n5 < n4) {
            n2 = nArray[n5];
            this.dataset.setInt(0x60000100 | n2, VR.US, 1);
            this.dataset.setInt(0x60000102 | n2, VR.US, 0);
            ++n5;
        }
        return true;
    }

    private Property[] cat(Property[] propertyArray, Property[] propertyArray2) {
        if (propertyArray.length == 0) {
            return propertyArray2;
        }
        if (propertyArray2.length == 0) {
            return propertyArray;
        }
        Property[] propertyArray3 = new Property[propertyArray.length + propertyArray2.length];
        System.arraycopy(propertyArray, 0, propertyArray3, 0, propertyArray.length);
        System.arraycopy(propertyArray2, 0, propertyArray3, propertyArray.length, propertyArray2.length);
        return propertyArray3;
    }

    @Override
    public void close() {
        if (this.iis != null) {
            try {
                this.iis.close();
            }
            catch (IOException iOException) {}
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.compressor != null) {
            this.compressor.dispose();
        }
        if (this.verifier != null) {
            this.verifier.dispose();
        }
        this.compressor = null;
        this.verifier = null;
    }

    public BufferedImage readFrame(int n) throws IOException {
        if (this.iis == null) {
            this.iis = new FileImageInputStream(this.file);
        }
        if (this.decompressor != null) {
            return this.decompressFrame(this.iis, n);
        }
        this.iis.setByteOrder(this.pixeldata.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.iis.seek(this.pixeldata.offset + (long)(this.frameLength * n));
        DataBuffer dataBuffer = this.bi.getRaster().getDataBuffer();
        switch (dataBuffer.getDataType()) {
            case 0: {
                byte[][] byArray = ((DataBufferByte)dataBuffer).getBankData();
                int n2 = byArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    byte[] byArray2 = byArray[n3];
                    this.iis.readFully(byArray2);
                    ++n3;
                }
                break;
            }
            case 1: {
                this.readFully(((DataBufferUShort)dataBuffer).getData());
                break;
            }
            case 2: {
                this.readFully(((DataBufferShort)dataBuffer).getData());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Datatype: " + dataBuffer.getDataType());
            }
        }
        return this.bi;
    }

    private void verify(MemoryCacheImageOutputStream memoryCacheImageOutputStream, int n) throws IOException {
        if (this.verifier == null) {
            return;
        }
        memoryCacheImageOutputStream.seek(0L);
        this.verifier.setInput(memoryCacheImageOutputStream);
        this.verifyParam.setDestination(this.bi2);
        long l = System.currentTimeMillis();
        this.bi2 = this.verifier.read(0, this.verifyParam);
        int n2 = this.maxDiff(this.bi.getRaster(), this.bi2.getRaster());
        long l2 = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verified compressed frame #{} in {} ms - max pixel value error: {}", new Object[]{n + 1, l2 - l, n2});
        }
        if (n2 > this.maxPixelValueError) {
            throw new CompressionVerificationException(n2);
        }
    }

    private int maxDiff(WritableRaster writableRaster, WritableRaster writableRaster2) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)writableRaster2.getSampleModel();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        int n = this.avgPixelValueBlockSize;
        if (n > 1) {
            int n2 = componentSampleModel.getWidth();
            int n3 = componentSampleModel.getHeight();
            int n4 = (n3 / n - 1) * n;
            int n5 = (n2 / n - 1) * n;
            int[] nArray = new int[n * n];
            int n6 = 0;
            int n7 = 0;
            while (n7 < componentSampleModel.getNumBands()) {
                int n8 = 0;
                while (n8 < n4) {
                    int n9 = 0;
                    while (n9 < n5) {
                        int n10 = Math.abs(this.sum(componentSampleModel.getSamples(n9, n8, n, n, n7, nArray, dataBuffer)) - this.sum(componentSampleModel2.getSamples(n9, n8, n, n, n7, nArray, dataBuffer2)));
                        if (n6 < n10) {
                            n6 = n10;
                        }
                        n9 += n;
                    }
                    n8 += n;
                }
                ++n7;
            }
            return n6 / nArray.length;
        }
        switch (dataBuffer.getDataType()) {
            case 0: {
                return this.maxDiff(componentSampleModel, ((DataBufferByte)dataBuffer).getBankData(), componentSampleModel2, ((DataBufferByte)dataBuffer2).getBankData());
            }
            case 1: {
                return this.maxDiff(componentSampleModel, ((DataBufferUShort)dataBuffer).getData(), componentSampleModel2, ((DataBufferUShort)dataBuffer2).getData());
            }
            case 2: {
                return this.maxDiff(componentSampleModel, ((DataBufferShort)dataBuffer).getData(), componentSampleModel2, ((DataBufferShort)dataBuffer2).getData());
            }
        }
        throw new UnsupportedOperationException("Unsupported Datatype: " + dataBuffer.getDataType());
    }

    private int sum(int[] nArray) {
        int n = 0;
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            n += n4;
            ++n3;
        }
        return n;
    }

    private int maxDiff(ComponentSampleModel componentSampleModel, short[] sArray, ComponentSampleModel componentSampleModel2, short[] sArray2) {
        int n = componentSampleModel.getWidth() * componentSampleModel.getPixelStride();
        int n2 = componentSampleModel.getHeight();
        int n3 = componentSampleModel.getScanlineStride();
        int n4 = componentSampleModel2.getScanlineStride();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = n;
            int n8 = n6 * n3;
            int n9 = n6 * n4;
            while (n7-- > 0) {
                int n10 = Math.abs(sArray[n8] - sArray2[n9]);
                if (n5 < n10) {
                    n5 = n10;
                }
                ++n8;
                ++n9;
            }
            ++n6;
        }
        return n5;
    }

    private int maxDiff(ComponentSampleModel componentSampleModel, byte[][] byArray, ComponentSampleModel componentSampleModel2, byte[][] byArray2) {
        int n = componentSampleModel.getWidth();
        int n2 = componentSampleModel.getHeight();
        int n3 = componentSampleModel.getNumBands();
        int n4 = componentSampleModel.getScanlineStride();
        int n5 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = componentSampleModel.getBandOffsets();
        int n6 = componentSampleModel2.getScanlineStride();
        int n7 = componentSampleModel2.getPixelStride();
        int[] nArray3 = componentSampleModel2.getBankIndices();
        int[] nArray4 = componentSampleModel2.getBandOffsets();
        int n8 = 0;
        int n9 = 0;
        while (n9 < n3) {
            byte[] byArray3 = byArray[nArray[n9]];
            byte[] byArray4 = byArray2[nArray3[n9]];
            int n10 = nArray2[n9];
            int n11 = nArray4[n9];
            int n12 = 0;
            while (n12 < n2) {
                int n13 = n;
                int n14 = n12 * n4 + n10;
                int n15 = n12 * n6 + n11;
                while (n13-- > 0) {
                    int n16 = Math.abs(byArray3[n14] - byArray4[n15]);
                    if (n8 < n16) {
                        n8 = n16;
                    }
                    n14 += n5;
                    n15 += n7;
                }
                ++n12;
            }
            ++n9;
        }
        return n8;
    }

    private void nullifyUnusedBits(int n, BufferedImage bufferedImage) {
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        switch (dataBuffer.getDataType()) {
            case 1: {
                this.nullifyUnusedBits(n, ((DataBufferUShort)dataBuffer).getData());
                break;
            }
            case 2: {
                this.nullifyUnusedBits(n, ((DataBufferShort)dataBuffer).getData());
            }
        }
    }

    private void nullifyUnusedBits(int n, short[] sArray) {
        int n2 = (1 << n) - 1;
        int n3 = 0;
        while (n3 < sArray.length) {
            int n4 = n3++;
            sArray[n4] = (short)(sArray[n4] & n2);
        }
    }

    private void extractEmbeddedOverlays(int n, BufferedImage bufferedImage) {
        int[] nArray = this.embeddedOverlays;
        int n2 = this.embeddedOverlays.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = this.dataset.getInt(0x60000010 | n4, 0);
            int n6 = this.dataset.getInt(0x60000011 | n4, 0);
            int n7 = this.dataset.getInt(0x60000102 | n4, 0);
            int n8 = 1 << n7;
            int n9 = n5 * n6;
            byte[] byArray = this.dataset.getSafeBytes(0x60003000 | n4);
            if (byArray == null) {
                byArray = new byte[(n9 * this.frames + 7 >>> 3) + 1 & 0xFFFFFFFE];
                this.dataset.setBytes(0x60003000 | n4, VR.OB, byArray);
            }
            Overlays.extractFromPixeldata(bufferedImage.getRaster(), n8, byArray, n9 * n, n9);
            LOG.debug("Extracted embedded overlay #{} from bit #{} of frame #{}", new Object[]{(n4 >>> 17) + 1, n7, n + 1});
            ++n3;
        }
    }

    private void readFully(short[] sArray) throws IOException {
        this.iis.readFully(sArray, 0, sArray.length);
    }

    private static class CacheOutputStream
    extends FilterOutputStream {
        public CacheOutputStream() {
            super(null);
        }

        public void set(OutputStream outputStream) {
            this.out = outputStream;
        }
    }

    private class CompressedFrame
    implements Value {
        private int frameIndex;
        private int streamLength;
        private CacheOutputStream cacheout = new CacheOutputStream();
        private MemoryCacheImageOutputStream cache;

        public CompressedFrame(int n) throws IOException {
            this.frameIndex = n;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public byte[] toBytes(VR vR, boolean bl) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeTo(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public void writeTo(DicomOutputStream dicomOutputStream, VR vR) throws IOException {
            this.writeTo(dicomOutputStream);
        }

        @Override
        public int calcLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
            return this.getEncodedLength(dicomEncodingOptions, bl, vR);
        }

        @Override
        public int getEncodedLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
            try {
                this.compress();
            }
            catch (IOException iOException) {
                return -1;
            }
            return this.streamLength + 1 & 0xFFFFFFFE;
        }

        private void writeTo(OutputStream outputStream) throws IOException {
            this.compress();
            try {
                this.cacheout.set(outputStream);
                long l = System.currentTimeMillis();
                this.cache.seek(this.streamLength);
                this.cache.flushBefore(this.streamLength);
                if ((this.streamLength & 1) != 0) {
                    outputStream.write(0);
                }
                long l2 = System.currentTimeMillis();
                LOG.debug("Flushed frame #{} from memory in {} ms", (Object)(this.frameIndex + 1), (Object)(l2 - l));
            }
            catch (Throwable throwable) {
                try {
                    this.cache.close();
                }
                catch (IOException iOException) {}
                this.cache = null;
                throw throwable;
            }
            try {
                this.cache.close();
            }
            catch (IOException iOException) {}
            this.cache = null;
        }

        private void compress() throws IOException {
            if (this.cache != null) {
                return;
            }
            if (Compressor.this.ex != null) {
                throw Compressor.this.ex;
            }
            try {
                BufferedImage bufferedImage = Compressor.this.readFrame(this.frameIndex);
                Compressor.this.extractEmbeddedOverlays(this.frameIndex, bufferedImage);
                if (Compressor.this.bitsStored < Compressor.this.bitsAllocated) {
                    Compressor.this.nullifyUnusedBits(Compressor.this.bitsStored, bufferedImage);
                }
                this.cache = new MemoryCacheImageOutputStream(this.cacheout){

                    @Override
                    public void flush() throws IOException {
                        LOG.debug("Ignore invoke of MemoryCacheImageOutputStream.flush()");
                    }
                };
                Compressor.this.compressor.setOutput(Compressor.this.patchJPEGLS != null ? new PatchJPEGLSImageOutputStream(this.cache, Compressor.this.patchJPEGLS) : this.cache);
                long l = System.currentTimeMillis();
                Compressor.this.compressor.write(null, new IIOImage(bufferedImage, null, null), Compressor.this.compressParam);
                long l2 = System.currentTimeMillis();
                this.streamLength = (int)this.cache.getStreamPosition();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Compressed frame #{} {}:1 in {} ms", new Object[]{this.frameIndex + 1, Float.valueOf((float)Compressor.sizeOf(bufferedImage) / (float)this.streamLength), l2 - l});
                }
                Compressor.this.verify(this.cache, this.frameIndex);
            }
            catch (IOException iOException) {
                this.cache = null;
                Compressor.this.ex = iOException;
                throw iOException;
            }
        }
    }
}

