/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.io.Serializable;
import java.util.EnumSet;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.util.Property;
import org.dcm4che3.util.StringUtils;

public class CompressionRule
implements Comparable<CompressionRule>,
Serializable {
    private static final long serialVersionUID = 2010254518169306864L;
    private final String commonName;
    private final Condition condition;
    private final String tsuid;
    private final Property[] imageWriteParams;

    public CompressionRule(String string, String[] stringArray, int[] nArray, int n, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string2, String ... stringArray5) {
        this.commonName = string;
        this.condition = new Condition(stringArray, nArray, n, StringUtils.maskNull(stringArray2), StringUtils.maskNull(stringArray3), StringUtils.maskNull(stringArray4));
        this.tsuid = string2;
        this.imageWriteParams = Property.valueOf(stringArray5);
    }

    public final String getCommonName() {
        return this.commonName;
    }

    public PhotometricInterpretation[] getPhotometricInterpretations() {
        return this.condition.getPhotometricInterpretations();
    }

    public int[] getBitsStored() {
        return this.condition.getBitsStored();
    }

    public final int getPixelRepresentation() {
        return this.condition.pixelRepresentation;
    }

    public final String[] getAETitles() {
        return this.condition.aeTitles;
    }

    public final String[] getSOPClasses() {
        return this.condition.sopClasses;
    }

    public final String[] getBodyPartExamined() {
        return this.condition.bodyPartExamined;
    }

    public final String getTransferSyntax() {
        return this.tsuid;
    }

    public Property[] getImageWriteParams() {
        return this.imageWriteParams;
    }

    public boolean matchesCondition(PhotometricInterpretation photometricInterpretation, int n, int n2, String string, String string2, String string3) {
        return this.condition.matches(photometricInterpretation, n, n2, string, string2, string3);
    }

    @Override
    public int compareTo(CompressionRule compressionRule) {
        return this.condition.compareTo(compressionRule.condition);
    }

    private static class Condition
    implements Comparable<Condition>,
    Serializable {
        private static final long serialVersionUID = -4069284624944470710L;
        final EnumSet<PhotometricInterpretation> pmis = EnumSet.noneOf(PhotometricInterpretation.class);
        final int bitsStoredMask;
        final int pixelRepresentation = -1;
        final String[] aeTitles;
        final String[] sopClasses;
        final String[] bodyPartExamined;
        final int weight;

        Condition(String[] stringArray, int[] nArray, int n, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
            String[] stringArray5 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray5[n3];
                this.pmis.add(PhotometricInterpretation.fromString(string));
                ++n3;
            }
            this.bitsStoredMask = this.toBitsStoredMask(nArray);
            this.aeTitles = stringArray2;
            this.sopClasses = stringArray3;
            this.bodyPartExamined = stringArray4;
            this.weight = (stringArray2.length != 0 ? 4 : 0) + (stringArray3.length != 0 ? 2 : 0) + (stringArray4.length != 0 ? 1 : 0);
        }

        private int toBitsStoredMask(int[] nArray) {
            int n = 0;
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                n |= 1 << n4;
                ++n3;
            }
            return n;
        }

        PhotometricInterpretation[] getPhotometricInterpretations() {
            return this.pmis.toArray(new PhotometricInterpretation[this.pmis.size()]);
        }

        int[] getBitsStored() {
            int n = 0;
            int n2 = 8;
            while (n2 <= 16) {
                if (this.matchBitStored(n2)) {
                    ++n;
                }
                ++n2;
            }
            int[] nArray = new int[n];
            int n3 = 8;
            int n4 = 0;
            while (n3 <= 16) {
                if (this.matchBitStored(n3)) {
                    nArray[n4++] = n3;
                }
                ++n3;
            }
            return nArray;
        }

        @Override
        public int compareTo(Condition condition) {
            return condition.weight - this.weight;
        }

        public boolean matches(PhotometricInterpretation photometricInterpretation, int n, int n2, String string, String string2, String string3) {
            return this.pmis.contains((Object)photometricInterpretation) && this.matchBitStored(n) && this.matchPixelRepresentation(n2) && Condition.isEmptyOrContains(this.aeTitles, string) && Condition.isEmptyOrContains(this.sopClasses, string2) && Condition.isEmptyOrContains(this.bodyPartExamined, string3);
        }

        private boolean matchPixelRepresentation(int n) {
            return -1 == -1 || -1 == n;
        }

        private boolean matchBitStored(int n) {
            return (1 << n & this.bitsStoredMask) != 0;
        }

        private static boolean isEmptyOrContains(Object[] objectArray, Object object) {
            if (object == null || objectArray.length == 0) {
                return true;
            }
            int n = 0;
            while (n < objectArray.length) {
                if (object.equals(objectArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

