/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.SampleModel;
import org.dcm4che3.image.ColorSubsampling;

public class SampledComponentSampleModel
extends SampleModel {
    private final ColorSubsampling subsampling;

    public SampledComponentSampleModel(int n, int n2, ColorSubsampling colorSubsampling) {
        super(0, n, n2, 3);
        this.subsampling = colorSubsampling;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new SampledComponentSampleModel(n, n2, this.subsampling);
    }

    @Override
    public DataBuffer createDataBuffer() {
        return new DataBufferByte(this.subsampling.frameLength(this.width, this.height));
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length != 3 || nArray[0] != 0 || nArray[1] != 1 || nArray[2] != 2) {
            throw new UnsupportedOperationException();
        }
        return this;
    }

    @Override
    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        byte[] byArray = object instanceof byte[] && ((byte[])object).length == 3 ? (byte[])object : new byte[3];
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        byte[] byArray2 = dataBufferByte.getData();
        int n3 = this.subsampling.indexOfY(n, n2, this.width);
        int n4 = this.subsampling.indexOfBR(n, n2, this.width);
        byArray[0] = byArray2[n3];
        byArray[1] = byArray2[n4];
        byArray[2] = byArray2[n4 + 1];
        return byArray;
    }

    @Override
    public int getNumDataElements() {
        return 3;
    }

    @Override
    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        return ((byte[])this.getDataElements(n, n2, null, dataBuffer))[n3];
    }

    @Override
    public int[] getSampleSize() {
        return new int[]{8, 8, 8};
    }

    @Override
    public int getSampleSize(int n) {
        return 8;
    }

    @Override
    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        throw new UnsupportedOperationException();
    }
}

