/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import org.dcm4che3.image.ColorSubsampling;
import org.dcm4che3.image.SampledComponentSampleModel;

public class SampledComponentColorModel
extends ColorModel {
    private static final int[] BITS = new int[]{8, 8, 8};
    private final ColorSubsampling subsampling;

    public SampledComponentColorModel(ColorSpace colorSpace, ColorSubsampling colorSubsampling) {
        super(24, BITS, colorSpace, false, false, 1, 0);
        this.subsampling = colorSubsampling;
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof SampledComponentSampleModel;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new SampledComponentSampleModel(n, n2, this.subsampling);
    }

    @Override
    public int getAlpha(int n) {
        return 255;
    }

    @Override
    public int getBlue(int n) {
        return n & 0xFF;
    }

    @Override
    public int getGreen(int n) {
        return n & 0xFF00;
    }

    @Override
    public int getRed(int n) {
        return n & 0xFF0000;
    }

    @Override
    public int getAlpha(Object object) {
        return 255;
    }

    @Override
    public int getBlue(Object object) {
        return this.getRGB(object) & 0xFF;
    }

    @Override
    public int getGreen(Object object) {
        return this.getRGB(object) >> 8 & 0xFF;
    }

    @Override
    public int getRed(Object object) {
        return this.getRGB(object) >> 16;
    }

    @Override
    public int getRGB(Object object) {
        byte[] byArray = (byte[])object;
        ColorSpace colorSpace = this.getColorSpace();
        float[] fArray = new float[]{(float)(byArray[0] & 0xFF) / 255.0f, (float)(byArray[1] & 0xFF) / 255.0f, (float)(byArray[2] & 0xFF) / 255.0f};
        float[] fArray2 = colorSpace.toRGB(fArray);
        int n = (int)(fArray2[0] * 255.0f) << 16 | (int)(fArray2[1] * 255.0f) << 8 | (int)(fArray2[2] * 255.0f);
        return n;
    }
}

