/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.image.LookupTableFactory;

public class PaletteColorModel
extends ColorModel {
    private static final int[] opaqueBits = new int[]{8, 8, 8};
    private final LUT lut;

    public PaletteColorModel(int n, int n2, ColorSpace colorSpace, Attributes attributes) {
        super(n, opaqueBits, colorSpace, false, false, 1, n2);
        int[] nArray = this.lutDescriptor(attributes, 2625793);
        int[] nArray2 = this.lutDescriptor(attributes, 2625794);
        int[] nArray3 = this.lutDescriptor(attributes, 2625795);
        byte[] byArray = this.lutData(attributes, nArray, 2626049, 0x281221);
        byte[] byArray2 = this.lutData(attributes, nArray2, 2626050, 0x281222);
        byte[] byArray3 = this.lutData(attributes, nArray3, 2626051, 2626083);
        this.lut = LUT.create(n, byArray, byArray2, byArray3, nArray[1], nArray2[1], nArray3[1]);
    }

    private int[] lutDescriptor(Attributes attributes, int n) {
        int[] nArray = attributes.getInts(n);
        if (nArray == null) {
            throw new IllegalArgumentException("Missing LUT Descriptor!");
        }
        if (nArray.length != 3) {
            throw new IllegalArgumentException("Illegal number of LUT Descriptor values: " + nArray.length);
        }
        if (nArray[0] < 0) {
            throw new IllegalArgumentException("Illegal LUT Descriptor: len=" + nArray[0]);
        }
        int n2 = nArray[2];
        if (n2 != 8 && n2 != 16) {
            throw new IllegalArgumentException("Illegal LUT Descriptor: bits=" + n2);
        }
        return nArray;
    }

    private byte[] lutData(Attributes attributes, int[] nArray, int n, int n2) {
        int n3 = nArray[0] == 0 ? 65536 : nArray[0];
        int n4 = nArray[2];
        byte[] byArray = attributes.getSafeBytes(n);
        if (byArray == null) {
            int[] nArray2 = attributes.getInts(n2);
            if (nArray2 == null) {
                throw new IllegalArgumentException("Missing LUT Data!");
            }
            if (n4 == 8) {
                throw new IllegalArgumentException("Segmented LUT Data with LUT Descriptor: bits=8");
            }
            byArray = new byte[n3];
            this.inflateSegmentedLut(nArray2, byArray);
        } else if (n4 == 16 || byArray.length != n3) {
            int n5;
            if (byArray.length != n3 << 1) {
                PaletteColorModel.lutLengthMismatch(byArray.length, n3);
            }
            int n6 = n5 = attributes.bigEndian() ? 0 : 1;
            if (n4 == 8) {
                n5 = 1 - n5;
            }
            byArray = LookupTableFactory.halfLength(byArray, n5);
        }
        return byArray;
    }

    private void inflateSegmentedLut(int[] nArray, byte[] byArray) {
        int n = 0;
        try {
            int n2 = 0;
            block11: while (n2 < nArray.length) {
                int n3 = nArray[n2++];
                int n4 = nArray[n2++];
                switch (n3) {
                    case 0: {
                        while (n4-- > 0) {
                            byArray[n++] = (byte)nArray[n2++];
                        }
                        continue block11;
                    }
                    case 1: {
                        n = PaletteColorModel.linearSegment(nArray[n2++], byArray, n, n4);
                        break;
                    }
                    case 2: {
                        int n5 = nArray[n2++] & 0xFFFF | nArray[n2++] << 16;
                        block13: while (n4-- > 0) {
                            int n6 = nArray[n5++];
                            int n7 = nArray[n5++] & 0xFFFF;
                            switch (n6) {
                                case 0: {
                                    while (n7-- > 0) {
                                        byArray[n++] = (byte)nArray[n5++];
                                    }
                                    continue block13;
                                }
                                case 1: {
                                    n = PaletteColorModel.linearSegment(nArray[n5++], byArray, n, n4);
                                    break;
                                }
                                default: {
                                    PaletteColorModel.illegalOpcode(n3, n5 - 2);
                                }
                            }
                        }
                    }
                    default: {
                        PaletteColorModel.illegalOpcode(n3, n2 - 2);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (n > byArray.length) {
                PaletteColorModel.exceedsLutLength(byArray.length);
            }
            PaletteColorModel.endOfSegmentedLut();
        }
        if (n < byArray.length) {
            PaletteColorModel.lutLengthMismatch(n, byArray.length);
        }
    }

    private static void endOfSegmentedLut() {
        throw new IllegalArgumentException("Running out of data inflating segmented LUT");
    }

    private static int linearSegment(int n, byte[] byArray, int n2, int n3) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Linear segment cannot be the first segment");
        }
        try {
            byte by = byArray[n2 - 1];
            int n4 = n - by;
            int n5 = 1;
            while (n5 <= n3) {
                byArray[n2++] = (byte)(by + n4 * n5 / n3 >> 8);
                ++n5;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            PaletteColorModel.exceedsLutLength(byArray.length);
        }
        return n2;
    }

    private static void exceedsLutLength(int n) {
        throw new IllegalArgumentException("Number of entries in inflated segmented LUT exceeds specified value: " + n + " in LUT Descriptor");
    }

    private static void lutLengthMismatch(int n, int n2) {
        throw new IllegalArgumentException("Number of actual LUT entries: " + n + " mismatch specified value: " + n2 + " in LUT Descriptor");
    }

    private static void illegalOpcode(int n, int n2) {
        throw new IllegalArgumentException("illegal op code:" + n + ", index:" + n2);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel.getTransferType() == this.transferType && sampleModel.getNumBands() == 1;
    }

    @Override
    public int getRed(int n) {
        return this.lut.getRed(n);
    }

    @Override
    public int getGreen(int n) {
        return this.lut.getGreen(n);
    }

    @Override
    public int getBlue(int n) {
        return this.lut.getBlue(n);
    }

    @Override
    public int getAlpha(int n) {
        return this.lut.getAlpha(n);
    }

    @Override
    public int getRGB(int n) {
        return this.lut.getRGB(n);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        return Raster.createInterleavedRaster(this.pixel_bits <= 8 ? 0 : 1, n, n2, 1, null);
    }

    public BufferedImage convertToIntDiscrete(Raster raster) {
        if (!this.isCompatibleRaster(raster)) {
            throw new IllegalArgumentException("This raster is not compatible with this PaletteColorModel.");
        }
        DirectColorModel directColorModel = new DirectColorModel(this.getColorSpace(), 24, 0xFF0000, 65280, 255, 0, false, 3);
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        WritableRaster writableRaster = ((ColorModel)directColorModel).createCompatibleWritableRaster(n, n2);
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            int n3 = 0;
            while (n3 < byArray.length) {
                nArray[n3] = this.getRGB(byArray[n3]);
                ++n3;
            }
        } else {
            short[] sArray = ((DataBufferUShort)dataBuffer).getData();
            int n4 = 0;
            while (n4 < sArray.length) {
                nArray[n4] = this.getRGB(sArray[n4]);
                ++n4;
            }
        }
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }

    private static abstract class LUT {
        final int mask;

        LUT(int n) {
            this.mask = (1 << n) - 1;
        }

        public static LUT create(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3, int n4) {
            return byArray.length == byArray2.length && byArray2.length == byArray3.length && n2 == n3 && n3 == n4 ? new Packed(n, byArray, byArray2, byArray3, n2) : new PerColor(n, byArray, byArray2, byArray3, n2, n3, n4);
        }

        int index(int n, int n2, int n3) {
            return Math.min(Math.max(0, (n & this.mask) - n2), n3 - 1);
        }

        abstract int getRed(int var1);

        abstract int getGreen(int var1);

        abstract int getBlue(int var1);

        abstract int getAlpha(int var1);

        abstract int getRGB(int var1);

        static class Packed
        extends LUT {
            final int offset;
            final int[] rgb;

            Packed(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
                super(n);
                int n3 = byArray.length;
                this.offset = n2;
                this.rgb = new int[n3];
                int n4 = 0;
                while (n4 < byArray.length) {
                    this.rgb[n4] = 0xFF000000 | (byArray[n4] & 0xFF) << 16 | (byArray2[n4] & 0xFF) << 8 | byArray3[n4] & 0xFF;
                    ++n4;
                }
            }

            @Override
            public int getAlpha(int n) {
                return this.rgb[this.index(n, this.offset, this.rgb.length)] >> 24 & 0xFF;
            }

            @Override
            public int getRed(int n) {
                return this.rgb[this.index(n, this.offset, this.rgb.length)] >> 16 & 0xFF;
            }

            @Override
            public int getGreen(int n) {
                return this.rgb[this.index(n, this.offset, this.rgb.length)] >> 8 & 0xFF;
            }

            @Override
            public int getBlue(int n) {
                return this.rgb[this.index(n, this.offset, this.rgb.length)] & 0xFF;
            }

            @Override
            public int getRGB(int n) {
                return this.rgb[this.index(n, this.offset, this.rgb.length)];
            }
        }

        static class PerColor
        extends LUT {
            final byte[] r;
            final byte[] g;
            final byte[] b;
            final int rOffset;
            final int gOffset;
            final int bOffset;

            PerColor(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3, int n4) {
                super(n);
                this.r = byArray;
                this.g = byArray2;
                this.b = byArray3;
                this.rOffset = n2;
                this.gOffset = n3;
                this.bOffset = n4;
            }

            @Override
            public int getAlpha(int n) {
                return 255;
            }

            @Override
            public int getRed(int n) {
                return this.value(n, this.rOffset, this.r);
            }

            @Override
            public int getGreen(int n) {
                return this.value(n, this.gOffset, this.g);
            }

            @Override
            public int getBlue(int n) {
                return this.value(n, this.bOffset, this.b);
            }

            @Override
            public int getRGB(int n) {
                return 0xFF000000 | this.value(n, this.rOffset, this.r) << 16 | this.value(n, this.gOffset, this.g) << 8 | this.value(n, this.bOffset, this.b);
            }

            int value(int n, int n2, byte[] byArray) {
                return byArray[this.index(n, n2, byArray.length)] & 0xFF;
            }
        }
    }
}

