/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.util.TagUtils;

public class Overlays {
    public static int[] getActiveOverlayGroupOffsets(Attributes attributes) {
        return Overlays.getOverlayGroupOffsets(attributes, 0x60001001, -1);
    }

    public static int[] getActiveOverlayGroupOffsets(Attributes attributes, int n) {
        return Overlays.getOverlayGroupOffsets(attributes, 0x60000010, n);
    }

    public static int[] getOverlayGroupOffsets(Attributes attributes, int n, int n2) {
        int n3 = 0;
        int[] nArray = new int[16];
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = n4 << 17;
            if ((n2 & 1 << n4) != 0 && attributes.containsValue(n | n5)) {
                nArray[n3++] = n5;
            }
            ++n4;
        }
        return Arrays.copyOf(nArray, n3);
    }

    public static int[] getEmbeddedOverlayGroupOffsets(Attributes attributes) {
        int n = 0;
        int[] nArray = new int[16];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2 << 17;
            if (attributes.getInt(0x60000100 | n3, 1) != 1) {
                nArray[n++] = n3;
            }
            ++n2;
        }
        return Arrays.copyOf(nArray, n);
    }

    public static void extractFromPixeldata(Raster raster, int n, byte[] byArray, int n2, int n3) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n4 = raster.getHeight();
        int n5 = raster.getWidth();
        int n6 = componentSampleModel.getScanlineStride();
        DataBuffer dataBuffer = raster.getDataBuffer();
        switch (dataBuffer.getDataType()) {
            case 0: {
                Overlays.extractFromPixeldata(((DataBufferByte)dataBuffer).getData(), n4, n5, n6, n, byArray, n2, n3);
                break;
            }
            case 1: {
                Overlays.extractFromPixeldata(((DataBufferUShort)dataBuffer).getData(), n4, n5, n6, n, byArray, n2, n3);
                break;
            }
            case 2: {
                Overlays.extractFromPixeldata(((DataBufferShort)dataBuffer).getData(), n4, n5, n6, n, byArray, n2, n3);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported DataBuffer type: " + dataBuffer.getDataType());
            }
        }
    }

    private static void extractFromPixeldata(byte[] byArray, int n, int n2, int n3, int n4, byte[] byArray2, int n5, int n6) {
        int n7 = 0;
        int n8 = n5;
        int n9 = n5 + n6;
        while (n7 < n2 && n8 < n9) {
            int n10 = n7 * n3;
            int n11 = n10 + n;
            while (n10 < n11 && n8 < n9) {
                if ((byArray[n10] & n4) != 0) {
                    int n12 = n8 >>> 3;
                    byArray2[n12] = (byte)(byArray2[n12] | 1 << (n8 & 7));
                }
                ++n10;
                ++n8;
            }
            ++n7;
        }
    }

    private static void extractFromPixeldata(short[] sArray, int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        int n7 = 0;
        int n8 = n5;
        int n9 = n5 + n6;
        while (n7 < n2 && n8 < n9) {
            int n10 = n7 * n3;
            int n11 = n10 + n;
            while (n10 < n11 && n8 < n9) {
                if ((sArray[n10] & n4) != 0) {
                    int n12 = n8 >>> 3;
                    byArray[n12] = (byte)(byArray[n12] | 1 << (n8 & 7));
                }
                ++n10;
                ++n8;
            }
            ++n7;
        }
    }

    public static int getRecommendedDisplayGrayscaleValue(Attributes attributes, int n) {
        int n2 = 0x60001001 | n;
        String string = attributes.getString(n2);
        if (string == null) {
            throw new IllegalArgumentException("Missing " + TagUtils.toString(n2) + " Overlay Activation Layer");
        }
        Sequence sequence = attributes.getSequence(0x700060);
        if (sequence == null) {
            throw new IllegalArgumentException("Missing " + TagUtils.toString(0x700060) + " Graphic Layer Sequence");
        }
        for (Attributes attributes2 : sequence) {
            if (!string.equals(attributes2.getString(0x700002))) continue;
            return attributes2.getInt(6422540, -1);
        }
        throw new IllegalArgumentException("No Graphic Layer: " + string);
    }

    public static void applyOverlay(int n, WritableRaster writableRaster, Attributes attributes, int n2, int n3, byte[] byArray) {
        int n4 = attributes.getInt(0x60000051 | n2, 1);
        int n5 = attributes.getInt(0x60000015 | n2, 1);
        int n6 = n - n4 + 1;
        if (n6 < 0 || n6 >= n5) {
            return;
        }
        int n7 = 0x60000010 | n2;
        int n8 = 0x60000011 | n2;
        int n9 = 0x60003000 | n2;
        int n10 = 0x60000050 | n2;
        int n11 = attributes.getInt(n7, -1);
        int n12 = attributes.getInt(n8, -1);
        int[] nArray = attributes.getInts(n10);
        if (byArray == null) {
            byArray = attributes.getSafeBytes(n9);
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Missing " + TagUtils.toString(n9) + " Overlay Data");
        }
        if (n11 <= 0) {
            throw new IllegalArgumentException(String.valueOf(TagUtils.toString(n7)) + " Overlay Rows [" + n11 + "]");
        }
        if (n12 <= 0) {
            throw new IllegalArgumentException(String.valueOf(TagUtils.toString(n8)) + " Overlay Columns [" + n12 + "]");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("Missing " + TagUtils.toString(n10) + " Overlay Origin");
        }
        if (nArray.length != 2) {
            throw new IllegalArgumentException(String.valueOf(TagUtils.toString(n10)) + " Overlay Origin " + Arrays.toString(nArray));
        }
        int n13 = nArray[1] - 1;
        int n14 = nArray[0] - 1;
        int n15 = n11 * n12;
        int n16 = n15 * n6;
        int n17 = n16 >>> 3;
        int n18 = n16 + n15 + 7 >>> 3;
        while (n17 < n18) {
            int n19 = byArray[n17] & 0xFF;
            int n20 = 0;
            while (n19 >>> n20 != 0) {
                int n21;
                if ((n19 & 1 << n20) != 0 && (n21 = (n17 << 3) + n20 - n16) < n15) {
                    int n22 = n14 + n21 / n12;
                    int n23 = n13 + n21 % n12;
                    try {
                        writableRaster.setSample(n23, n22, 0, n3);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                }
                ++n20;
            }
            ++n17;
        }
    }
}

