/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.image.ByteLookupTable;
import org.dcm4che3.image.LookupTable;
import org.dcm4che3.image.ShortLookupTable;
import org.dcm4che3.image.StoredValue;
import org.dcm4che3.util.ByteUtils;

public class LookupTableFactory {
    private final StoredValue storedValue;
    private float rescaleSlope = 1.0f;
    private float rescaleIntercept = 0.0f;
    private LookupTable modalityLUT;
    private float windowCenter;
    private float windowWidth;
    private String voiLUTFunction;
    private LookupTable voiLUT;
    private LookupTable presentationLUT;
    private boolean inverse;

    public LookupTableFactory(StoredValue storedValue) {
        this.storedValue = storedValue;
    }

    public void setModalityLUT(Attributes attributes) {
        this.rescaleIntercept = attributes.getFloat(2625618, 0.0f);
        this.rescaleSlope = attributes.getFloat(2625619, 1.0f);
        this.modalityLUT = this.createLUT(this.storedValue, attributes.getNestedDataset(2633728));
    }

    public void setPresentationLUT(Attributes attributes) {
        Attributes attributes2 = attributes.getNestedDataset(542113808);
        if (attributes2 != null) {
            int[] nArray = attributes2.getInts(2633730);
            if (nArray != null && nArray.length == 3) {
                int n = nArray[0] == 0 ? 65536 : nArray[0];
                this.presentationLUT = this.createLUT(new StoredValue.Unsigned(LookupTableFactory.log2(n)), this.resetOffset(nArray), attributes2.getSafeBytes(2633734), attributes2.bigEndian());
            }
        } else {
            String string = attributes.getString(0x20500020);
            this.inverse = string != null ? "INVERSE".equals(string) : "MONOCHROME1".equals(attributes.getString(2621444));
        }
    }

    private int[] resetOffset(int[] nArray) {
        if (nArray[1] == 0) {
            return nArray;
        }
        int[] nArray2 = (int[])nArray.clone();
        nArray2[1] = 0;
        return nArray2;
    }

    public void setWindowCenter(float f) {
        this.windowCenter = f;
    }

    public void setWindowWidth(float f) {
        this.windowWidth = f;
    }

    public void setVOI(Attributes attributes, int n, int n2, boolean bl) {
        if (attributes == null) {
            return;
        }
        Attributes attributes2 = attributes.getNestedDataset(2633744, n2);
        if (bl || attributes2 == null) {
            float[] fArray = attributes.getFloats(2625616);
            float[] fArray2 = attributes.getFloats(2625617);
            if (fArray != null && fArray.length != 0 && fArray2 != null && fArray2.length != 0) {
                int n3 = n < Math.min(fArray.length, fArray2.length) ? n : 0;
                this.windowCenter = fArray[n3];
                this.windowWidth = fArray2[n3];
                return;
            }
        }
        if (attributes2 != null) {
            this.voiLUT = this.createLUT(this.modalityLUT != null ? new StoredValue.Unsigned(this.modalityLUT.outBits) : this.storedValue, attributes2);
        }
    }

    private LookupTable createLUT(StoredValue storedValue, Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return this.createLUT(storedValue, attributes.getInts(2633730), attributes.getSafeBytes(2633734), attributes.bigEndian());
    }

    private LookupTable createLUT(StoredValue storedValue, int[] nArray, byte[] byArray, boolean bl) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length != 3) {
            return null;
        }
        int n = nArray[0] == 0 ? 65536 : nArray[0];
        short s = (short)nArray[1];
        int n2 = nArray[2];
        if (byArray == null) {
            return null;
        }
        if (byArray.length == n << 1) {
            if (n2 > 8) {
                if (n2 > 16) {
                    return null;
                }
                short[] sArray = new short[n];
                if (bl) {
                    int n3 = 0;
                    while (n3 < sArray.length) {
                        sArray[n3] = (short)ByteUtils.bytesToShortBE(byArray, n3 << 1);
                        ++n3;
                    }
                } else {
                    int n4 = 0;
                    while (n4 < sArray.length) {
                        sArray[n4] = (short)ByteUtils.bytesToShortLE(byArray, n4 << 1);
                        ++n4;
                    }
                }
                return new ShortLookupTable(storedValue, n2, s, sArray);
            }
            byArray = LookupTableFactory.halfLength(byArray, bl ? 1 : 0);
        }
        if (byArray.length != n) {
            return null;
        }
        if (n2 > 8) {
            return null;
        }
        return new ByteLookupTable(storedValue, n2, s, byArray);
    }

    static byte[] halfLength(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length >> 1];
        int n2 = 0;
        while (n2 < byArray2.length) {
            byArray2[n2] = byArray[n2 << 1 | n];
            ++n2;
        }
        return byArray2;
    }

    public LookupTable createLUT(int n) {
        LookupTable lookupTable = this.combineModalityVOILUT(this.presentationLUT != null ? LookupTableFactory.log2(this.presentationLUT.length()) : n);
        if (this.presentationLUT != null) {
            lookupTable = lookupTable.combine(this.presentationLUT.adjustOutBits(n));
        } else if (this.inverse) {
            lookupTable.inverse();
        }
        return lookupTable;
    }

    private static int log2(int n) {
        int n2 = 0;
        while (n >>> n2 != 0) {
            ++n2;
        }
        return n2 - 1;
    }

    private LookupTable combineModalityVOILUT(int n) {
        float f = this.rescaleSlope;
        float f2 = this.rescaleIntercept;
        LookupTable lookupTable = this.modalityLUT;
        LookupTable lookupTable2 = this.voiLUT;
        if (lookupTable2 == null) {
            int n2;
            int n3;
            StoredValue storedValue;
            float f3 = this.windowCenter;
            float f4 = this.windowWidth;
            if (f4 == 0.0f && lookupTable != null) {
                return lookupTable.adjustOutBits(n);
            }
            StoredValue storedValue2 = storedValue = lookupTable != null ? new StoredValue.Unsigned(lookupTable.outBits) : this.storedValue;
            if (f4 != 0.0f) {
                n3 = Math.max(2, Math.abs(Math.round(f4 / f)));
                n2 = Math.round(f3 / f - f2) - n3 / 2;
            } else {
                n2 = storedValue.minValue();
                n3 = storedValue.maxValue() - storedValue.minValue() + 1;
            }
            lookupTable2 = n > 8 ? new ShortLookupTable(storedValue, n, n2, n3, f < 0.0f) : new ByteLookupTable(storedValue, n, n2, n3, f < 0.0f);
        } else {
            lookupTable2 = lookupTable2.adjustOutBits(n);
        }
        return lookupTable != null ? lookupTable.combine(lookupTable2) : lookupTable2;
    }

    public boolean autoWindowing(Attributes attributes, Raster raster) {
        if (this.modalityLUT != null || this.voiLUT != null || this.windowWidth != 0.0f) {
            return false;
        }
        int n = attributes.getInt(2621702, 0);
        int n2 = attributes.getInt(2621703, 0);
        if (n2 == 0) {
            int[] nArray;
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
            DataBuffer dataBuffer = raster.getDataBuffer();
            switch (dataBuffer.getDataType()) {
                case 0: {
                    nArray = this.calcMinMax(this.storedValue, componentSampleModel, ((DataBufferByte)dataBuffer).getData());
                    break;
                }
                case 1: {
                    nArray = this.calcMinMax(this.storedValue, componentSampleModel, ((DataBufferUShort)dataBuffer).getData());
                    break;
                }
                case 2: {
                    nArray = this.calcMinMax(this.storedValue, componentSampleModel, ((DataBufferShort)dataBuffer).getData());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("DataBuffer: " + dataBuffer.getClass() + " not supported");
                }
            }
            n = nArray[0];
            n2 = nArray[1];
        }
        this.windowCenter = (float)((n + n2 + 1) / 2) * this.rescaleSlope + this.rescaleIntercept;
        this.windowWidth = Math.abs((float)(n2 + 1 - n) * this.rescaleSlope);
        return true;
    }

    private int[] calcMinMax(StoredValue storedValue, ComponentSampleModel componentSampleModel, byte[] byArray) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = componentSampleModel.getWidth();
        int n4 = componentSampleModel.getHeight();
        int n5 = componentSampleModel.getScanlineStride();
        int n6 = 0;
        while (n6 < n4) {
            int n7 = n6 * n5;
            int n8 = n7 + n3;
            while (n7 < n8) {
                int n9;
                if ((n9 = storedValue.valueOf(byArray[n7++])) < n) {
                    n = n9;
                }
                if (n9 <= n2) continue;
                n2 = n9;
            }
            ++n6;
        }
        return new int[]{n, n2};
    }

    private int[] calcMinMax(StoredValue storedValue, ComponentSampleModel componentSampleModel, short[] sArray) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = componentSampleModel.getWidth();
        int n4 = componentSampleModel.getHeight();
        int n5 = componentSampleModel.getScanlineStride();
        int n6 = 0;
        while (n6 < n4) {
            int n7 = n6 * n5;
            int n8 = n7 + n3;
            while (n7 < n8) {
                int n9;
                if ((n9 = storedValue.valueOf(sArray[n7++])) < n) {
                    n = n9;
                }
                if (n9 <= n2) continue;
                n2 = n9;
            }
            ++n6;
        }
        return new int[]{n, n2};
    }
}

