/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.StringTokenizer;

public class SpecificCharacterSet {
    public static SpecificCharacterSet DEFAULT = new SpecificCharacterSet(Codec.ISO_646);
    private static ThreadLocal<SoftReference<Encoder>> cachedEncoder1 = new ThreadLocal();
    private static ThreadLocal<SoftReference<Encoder>> cachedEncoder2 = new ThreadLocal();
    protected final Codec[] codecs;

    public static SpecificCharacterSet valueOf(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return DEFAULT;
        }
        Codec[] codecArray = new Codec[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            codecArray[n] = Codec.forCode(stringArray[n]);
            ++n;
        }
        if (stringArray.length == 1 && codecArray[0] == Codec.ISO_646) {
            return DEFAULT;
        }
        return stringArray.length > 1 ? new ISO2022(codecArray) : new SpecificCharacterSet(codecArray);
    }

    private static Encoder encoder(ThreadLocal<SoftReference<Encoder>> threadLocal, Codec codec) {
        Encoder encoder;
        SoftReference<Encoder> softReference = threadLocal.get();
        if (softReference == null || (encoder = softReference.get()) == null || encoder.codec != codec) {
            encoder = new Encoder(codec);
            threadLocal.set(new SoftReference<Encoder>(encoder));
        }
        return encoder;
    }

    protected SpecificCharacterSet(Codec ... codecArray) {
        this.codecs = codecArray;
    }

    public byte[] encode(String string, String string2) {
        return this.codecs[0].encode(string);
    }

    public String decode(byte[] byArray) {
        return this.codecs[0].decode(byArray, 0, byArray.length);
    }

    public static final void setDefaultCharacterSet(String string) {
        DEFAULT = SpecificCharacterSet.valueOf(new String[]{string});
    }

    public boolean containsASCII() {
        return this.codecs[0].containsASCII();
    }

    private static enum Codec {
        ISO_646("US-ASCII", 10306, 0),
        ISO_8859_1("ISO-8859-1", 10306, 11585),
        ISO_8859_2("ISO-8859-2", 10306, 11586),
        ISO_8859_3("ISO-8859-3", 10306, 11587),
        ISO_8859_4("ISO-8859-4", 10306, 11588),
        ISO_8859_5("ISO-8859-5", 10306, 11596),
        ISO_8859_6("ISO-8859-6", 10306, 11591),
        ISO_8859_7("ISO-8859-7", 10306, 11590),
        ISO_8859_8("ISO-8859-8", 10306, 11592),
        ISO_8859_9("ISO-8859-9", 10306, 11597),
        JIS_X_201("JIS_X0201", 10314, 10569),
        TIS_620("TIS-620", 10306, 11604),
        JIS_X_208("x-JIS0208", -1, 9282),
        JIS_X_212("JIS_X0212-1990", -1, 0x242844),
        KS_X_1001("EUC-KR", 0, 2369859),
        UTF_8("UTF-8", 0, 0),
        GB18030("GB18030", 0, 0);

        private final String charsetName;
        private final int escSeq0;
        private final int escSeq1;

        private Codec(String string2, int n2, int n3) {
            this.charsetName = string2;
            this.escSeq0 = n2;
            this.escSeq1 = n3;
        }

        public static Codec forCode(String string) {
            if (string == null) {
                return ISO_646;
            }
            switch (Codec.last2digits(string)) {
                case 0: {
                    if (!string.equals("ISO_IR 100") && !string.equals("ISO 2022 IR 100")) break;
                    return ISO_8859_1;
                }
                case 1: {
                    if (!string.equals("ISO_IR 101") && !string.equals("ISO 2022 IR 101")) break;
                    return ISO_8859_2;
                }
                case 6: {
                    if (!string.equals("ISO 2022 IR 6")) break;
                    return ISO_646;
                }
                case 9: {
                    if (!string.equals("ISO_IR 109") && !string.equals("ISO 2022 IR 109")) break;
                    return ISO_8859_3;
                }
                case 10: {
                    if (!string.equals("ISO_IR 110") && !string.equals("ISO 2022 IR 110")) break;
                    return ISO_8859_4;
                }
                case 13: {
                    if (!string.equals("ISO_IR 13") && !string.equals("ISO 2022 IR 13")) break;
                    return JIS_X_201;
                }
                case 26: {
                    if (!string.equals("ISO_IR 126") && !string.equals("ISO 2022 IR 126")) break;
                    return ISO_8859_7;
                }
                case 27: {
                    if (!string.equals("ISO_IR 127") && !string.equals("ISO 2022 IR 127")) break;
                    return ISO_8859_6;
                }
                case 30: {
                    if (!string.equals("GB18030")) break;
                    return GB18030;
                }
                case 38: {
                    if (!string.equals("ISO_IR 138") && !string.equals("ISO 2022 IR 138")) break;
                    return ISO_8859_8;
                }
                case 44: {
                    if (!string.equals("ISO_IR 144") && !string.equals("ISO 2022 IR 144")) break;
                    return ISO_8859_5;
                }
                case 48: {
                    if (!string.equals("ISO_IR 148") && !string.equals("ISO 2022 IR 148")) break;
                    return ISO_8859_9;
                }
                case 49: {
                    if (!string.equals("ISO 2022 IR 149")) break;
                    return KS_X_1001;
                }
                case 59: {
                    if (!string.equals("ISO 2022 IR 159")) break;
                    return JIS_X_212;
                }
                case 66: {
                    if (!string.equals("ISO_IR 166") && !string.equals("ISO 2022 IR 166")) break;
                    return TIS_620;
                }
                case 87: {
                    if (!string.equals("ISO 2022 IR 87")) break;
                    return JIS_X_208;
                }
                case 92: {
                    if (!string.equals("ISO_IR 192")) break;
                    return UTF_8;
                }
            }
            return ISO_646;
        }

        private static int last2digits(String string) {
            int n = string.length();
            if (n < 2) {
                return -1;
            }
            char c = string.charAt(n - 1);
            char c2 = string.charAt(n - 2);
            return (c2 & 0xF) * 10 + (c & 0xF);
        }

        public byte[] encode(String string) {
            try {
                return string.getBytes(this.charsetName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }

        public String decode(byte[] byArray, int n, int n2) {
            try {
                return new String(byArray, n, n2, this.charsetName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }

        public boolean containsASCII() {
            return this.escSeq0 >= 0;
        }

        public int getEscSeq0() {
            return this.escSeq0;
        }

        public int getEscSeq1() {
            return this.escSeq1;
        }
    }

    private static final class Encoder {
        final Codec codec;
        final CharsetEncoder encoder;

        public Encoder(Codec codec) {
            this.codec = codec;
            this.encoder = Charset.forName(codec.charsetName).newEncoder();
        }

        public boolean encode(CharBuffer charBuffer, ByteBuffer byteBuffer, boolean bl, CodingErrorAction codingErrorAction) {
            this.encoder.onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction).reset();
            int n = charBuffer.position();
            int n2 = byteBuffer.position();
            try {
                CoderResult coderResult;
                if (bl) {
                    Encoder.escSeq(byteBuffer, this.codec.getEscSeq1());
                }
                if (!(coderResult = this.encoder.encode(charBuffer, byteBuffer, true)).isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.encoder.flush(byteBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                charBuffer.position(n);
                byteBuffer.position(n2);
                return false;
            }
            return true;
        }

        private static void escSeq(ByteBuffer byteBuffer, int n) {
            byteBuffer.put((byte)27);
            int n2 = n >> 16;
            if (n2 != 0) {
                byteBuffer.put((byte)n2);
            }
            byteBuffer.put((byte)(n >> 8));
            byteBuffer.put((byte)n);
        }
    }

    private static final class ISO2022
    extends SpecificCharacterSet {
        private ISO2022(Codec ... codecArray) {
            super(codecArray);
        }

        @Override
        public byte[] encode(String string, String string2) {
            byte[] byArray;
            ByteBuffer byteBuffer;
            int n = string.length();
            CharBuffer charBuffer = CharBuffer.wrap(string.toCharArray());
            Encoder encoder = SpecificCharacterSet.encoder(cachedEncoder1, this.codecs[0]);
            if (!encoder.encode(charBuffer, byteBuffer = ByteBuffer.wrap(byArray = new byte[n]), false, CodingErrorAction.REPORT)) {
                Encoder[] encoderArray = new Encoder[this.codecs.length];
                encoderArray[0] = encoder;
                encoderArray[1] = SpecificCharacterSet.encoder(cachedEncoder2, this.codecs[1]);
                StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
                byArray = new byte[2 * n + 4 * (stringTokenizer.countTokens() + 1)];
                byteBuffer = ByteBuffer.wrap(byArray);
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.length() == 1 && string2.indexOf(string3.charAt(0)) >= 0) {
                        if (!this.codecs[n2].containsASCII()) {
                            Encoder.escSeq(byteBuffer, this.codecs[0].getEscSeq0());
                        }
                        byteBuffer.put((byte)string3.charAt(0));
                        n2 = 0;
                        continue;
                    }
                    charBuffer = CharBuffer.wrap(string3.toCharArray());
                    if (encoderArray[n2].encode(charBuffer, byteBuffer, false, CodingErrorAction.REPORT)) continue;
                    int n3 = n2;
                    do {
                        if ((n3 = (n3 + 1) % encoderArray.length) == n2) {
                            if (!this.codecs[n2].containsASCII()) {
                                Encoder.escSeq(byteBuffer, this.codecs[0].getEscSeq0());
                            }
                            encoderArray[0].encode(charBuffer, byteBuffer, false, CodingErrorAction.REPLACE);
                            n3 = 0;
                            break;
                        }
                        if (encoderArray[n3] != null) continue;
                        encoderArray[n3] = new Encoder(this.codecs[n3]);
                    } while (!encoderArray[n3].encode(charBuffer, byteBuffer, true, CodingErrorAction.REPORT));
                    n2 = n3;
                }
                if (!this.codecs[n2].containsASCII()) {
                    Encoder.escSeq(byteBuffer, this.codecs[0].getEscSeq0());
                }
            }
            return Arrays.copyOf(byArray, byteBuffer.position());
        }

        @Override
        public String decode(byte[] byArray) {
            Codec codec = this.codecs[0];
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            while (n2 < byArray.length) {
                if (byArray[n2] == 27) {
                    if (n < n2) {
                        stringBuffer.append(codec.decode(byArray, n, n2 - n));
                    }
                    switch (((byArray[(n2 += 3) - 2] & 0xFF) << 8) + (byArray[n2 - 1] & 0xFF)) {
                        case 9256: {
                            if (byArray[n2++] == 68) {
                                codec = Codec.JIS_X_212;
                                n3 = 2;
                                break;
                            }
                            stringBuffer.append(codec.decode(byArray, n2 - 4, 4));
                            break;
                        }
                        case 9257: {
                            if (byArray[n2++] == 67) {
                                codec = Codec.KS_X_1001;
                                n3 = -1;
                                break;
                            }
                            stringBuffer.append(codec.decode(byArray, n2 - 4, 4));
                            break;
                        }
                        case 9282: {
                            codec = Codec.JIS_X_208;
                            n3 = 2;
                            break;
                        }
                        case 10306: {
                            codec = Codec.ISO_646;
                            n3 = 1;
                            break;
                        }
                        case 10314: 
                        case 10569: {
                            codec = Codec.JIS_X_201;
                            n3 = 1;
                            break;
                        }
                        case 11585: {
                            codec = Codec.ISO_8859_1;
                            n3 = 1;
                            break;
                        }
                        case 11586: {
                            codec = Codec.ISO_8859_2;
                            n3 = 1;
                            break;
                        }
                        case 11587: {
                            codec = Codec.ISO_8859_3;
                            n3 = 1;
                            break;
                        }
                        case 11588: {
                            codec = Codec.ISO_8859_4;
                            n3 = 1;
                            break;
                        }
                        case 11590: {
                            codec = Codec.ISO_8859_7;
                            n3 = 1;
                            break;
                        }
                        case 11591: {
                            codec = Codec.ISO_8859_6;
                            n3 = 1;
                            break;
                        }
                        case 11592: {
                            codec = Codec.ISO_8859_8;
                            n3 = 1;
                            break;
                        }
                        case 11596: {
                            codec = Codec.ISO_8859_5;
                            n3 = 1;
                            break;
                        }
                        case 11597: {
                            codec = Codec.ISO_8859_9;
                            n3 = 1;
                            break;
                        }
                        case 11604: {
                            codec = Codec.TIS_620;
                            n3 = 1;
                            break;
                        }
                        default: {
                            stringBuffer.append(codec.decode(byArray, n2 - 3, 3));
                        }
                    }
                    n = n2;
                    continue;
                }
                n2 += n3 > 0 ? n3 : (byArray[n2] < 0 ? 2 : 1);
            }
            if (n < n2) {
                stringBuffer.append(codec.decode(byArray, n, n2 - n));
            }
            return stringBuffer.toString();
        }
    }
}

