/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonName {
    private static final Logger LOG = LoggerFactory.getLogger(PersonName.class);
    private final String[] fields = new String[15];

    public PersonName() {
    }

    public PersonName(String string) {
        this(string, false);
    }

    public PersonName(String string, boolean bl) {
        if (string != null) {
            this.parse(string, bl);
        }
    }

    private void parse(String string, boolean bl) {
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "^=", true);
        block4: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case '=': {
                    if (++n > 2) {
                        if (bl) {
                            LOG.info("illegal PN: {} - truncate illegal component group(s)", (Object)string);
                            return;
                        }
                        throw new IllegalArgumentException(string);
                    }
                    n2 = 0;
                    break;
                }
                case '^': {
                    if (++n2 <= 4) continue block4;
                    if (bl) {
                        if (n2 != 5) continue block4;
                        LOG.info("illegal PN: {} - ignore illegal component(s)", (Object)string);
                        break;
                    }
                    throw new IllegalArgumentException(string);
                }
                default: {
                    if (n2 > 4) continue block4;
                    this.set(n, n2, string2);
                }
            }
        }
    }

    public String toString() {
        Object object;
        Object object2;
        int n = 0;
        Group group = Group.Alphabetic;
        Group[] groupArray = Group.values();
        int n2 = groupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = groupArray[n3];
            Object object3 = Component.FamilyName;
            Component[] componentArray = Component.values();
            int n4 = componentArray.length;
            int n5 = 0;
            while (n5 < n4) {
                object = componentArray[n5];
                String string = this.get((Group)((Object)object2), (Component)((Object)object));
                if (string != null) {
                    n += string.length();
                    group = object2;
                    object3 = object;
                }
                ++n5;
            }
            n += object3.ordinal();
            ++n3;
        }
        object2 = new char[n += group.ordinal()];
        n3 = 0;
        object = Group.values();
        int n6 = ((Group[])object).length;
        int n7 = 0;
        while (n7 < n6) {
            Group group2 = object[n7];
            Component component = Component.FamilyName;
            Component[] componentArray = Component.values();
            int n8 = componentArray.length;
            int n9 = 0;
            while (n9 < n8) {
                Component component2 = componentArray[n9];
                String string = this.get(group2, component2);
                if (string != null) {
                    int n10 = component2.ordinal() - component.ordinal();
                    while (n10-- > 0) {
                        object2[n3++] = (Group)94;
                    }
                    n10 = string.length();
                    string.getChars(0, n10, (char[])object2, n3);
                    n3 += n10;
                    component = component2;
                }
                ++n9;
            }
            if (group2 == group) break;
            object2[n3++] = (Group)61;
            ++n7;
        }
        return new String((char[])object2);
    }

    public String toString(Group group, boolean bl) {
        Object object;
        int n = 0;
        Component component = Component.FamilyName;
        Component[] componentArray = Component.values();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = componentArray[n3];
            String string = this.get(group, (Component)((Object)object));
            if (string != null) {
                n += string.length();
                component = object;
            }
            ++n3;
        }
        object = new char[n += bl ? component.ordinal() : 4];
        n3 = 0;
        Component[] componentArray2 = Component.values();
        int n4 = componentArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            Component component2 = componentArray2[n5];
            String string = this.get(group, component2);
            if (string != null) {
                int n6 = string.length();
                string.getChars(0, n6, (char[])object, n3);
                n3 += n6;
            }
            if (bl && component2 == component) break;
            if (n3 < ((Component)object).length) {
                object[n3++] = (Component)94;
            }
            ++n5;
        }
        return new String((char[])object);
    }

    public String get(Component component) {
        return this.get(Group.Alphabetic, component);
    }

    public String get(Group group, Component component) {
        return this.fields[group.ordinal() * 5 + component.ordinal()];
    }

    public void set(Component component, String string) {
        this.set(Group.Alphabetic, component, string);
    }

    public void set(Group group, Component component, String string) {
        this.set(group.ordinal(), component.ordinal(), string);
    }

    private void set(int n, int n2, String string) {
        this.fields[n * 5 + n2] = PersonName.trim(string);
    }

    public boolean isEmpty() {
        Group[] groupArray = Group.values();
        int n = groupArray.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            if (this.contains(group)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean contains(Group group) {
        Component[] componentArray = Component.values();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (this.contains(group, component)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean contains(Group group, Component component) {
        return this.get(group, component) != null;
    }

    public boolean contains(Component component) {
        return this.contains(Group.Alphabetic, component);
    }

    private static String trim(String string) {
        return string == null || (string = string.trim()).isEmpty() ? null : string;
    }

    public static enum Component {
        FamilyName,
        GivenName,
        MiddleName,
        NamePrefix,
        NameSuffix;

    }

    public static enum Group {
        Alphabetic,
        Ideographic,
        Phonetic;

    }
}

