/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IOD
extends ArrayList<DataElement> {
    private static final long serialVersionUID = -5065822488885801576L;
    private DataElementType type;
    private Condition condition;

    public void setType(DataElementType dataElementType) {
        this.type = dataElementType;
    }

    public DataElementType getType() {
        return this.type;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void parse(String string) throws IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(string, (DefaultHandler)new SAXHandler(this));
        }
        catch (SAXException sAXException) {
            throw new IOException("Failed to parse " + string, sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    public static IOD load(String string) throws IOException {
        if (string.startsWith("resource:")) {
            try {
                string = Thread.currentThread().getContextClassLoader().getResource(string.substring(9)).toString();
            }
            catch (NullPointerException nullPointerException) {
                throw new FileNotFoundException(string);
            }
        } else if (string.indexOf(58) < 2) {
            string = new File(string).toURI().toString();
        }
        IOD iOD = new IOD();
        iOD.parse(string);
        iOD.trimToSize();
        return iOD;
    }

    public static class And
    extends CompositeCondition {
        @Override
        public boolean match(Attributes attributes) {
            for (Condition condition : this.childs) {
                if (condition.match(attributes)) continue;
                return this.not;
            }
            return !this.not;
        }
    }

    static abstract class CompositeCondition
    extends Condition {
        protected final ArrayList<Condition> childs = new ArrayList();

        CompositeCondition() {
        }

        @Override
        public abstract boolean match(Attributes var1);

        @Override
        public void addChild(Condition condition) {
            this.childs.add(condition);
        }

        @Override
        public Condition trim() {
            int n = this.childs.size();
            if (n == 1) {
                Condition condition = this.childs.get(0).id(this.id);
                return this.not ? condition.not() : condition;
            }
            this.childs.trimToSize();
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.childs.isEmpty();
        }
    }

    public static abstract class Condition {
        protected String id;
        protected boolean not;

        public Condition id(String string) {
            this.id = string;
            return this;
        }

        public final String id() {
            return this.id;
        }

        public final Condition not() {
            this.not = !this.not;
            return this;
        }

        public abstract boolean match(Attributes var1);

        public void addChild(Condition condition) {
            throw new UnsupportedOperationException();
        }

        public Condition trim() {
            return this;
        }

        public boolean isEmpty() {
            return false;
        }
    }

    public static class DataElement
    implements Serializable {
        private static final long serialVersionUID = -7460474415381086525L;
        public final int tag;
        public final VR vr;
        public final DataElementType type;
        public final int minVM;
        public final int maxVM;
        public final int valueNumber;
        private Condition condition;
        private Object values;

        public DataElement(int n, VR vR, DataElementType dataElementType, int n2, int n3, int n4) {
            this.tag = n;
            this.vr = vR;
            this.type = dataElementType;
            this.minVM = n2;
            this.maxVM = n3;
            this.valueNumber = n4;
        }

        public DataElement setCondition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public int getValueNumber() {
            return this.valueNumber;
        }

        public DataElement setValues(String ... stringArray) {
            if (this.vr == VR.SQ) {
                throw new IllegalStateException("vr=SQ");
            }
            this.values = stringArray;
            return this;
        }

        public DataElement setValues(int ... nArray) {
            if (!this.vr.isIntType()) {
                throw new IllegalStateException("vr=" + (Object)((Object)this.vr));
            }
            this.values = nArray;
            return this;
        }

        public DataElement setValues(Code ... codeArray) {
            if (this.vr != VR.SQ) {
                throw new IllegalStateException("vr=" + (Object)((Object)this.vr));
            }
            this.values = codeArray;
            return this;
        }

        public DataElement addItemIOD(IOD iOD) {
            if (this.values == null) {
                this.values = new IOD[]{iOD};
            } else {
                IOD[] iODArray = (IOD[])this.values;
                iODArray = Arrays.copyOf(iODArray, iODArray.length + 1);
                iODArray[iODArray.length - 1] = iOD;
                this.values = iODArray;
            }
            return this;
        }

        public Object getValues() {
            return this.values;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<DataElement keyword=\"").append(ElementDictionary.getStandardElementDictionary().keywordOf(this.tag)).append("\" tag=\"").append(TagUtils.toHexString(this.tag)).append("\" vr=\"").append((Object)this.vr).append("\" type=\"").append((Object)this.type);
            if (this.condition != null) {
                stringBuilder.append('C');
            }
            stringBuilder.append(this.vr == VR.SQ ? "\" items=\"" : "\" vm=\"");
            if (this.minVM == -1) {
                stringBuilder.append('n');
            } else {
                stringBuilder.append(this.minVM);
            }
            if (this.maxVM != this.minVM) {
                stringBuilder.append('-');
                if (this.maxVM == -1) {
                    stringBuilder.append('n');
                } else {
                    stringBuilder.append(this.maxVM);
                }
            }
            if (this.valueNumber != 0) {
                stringBuilder.append("\" valueNumber=\"").append(this.valueNumber);
            }
            if (this.values instanceof String[] || this.values instanceof int[] || this.values instanceof Code[]) {
                stringBuilder.append("\">").append(StringUtils.LINE_SEPARATOR);
                if (this.values instanceof String[]) {
                    String[] stringArray = (String[])this.values;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        stringBuilder.append("  <Value>").append(string).append("</Value>").append(StringUtils.LINE_SEPARATOR);
                        ++n2;
                    }
                } else if (this.values instanceof int[]) {
                    int[] nArray = (int[])this.values;
                    int n = nArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int n4 = nArray[n3];
                        stringBuilder.append("  <Value>").append(n4).append("</Value>").append(StringUtils.LINE_SEPARATOR);
                        ++n3;
                    }
                } else {
                    Code[] codeArray = (Code[])this.values;
                    int n = codeArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        Code code = codeArray[n5];
                        stringBuilder.append("  <Code codeValue=\"").append(code.getCodeValue()).append("\" codingSchemeDesignator=\"").append(code.getCodingSchemeDesignator());
                        if (code.getCodingSchemeVersion() != null) {
                            stringBuilder.append("\" codingSchemeVersion=\"").append(code.getCodingSchemeVersion());
                        }
                        stringBuilder.append("\" codeMeaning=\"").append(code.getCodeMeaning()).append("\" />").append(StringUtils.LINE_SEPARATOR);
                        ++n5;
                    }
                }
                stringBuilder.append("</DataElement>");
            } else {
                stringBuilder.append("\"/>");
            }
            return stringBuilder.toString();
        }
    }

    public static enum DataElementType {
        TYPE_0,
        TYPE_1,
        TYPE_2,
        TYPE_3;

    }

    public static class MemberOf
    extends Present {
        private final VR vr;
        private final int valueIndex;
        private final boolean matchNotPresent;
        private Object values;

        public MemberOf(int n, VR vR, int n2, boolean bl, int ... nArray) {
            super(n, nArray);
            this.vr = vR;
            this.valueIndex = n2;
            this.matchNotPresent = bl;
        }

        public VR vr() {
            return this.vr;
        }

        public MemberOf setValues(String ... stringArray) {
            if (this.vr == VR.SQ) {
                throw new IllegalStateException("vr=SQ");
            }
            this.values = stringArray;
            return this;
        }

        public MemberOf setValues(int ... nArray) {
            if (!this.vr.isIntType()) {
                throw new IllegalStateException("vr=" + (Object)((Object)this.vr));
            }
            this.values = nArray;
            return this;
        }

        public MemberOf setValues(Code ... codeArray) {
            if (this.vr != VR.SQ) {
                throw new IllegalStateException("vr=" + (Object)((Object)this.vr));
            }
            this.values = codeArray;
            return this;
        }

        @Override
        public boolean match(Attributes attributes) {
            if (this.values == null) {
                throw new IllegalStateException("values not initialized");
            }
            Attributes attributes2 = this.item(attributes);
            if (attributes2 == null) {
                return this.matchNotPresent;
            }
            if (this.values instanceof int[]) {
                return this.not ? !this.match(attributes2, (int[])this.values) : this.match(attributes2, (int[])this.values);
            }
            if (this.values instanceof Code[]) {
                return this.not ? !this.match(attributes2, (Code[])this.values) : this.match(attributes2, (Code[])this.values);
            }
            return this.not ? !this.match(attributes2, (String[])this.values) : this.match(attributes2, (String[])this.values);
        }

        private boolean match(Attributes attributes, String[] stringArray) {
            String string = attributes.getString(this.tag, this.valueIndex);
            if (string == null) {
                return this.not ? !this.matchNotPresent : this.matchNotPresent;
            }
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (string2.equals(string)) {
                    return !this.not;
                }
                ++n2;
            }
            return this.not;
        }

        private boolean match(Attributes attributes, Code[] codeArray) {
            Sequence sequence = attributes.getSequence(this.tag);
            if (sequence != null) {
                for (Attributes attributes2 : sequence) {
                    try {
                        Code code = new Code(attributes2);
                        Code[] codeArray2 = codeArray;
                        int n = codeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Code code2 = codeArray2[n2];
                            if (code2.equals(code)) {
                                return !this.not;
                            }
                            ++n2;
                        }
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
            return this.not;
        }

        private boolean match(Attributes attributes, int[] nArray) {
            int n = attributes.getInt(this.tag, this.valueIndex, Integer.MIN_VALUE);
            if (n == Integer.MIN_VALUE) {
                return this.matchNotPresent;
            }
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                if (n4 == n) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
    }

    public static class Or
    extends CompositeCondition {
        @Override
        public boolean match(Attributes attributes) {
            for (Condition condition : this.childs) {
                if (!condition.match(attributes)) continue;
                return !this.not;
            }
            return this.not;
        }
    }

    public static class Present
    extends Condition {
        protected final int tag;
        protected final int[] itemPath;

        public Present(int n, int ... nArray) {
            this.tag = n;
            this.itemPath = nArray;
        }

        @Override
        public boolean match(Attributes attributes) {
            return this.not ? !this.item(attributes).containsValue(this.tag) : this.item(attributes).containsValue(this.tag);
        }

        protected Attributes item(Attributes attributes) {
            int[] nArray = this.itemPath;
            int n = this.itemPath.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (n3 == -1) {
                    attributes = n3 == -1 ? attributes.getParent() : attributes.getNestedDataset(n3);
                }
                ++n2;
            }
            return attributes;
        }
    }

    private static class SAXHandler
    extends DefaultHandler {
        private StringBuilder sb = new StringBuilder();
        private boolean processCharacters;
        private boolean elementConditions;
        private boolean itemConditions;
        private String idref;
        private List<String> values = new ArrayList<String>();
        private List<Code> codes = new ArrayList<Code>();
        private LinkedList<IOD> iodStack = new LinkedList();
        private LinkedList<Condition> conditionStack = new LinkedList();
        private Map<String, IOD> id2iod = new HashMap<String, IOD>();
        private Map<String, Condition> id2cond = new HashMap<String, Condition>();

        public SAXHandler(IOD iOD) {
            this.iodStack.add(iOD);
        }

        @Override
        public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
            switch (string3.charAt(0)) {
                case 'A': {
                    if (!string3.equals("And")) break;
                    this.startCondition(string3, new And());
                    break;
                }
                case 'C': {
                    if (string3.equals("Code")) {
                        this.startCode(attributes.getValue("codeValue"), attributes.getValue("codingSchemeDesignator"), attributes.getValue("codingSchemeVersion"), attributes.getValue("codeMeaning"));
                    }
                }
                case 'D': {
                    if (!string3.equals("DataElement")) break;
                    this.startDataElement(attributes.getValue("tag"), attributes.getValue("vr"), attributes.getValue("type"), attributes.getValue("vm"), attributes.getValue("items"), attributes.getValue("valueNumber"));
                    break;
                }
                case 'I': {
                    if (string3.equals("If")) {
                        this.startIf(attributes.getValue("id"), attributes.getValue("idref"));
                        break;
                    }
                    if (!string3.equals("Item")) break;
                    this.startItem(attributes.getValue("id"), attributes.getValue("idref"), attributes.getValue("type"));
                    break;
                }
                case 'M': {
                    if (!string3.equals("MemberOf")) break;
                    this.startCondition(string3, this.memberOf(attributes));
                    break;
                }
                case 'N': {
                    if (string3.equals("NotAnd")) {
                        this.startCondition(string3, new And().not());
                        break;
                    }
                    if (string3.equals("NotMemberOf")) {
                        this.startCondition(string3, this.memberOf(attributes).not());
                        break;
                    }
                    if (string3.equals("NotOr")) {
                        this.startCondition(string3, new Or().not());
                        break;
                    }
                    if (!string3.equals("NotPresent")) break;
                    this.startCondition(string3, this.present(attributes).not());
                    break;
                }
                case 'O': {
                    if (!string3.equals("Or")) break;
                    this.startCondition(string3, new Or());
                    break;
                }
                case 'P': {
                    if (!string3.equals("Present")) break;
                    this.startCondition(string3, this.present(attributes));
                    break;
                }
                case 'V': {
                    if (!string3.equals("Value")) break;
                    this.startValue();
                }
            }
        }

        private Present present(org.xml.sax.Attributes attributes) throws SAXException {
            int[] nArray = this.tagPathOf(attributes.getValue("tag"));
            int n = nArray.length - 1;
            return new Present(nArray[n], n > 0 ? Arrays.copyOf(nArray, n) : ByteUtils.EMPTY_INTS);
        }

        private MemberOf memberOf(org.xml.sax.Attributes attributes) throws SAXException {
            int[] nArray = this.tagPathOf(attributes.getValue("tag"));
            int n = nArray.length - 1;
            return new MemberOf(nArray[n], this.vrOf(attributes.getValue("vr")), this.valueNumberOf(attributes.getValue("valueNumber"), 1) - 1, this.matchNotPresentOf(attributes.getValue("matchNotPresent")), n > 0 ? Arrays.copyOf(nArray, n) : ByteUtils.EMPTY_INTS);
        }

        private void startCode(String string, String string2, String string3, String string4) throws SAXException {
            if (string == null) {
                throw new SAXException("missing codeValue attribute");
            }
            if (string2 == null) {
                throw new SAXException("missing codingSchemeDesignator attribute");
            }
            if (string4 == null) {
                throw new SAXException("missing codeMeaning attribute");
            }
            this.codes.add(new Code(string, string2, string3, string4));
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            switch (string3.charAt(0)) {
                case 'A': {
                    if (!string3.equals("And")) break;
                    this.endCondition(string3);
                    break;
                }
                case 'D': {
                    if (!string3.equals("DataElement")) break;
                    this.endDataElement();
                    break;
                }
                case 'I': {
                    if (string3.equals("If")) {
                        this.endCondition(string3);
                        break;
                    }
                    if (!string3.equals("Item")) break;
                    this.endItem();
                    break;
                }
                case 'M': {
                    if (!string3.equals("MemberOf")) break;
                    this.endCondition(string3);
                    break;
                }
                case 'N': {
                    if (string3.equals("NotAnd")) {
                        this.endCondition(string3);
                        break;
                    }
                    if (string3.equals("NotMemberOf")) {
                        this.endCondition(string3);
                        break;
                    }
                    if (string3.equals("NotOr")) {
                        this.endCondition(string3);
                        break;
                    }
                    if (!string3.equals("NotPresent")) break;
                    this.endCondition(string3);
                    break;
                }
                case 'O': {
                    if (!string3.equals("Or")) break;
                    this.endCondition(string3);
                    break;
                }
                case 'P': {
                    if (!string3.equals("Present")) break;
                    this.endCondition(string3);
                    break;
                }
                case 'V': {
                    if (!string3.equals("Value")) break;
                    this.endValue();
                }
            }
            this.processCharacters = false;
            this.idref = null;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.processCharacters) {
                this.sb.append(cArray, n, n2);
            }
        }

        private void startDataElement(String string, String string2, String string3, String string4, String string5, String string6) throws SAXException {
            Object object;
            String string7;
            if (this.idref != null) {
                throw new SAXException("<Item> with idref must be empty");
            }
            IOD iOD = this.iodStack.getLast();
            int n = this.tagOf(string);
            VR vR = this.vrOf(string2);
            DataElementType dataElementType = this.typeOf(string3);
            int n2 = -1;
            int n3 = -1;
            String string8 = string7 = vR == VR.SQ ? string5 : string4;
            if (string7 != null) {
                try {
                    object = StringUtils.split(string7, '-');
                    if (object[0].charAt(0) != 'n') {
                        n2 = Integer.parseInt(object[0]);
                        if (((String[])object).length > 1) {
                            if (object[1].charAt(0) != 'n') {
                                n3 = Integer.parseInt(object[1]);
                            }
                        } else {
                            n3 = n2;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new SAXException(String.valueOf(vR == VR.SQ ? "invalid items=\"" : "invalid vm=\"") + string7 + '\"');
                }
            }
            object = new DataElement(n, vR, dataElementType, n2, n3, this.valueNumberOf(string6, 0));
            iOD.add(object);
            this.elementConditions = true;
            this.itemConditions = false;
        }

        private DataElementType typeOf(String string) throws SAXException {
            if (string == null) {
                throw new SAXException("missing type attribute");
            }
            try {
                return DataElementType.valueOf("TYPE_" + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException("unrecognized type=\"" + string + '\"');
            }
        }

        private VR vrOf(String string) throws SAXException {
            try {
                return VR.valueOf(string);
            }
            catch (NullPointerException nullPointerException) {
                throw new SAXException("missing vr attribute");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException("unrecognized vr=\"" + string + '\"');
            }
        }

        private int tagOf(String string) throws SAXException {
            try {
                return (int)Long.parseLong(string, 16);
            }
            catch (NullPointerException nullPointerException) {
                throw new SAXException("missing tag attribute");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException("invalid tag=\"" + string + '\"');
            }
        }

        private int[] tagPathOf(String string) throws SAXException {
            String[] stringArray = StringUtils.split(string, '/');
            if (stringArray.length == 0) {
                throw new SAXException("missing tag attribute");
            }
            try {
                int[] nArray = new int[stringArray.length];
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = stringArray[n].equals("..") ? -1 : (int)Long.parseLong(string, 16);
                    ++n;
                }
                return nArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException("invalid tag=\"" + string + '\"');
            }
        }

        private int valueNumberOf(String string, int n) throws SAXException {
            try {
                return string != null ? Integer.parseInt(string) : n;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException("invalid valueNumber=\"" + string + '\"');
            }
        }

        private boolean matchNotPresentOf(String string) {
            return string != null && string.equalsIgnoreCase("true");
        }

        private DataElement getLastDataElement() {
            IOD iOD = this.iodStack.getLast();
            return (DataElement)iOD.get(iOD.size() - 1);
        }

        private void endDataElement() throws SAXException {
            DataElement dataElement = this.getLastDataElement();
            if (!this.values.isEmpty()) {
                try {
                    if (dataElement.vr.isIntType()) {
                        dataElement.setValues(this.parseInts(this.values));
                    } else {
                        dataElement.setValues(this.values.toArray(new String[this.values.size()]));
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw new SAXException("unexpected <Value>");
                }
                this.values.clear();
            }
            if (!this.codes.isEmpty()) {
                try {
                    dataElement.setValues(this.codes.toArray(new Code[this.codes.size()]));
                }
                catch (IllegalStateException illegalStateException) {
                    throw new SAXException("unexpected <Code>");
                }
                this.codes.clear();
            }
            this.elementConditions = false;
        }

        private int[] parseInts(List<String> list) {
            int[] nArray = new int[list.size()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = Integer.parseInt(list.get(n));
                ++n;
            }
            return nArray;
        }

        private void startValue() {
            this.sb.setLength(0);
            this.processCharacters = true;
        }

        private void endValue() {
            this.values.add(this.sb.toString());
        }

        private void startItem(String string, String string2, String string3) throws SAXException {
            IOD iOD;
            if (string2 != null) {
                if (string3 != null) {
                    throw new SAXException("<Item> with idref must not specify type");
                }
                iOD = this.id2iod.get(string2);
                if (iOD == null) {
                    throw new SAXException("could not resolve <Item idref:\"" + string2 + "\"/>");
                }
            } else {
                iOD = new IOD();
                if (string3 != null) {
                    iOD.setType(this.typeOf(string3));
                }
            }
            this.getLastDataElement().addItemIOD(iOD);
            this.iodStack.add(iOD);
            if (string != null) {
                this.id2iod.put(string, iOD);
            }
            this.idref = string2;
            this.itemConditions = true;
            this.elementConditions = false;
        }

        private void endItem() {
            this.iodStack.removeLast().trimToSize();
            this.itemConditions = false;
        }

        private void startIf(String string, String string2) throws SAXException {
            Condition condition;
            if (!this.conditionStack.isEmpty()) {
                throw new SAXException("unexpected <If>");
            }
            if (string2 != null) {
                condition = this.id2cond.get(string2);
                if (condition == null) {
                    throw new SAXException("could not resolve <If idref:\"" + string2 + "\"/>");
                }
            } else {
                condition = new And().id(string);
            }
            this.conditionStack.add(condition);
            if (string != null) {
                this.id2cond.put(string, condition);
            }
            this.idref = string2;
        }

        private void startCondition(String string, Condition condition) throws SAXException {
            if (!this.elementConditions && !this.itemConditions) {
                throw new SAXException("unexpected <" + string + '>');
            }
            this.conditionStack.add(condition);
        }

        private void endCondition(String string) throws SAXException {
            Condition condition = this.conditionStack.removeLast();
            if (condition.isEmpty()) {
                throw new SAXException(String.valueOf('<') + string + "> must not be empty");
            }
            if (!this.values.isEmpty()) {
                try {
                    MemberOf memberOf = (MemberOf)condition;
                    if (memberOf.vr.isIntType()) {
                        memberOf.setValues(this.parseInts(this.values));
                    } else {
                        memberOf.setValues(this.values.toArray(new String[this.values.size()]));
                    }
                }
                catch (Exception exception) {
                    throw new SAXException("unexpected <Value> contained by <" + string + ">");
                }
                this.values.clear();
            }
            if (!this.codes.isEmpty()) {
                try {
                    ((MemberOf)condition).setValues(this.codes.toArray(new Code[this.codes.size()]));
                }
                catch (Exception exception) {
                    throw new SAXException("unexpected <Code> contained by <" + string + ">");
                }
                this.codes.clear();
            }
            if (this.conditionStack.isEmpty()) {
                if (this.elementConditions) {
                    this.getLastDataElement().setCondition(condition.trim());
                } else {
                    this.iodStack.getLast().setCondition(condition.trim());
                }
                this.elementConditions = false;
                this.itemConditions = false;
            } else {
                this.conditionStack.getLast().addChild(condition.trim());
            }
        }
    }
}

