/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.Serializable;
import java.util.Date;

public class DateRange
implements Serializable {
    private static final long serialVersionUID = 88574297440294935L;
    private final Date start;
    private final Date end;

    public DateRange(Date date, Date date2) {
        if (date != null && date2 != null && date.after(date2)) {
            throw new IllegalArgumentException("start: " + date + " after end: " + date2);
        }
        this.start = date;
        this.end = date2;
    }

    public final Date getStartDate() {
        return this.start;
    }

    public final Date getEndDate() {
        return this.end;
    }

    public boolean contains(Date date) {
        return !(this.start != null && this.start.after(date) || this.end != null && this.end.before(date));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DateRange)) {
            return false;
        }
        DateRange dateRange = (DateRange)object;
        return (this.start == null ? dateRange.start == null : this.start.equals(dateRange.start)) && (this.end == null ? dateRange.end == null : this.end.equals(dateRange.end));
    }

    public int hashCode() {
        int n = 0;
        if (this.start != null) {
            n = this.start.hashCode();
        }
        if (this.end != null) {
            n ^= this.start.hashCode();
        }
        return n;
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + "]";
    }
}

