/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StreamUtils;

public class BulkDataLocator
implements Value {
    public static final int MAGIC_LEN = 64507;
    public final String uri;
    public final String transferSyntax;
    public final long offset;
    public final int length;

    public BulkDataLocator(String string, String string2, long l, int n) {
        if (string2 == null) {
            throw new NullPointerException("transferSyntax");
        }
        this.uri = string;
        this.transferSyntax = string2;
        this.offset = l;
        this.length = n;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        return "BulkDataLocator[uri=" + this.uri + ", tsuid=" + this.transferSyntax + ", pos=" + this.offset + ", len=" + this.length + "]";
    }

    public InputStream openStream() throws IOException {
        try {
            return new URI(this.uri).toURL().openStream();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    @Override
    public int calcLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
        return this.getEncodedLength(dicomEncodingOptions, bl, vR);
    }

    @Override
    public int getEncodedLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
        return this.length + 1 & 0xFFFFFFFE;
    }

    @Override
    public byte[] toBytes(VR vR, boolean bl) throws IOException {
        if (this.length == 0) {
            return ByteUtils.EMPTY_BYTES;
        }
        InputStream inputStream = this.openStream();
        try {
            StreamUtils.skipFully(inputStream, this.offset);
            byte[] byArray = new byte[this.length];
            StreamUtils.readFully(inputStream, byArray, 0, byArray.length);
            if (this.transferSyntax.equals("1.2.840.10008.1.2.2") ? !bl : bl) {
                vR.toggleEndian(byArray, false);
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public void writeTo(DicomOutputStream dicomOutputStream, VR vR) throws IOException {
        InputStream inputStream = this.openStream();
        try {
            StreamUtils.skipFully(inputStream, this.offset);
            if (this.transferSyntax.equals("1.2.840.10008.1.2.2") ? !dicomOutputStream.isBigEndian() : dicomOutputStream.isBigEndian()) {
                StreamUtils.copy(inputStream, (OutputStream)dicomOutputStream, this.length, vR.numEndianBytes());
            } else {
                StreamUtils.copy(inputStream, (OutputStream)dicomOutputStream, this.length);
            }
            if ((this.length & 1) != 0) {
                dicomOutputStream.write(vR.paddingByte());
            }
        }
        finally {
            inputStream.close();
        }
    }

    public void serializeTo(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.length);
        objectOutputStream.writeLong(this.offset);
        objectOutputStream.writeUTF(this.uri);
        objectOutputStream.writeUTF(this.transferSyntax);
    }

    public static Value deserializeFrom(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        long l = objectInputStream.readLong();
        String string = objectInputStream.readUTF();
        String string2 = objectInputStream.readUTF();
        return new BulkDataLocator(string, string2, l, n);
    }
}

