/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.audit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.dcm4che3.audit.Accession;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditSourceIdentification;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.Instance;
import org.dcm4che3.audit.MPPS;
import org.dcm4che3.audit.ObjectFactory;
import org.dcm4che3.audit.ParticipantObjectContainsStudy;
import org.dcm4che3.audit.ParticipantObjectDescription;
import org.dcm4che3.audit.ParticipantObjectDetail;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.audit.SOPClass;

public class AuditMessages {
    private static final Pattern IP4 = Pattern.compile("\\d+(\\.\\d+){3}");
    private static final Pattern IP6 = Pattern.compile("[0-9a-fA-F]*(\\:[0-9a-fA-F]*){7}");
    public static final String SCHEMA_URI = "http://www.dcm4che.org/DICOM/audit-message.rnc";
    private static final ObjectFactory of = new ObjectFactory();
    private static JAXBContext jc;

    private static JAXBContext jc() throws JAXBException {
        JAXBContext jAXBContext = jc;
        if (jAXBContext == null) {
            jc = jAXBContext = JAXBContext.newInstance((Class[])new Class[]{AuditMessage.class});
        }
        return jAXBContext;
    }

    public static boolean isIP(String string) {
        return IP4.matcher(string).matches() || IP6.matcher(string).matches();
    }

    public static EventIdentification createEventIdentification(EventID eventID, String string, Calendar calendar, String string2, String string3, org.dcm4che3.audit.EventTypeCode ... eventTypeCodeArray) {
        EventIdentification eventIdentification = new EventIdentification();
        eventIdentification.setEventID(eventID);
        eventIdentification.setEventDateTime(calendar != null ? calendar : Calendar.getInstance());
        eventIdentification.setEventActionCode(string);
        eventIdentification.setEventOutcomeIndicator(string2);
        eventIdentification.setEventOutcomeDescription(string3);
        org.dcm4che3.audit.EventTypeCode[] eventTypeCodeArray2 = eventTypeCodeArray;
        int n = eventTypeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.dcm4che3.audit.EventTypeCode eventTypeCode = eventTypeCodeArray2[n2];
            eventIdentification.getEventTypeCode().add(eventTypeCode);
            ++n2;
        }
        return eventIdentification;
    }

    public static ActiveParticipant createActiveParticipant(String string, String string2, String string3, boolean bl, String string4, String string5, MediaType mediaType, RoleIDCode ... roleIDCodeArray) {
        ActiveParticipant activeParticipant = new ActiveParticipant();
        activeParticipant.setUserID(string);
        activeParticipant.setAlternativeUserID(string2);
        activeParticipant.setUserName(string3);
        activeParticipant.setUserIsRequestor(bl);
        activeParticipant.setNetworkAccessPointID(string4);
        activeParticipant.setNetworkAccessPointTypeCode(string5);
        activeParticipant.setMediaType(mediaType);
        RoleIDCode[] roleIDCodeArray2 = roleIDCodeArray;
        int n = roleIDCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoleIDCode roleIDCode = roleIDCodeArray2[n2];
            activeParticipant.getRoleIDCode().add(roleIDCode);
            ++n2;
        }
        return activeParticipant;
    }

    public static AuditSourceIdentification createAuditSourceIdentification(String string, String string2, AuditSourceTypeCode ... auditSourceTypeCodeArray) {
        AuditSourceIdentification auditSourceIdentification = new AuditSourceIdentification();
        auditSourceIdentification.setAuditEnterpriseSiteID(string);
        auditSourceIdentification.setAuditSourceID(string2);
        AuditSourceTypeCode[] auditSourceTypeCodeArray2 = auditSourceTypeCodeArray;
        int n = auditSourceTypeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AuditSourceTypeCode auditSourceTypeCode = auditSourceTypeCodeArray2[n2];
            auditSourceIdentification.getAuditSourceTypeCode().add(auditSourceTypeCode);
            ++n2;
        }
        return auditSourceIdentification;
    }

    public static ParticipantObjectIdentification createParticipantObjectIdentification(String string, ParticipantObjectIDTypeCode participantObjectIDTypeCode, String string2, byte[] byArray, String string3, String string4, String string5, String string6, ParticipantObjectDescription participantObjectDescription, ParticipantObjectDetail ... participantObjectDetailArray) {
        ParticipantObjectIdentification participantObjectIdentification = new ParticipantObjectIdentification();
        participantObjectIdentification.setParticipantObjectID(string);
        participantObjectIdentification.setParticipantObjectIDTypeCode(participantObjectIDTypeCode);
        participantObjectIdentification.setParticipantObjectName(string2);
        participantObjectIdentification.setParticipantObjectQuery(byArray);
        participantObjectIdentification.setParticipantObjectTypeCode(string3);
        participantObjectIdentification.setParticipantObjectTypeCodeRole(string4);
        participantObjectIdentification.setParticipantObjectDataLifeCycle(string5);
        participantObjectIdentification.setParticipantObjectSensitivity(string6);
        participantObjectIdentification.setParticipantObjectDescription(participantObjectDescription);
        ParticipantObjectDetail[] participantObjectDetailArray2 = participantObjectDetailArray;
        int n = participantObjectDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParticipantObjectDetail participantObjectDetail = participantObjectDetailArray2[n2];
            participantObjectIdentification.getParticipantObjectDetail().add(participantObjectDetail);
            ++n2;
        }
        return participantObjectIdentification;
    }

    public static ParticipantObjectDescription createParticipantObjectDescription(Boolean bl, Boolean bl2) {
        ParticipantObjectDescription participantObjectDescription = new ParticipantObjectDescription();
        participantObjectDescription.setEncrypted(bl);
        participantObjectDescription.setAnonymized(bl2);
        return participantObjectDescription;
    }

    public static ParticipantObjectDetail createParticipantObjectDetail(String string, byte[] byArray) {
        ParticipantObjectDetail participantObjectDetail = new ParticipantObjectDetail();
        participantObjectDetail.setType(string);
        participantObjectDetail.setValue(byArray);
        return participantObjectDetail;
    }

    public static MPPS createMPPS(String string) {
        MPPS mPPS = new MPPS();
        mPPS.setUID(string);
        return mPPS;
    }

    public static SOPClass createSOPClass(String string, Integer n) {
        SOPClass sOPClass = new SOPClass();
        sOPClass.setUID(string);
        sOPClass.setNumberOfInstances(n);
        return sOPClass;
    }

    public static Instance createInstance(String string) {
        Instance instance = new Instance();
        instance.setUID(string);
        return instance;
    }

    public static ParticipantObjectContainsStudy createParticipantObjectContainsStudy(String string) {
        ParticipantObjectContainsStudy participantObjectContainsStudy = new ParticipantObjectContainsStudy();
        participantObjectContainsStudy.setUID(string);
        return participantObjectContainsStudy;
    }

    public static Accession createAccession(String string) {
        Accession accession = new Accession();
        accession.setNumber(string);
        return accession;
    }

    public static String alternativeUserIDForAETitle(String ... stringArray) {
        if (stringArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AETITLES=").append(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuilder.append(';').append(stringArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static void toXML(AuditMessage auditMessage, OutputStream outputStream) throws IOException {
        AuditMessages.toXML(auditMessage, outputStream, false, "UTF-8", SCHEMA_URI);
    }

    public static void toXML(AuditMessage auditMessage, OutputStream outputStream, boolean bl) throws IOException {
        AuditMessages.toXML(auditMessage, outputStream, bl, "UTF-8", SCHEMA_URI);
    }

    public static void toXML(AuditMessage auditMessage, OutputStream outputStream, boolean bl, String string) throws IOException {
        AuditMessages.toXML(auditMessage, outputStream, bl, string, SCHEMA_URI);
    }

    public static void toXML(AuditMessage auditMessage, OutputStream outputStream, boolean bl, String string, String string2) throws IOException {
        try {
            Marshaller marshaller = AuditMessages.jc().createMarshaller();
            if (bl) {
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
            }
            if (string2 != null) {
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)string2);
            }
            if (string != null) {
                marshaller.setProperty("jaxb.encoding", (Object)string);
            }
            marshaller.marshal(of.createAuditMessage(auditMessage), outputStream);
        }
        catch (JAXBException jAXBException) {
            if (jAXBException.getLinkedException() instanceof IOException) {
                throw (IOException)jAXBException.getLinkedException();
            }
            throw new IllegalStateException(jAXBException);
        }
    }

    public static String toXML(AuditMessage auditMessage) throws IOException {
        return AuditMessages.toXML(auditMessage, false, "UTF-8", SCHEMA_URI);
    }

    public static String toXML(AuditMessage auditMessage, boolean bl) throws IOException {
        return AuditMessages.toXML(auditMessage, bl, "UTF-8", SCHEMA_URI);
    }

    public static String toXML(AuditMessage auditMessage, boolean bl, String string) throws IOException {
        return AuditMessages.toXML(auditMessage, bl, string, SCHEMA_URI);
    }

    public static String toXML(AuditMessage auditMessage, boolean bl, String string, String string2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        AuditMessages.toXML(auditMessage, byteArrayOutputStream, bl, string, string2);
        return byteArrayOutputStream.toString(string);
    }

    public static final class AuditSourceTypeCode
    extends org.dcm4che3.audit.AuditSourceTypeCode {
        public static final AuditSourceTypeCode EndUserDisplayDevice = new AuditSourceTypeCode("1");
        public static final AuditSourceTypeCode DataAcquisitionDevice = new AuditSourceTypeCode("2");
        public static final AuditSourceTypeCode WebServerProcess = new AuditSourceTypeCode("3");
        public static final AuditSourceTypeCode ApplicationServerProcess = new AuditSourceTypeCode("4");
        public static final AuditSourceTypeCode DatabaseServerProcess = new AuditSourceTypeCode("5");
        public static final AuditSourceTypeCode SecurityServer = new AuditSourceTypeCode("6");
        public static final AuditSourceTypeCode NetworkComponent = new AuditSourceTypeCode("7");
        public static final AuditSourceTypeCode OperatingSoftware = new AuditSourceTypeCode("8");
        public static final AuditSourceTypeCode Other = new AuditSourceTypeCode("9");

        public AuditSourceTypeCode(String string) {
            this.code = string;
        }

        public AuditSourceTypeCode(String string, String string2, String string3) {
            this.code = string;
            this.codeSystemName = string2;
            this.displayName = string3;
        }

        @Override
        public void setCode(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDisplayName(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOriginalText(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystem(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystemName(String string) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class EventActionCode {
        public static final String Create = "C";
        public static final String Read = "R";
        public static final String Update = "U";
        public static final String Delete = "D";
        public static final String Execute = "E";
    }

    public static final class EventID
    extends org.dcm4che3.audit.EventID {
        public static final EventID ApplicationActivity = new EventID("110100", "DCM", "Application Activity");
        public static final EventID AuditLogUsed = new EventID("110101", "DCM", "Audit Log Used");
        public static final EventID BeginTransferringDICOMInstances = new EventID("110102", "DCM", "Begin Transferring DICOM Instances");
        public static final EventID DICOMInstancesAccessed = new EventID("110103", "DCM", "DICOM Instances Accessed");
        public static final EventID DICOMInstancesTransferred = new EventID("110104", "DCM", "DICOM Instances Transferred");
        public static final EventID DICOMStudyDeleted = new EventID("110105", "DCM", "DICOM Study Deleted");
        public static final EventID Export = new EventID("110106", "DCM", "Export");
        public static final EventID Import = new EventID("110107", "DCM", "Import");
        public static final EventID NetworkEntry = new EventID("110108", "DCM", "Network Entry");
        public static final EventID OrderRecord = new EventID("110109", "DCM", "Order Record");
        public static final EventID PatientRecord = new EventID("110110", "DCM", "Patient Record");
        public static final EventID ProcedureRecord = new EventID("110111", "DCM", "Procedure Record");
        public static final EventID Query = new EventID("110112", "DCM", "Query");
        public static final EventID SecurityAlert = new EventID("110113", "DCM", "Security Alert");
        public static final EventID UserAuthentication = new EventID("110114", "DCM", "User Authentication");
        public static final EventID HealthServicesProvisionEvent = new EventID("IHE0001", "IHE", "Health Services Provision Event");
        public static final EventID MedicationEvent = new EventID("IHE0002", "IHE", "Medication Event");
        public static final EventID PatientCareResourceAssignment = new EventID("IHE0003", "IHE", "Patient Care Resource Assignment");
        public static final EventID PatientCareEpisode = new EventID("IHE0004", "IHE", "Patient Care Episode");
        public static final EventID PatientCareProtocol = new EventID("IHE0005", "IHE", "Patient Care Protocol");

        EventID(String string, String string2, String string3) {
            this.code = string;
            this.codeSystemName = string2;
            this.displayName = string3;
        }

        @Override
        public void setCode(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDisplayName(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOriginalText(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystem(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystemName(String string) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class EventOutcomeIndicator {
        public static final String Success = "0";
        public static final String MinorFailure = "4";
        public static final String SeriousFailure = "8";
        public static final String MajorFailure = "12";
    }

    public static final class EventTypeCode
    extends org.dcm4che3.audit.EventTypeCode {
        public static final EventTypeCode ApplicationStart = new EventTypeCode("110120", "DCM", "Application Start");
        public static final EventTypeCode ApplicationStop = new EventTypeCode("110121", "DCM", "Application Stop");
        public static final EventTypeCode Login = new EventTypeCode("110122", "DCM", "Login");
        public static final EventTypeCode Logout = new EventTypeCode("110123", "DCM", "Logout");
        public static final EventTypeCode Attach = new EventTypeCode("110124", "DCM", "Attach");
        public static final EventTypeCode Detach = new EventTypeCode("110125", "DCM", "Detach");
        public static final EventTypeCode NodeAuthentication = new EventTypeCode("110126", "DCM", "Node Authentication");
        public static final EventTypeCode EmergencyOverrideStarted = new EventTypeCode("110127", "DCM", "Emergency Override Started");
        public static final EventTypeCode NetworkConfiguration = new EventTypeCode("110128", "DCM", "Network Configuration");
        public static final EventTypeCode SecurityConfiguration = new EventTypeCode("110129", "DCM", "Security Configuration");
        public static final EventTypeCode HardwareConfiguration = new EventTypeCode("110130", "DCM", "Hardware Configuration");
        public static final EventTypeCode SoftwareConfiguration = new EventTypeCode("110131", "DCM", "Software Configuration");
        public static final EventTypeCode UseOfRestrictedFunction = new EventTypeCode("110132", "DCM", "Use of Restricted Function");
        public static final EventTypeCode AuditRecordingStopped = new EventTypeCode("110133", "DCM", "Audit Recording Stopped");
        public static final EventTypeCode AuditRecordingStarted = new EventTypeCode("110134", "DCM", "Audit Recording Started");
        public static final EventTypeCode ObjectSecurityAttributesChanged = new EventTypeCode("110135", "DCM", "Object Security Attributes Changed");
        public static final EventTypeCode SecurityRolesChanged = new EventTypeCode("110136", "DCM", "Security Roles Changed");
        public static final EventTypeCode UserSecurityAttributesChanged = new EventTypeCode("110137", "DCM", "User security Attributes Changed");
        public static final EventTypeCode EmergencyOverrideStopped = new EventTypeCode("110138", "DCM", "Emergency Override Stopped");
        public static final EventTypeCode RemoteServiceOperationStarted = new EventTypeCode("110139", "DCM", "Remote Service Operation Started");
        public static final EventTypeCode RemoteServiceOperationStopped = new EventTypeCode("110140", "DCM", "Remote Service Operation Stopped");
        public static final EventTypeCode LocalServiceOperationStarted = new EventTypeCode("110141", "DCM", "Local Service Operation Started");
        public static final EventTypeCode LocalServiceOperationStopped = new EventTypeCode("110142", "DCM", "Local Service Operation Stopped");
        public static final EventTypeCode ITI_8_PatientIdentityFeed = new EventTypeCode("ITI-8", "IHE Transactions", "Patient Identity Feed");
        public static final EventTypeCode ITI_9_PIXQuery = new EventTypeCode("ITI-9", "IHE Transactions", "PIX Query");
        public static final EventTypeCode ITI_10_PIXUpdateNotification = new EventTypeCode("ITI-10", "IHE Transactions", "PIX Update Notification");
        public static final EventTypeCode ITI_18_RegistryStoredQuery = new EventTypeCode("ITI-18", "IHE Transactions", "Registry Stored Query");
        public static final EventTypeCode ITI_21_PatientDemographicsQuery = new EventTypeCode("ITI-21", "IHE Transactions", "Patient Demographics Query");
        public static final EventTypeCode ITI_22_PatientDemographicsAndVisitQuery = new EventTypeCode("ITI-22", "IHE Transactions", "Patient Demographics and Visit Query");
        public static final EventTypeCode ITI_38_CrossGatewayQuery = new EventTypeCode("ITI-38", "IHE Transactions", "Cross Gateway Query");
        public static final EventTypeCode ITI_39_CrossGatewayRetrieve = new EventTypeCode("ITI-39", "IHE Transactions", "Cross Gateway Retrieve");
        public static final EventTypeCode ITI_41_ProvideAndRegisterDocumentSetB = new EventTypeCode("ITI-41", "IHE Transactions", "Provide and Register Document Set-b");
        public static final EventTypeCode ITI_42_RegisterDocumentSetB = new EventTypeCode("ITI-42", "IHE Transactions", "Register Document Set-b");
        public static final EventTypeCode ITI_43_RetrieveDocumentSet = new EventTypeCode("ITI-43", "IHE Transactions", "Retrieve Document Set");
        public static final EventTypeCode ITI_44_PatientIdentityFeed = new EventTypeCode("ITI-44", "IHE Transactions", "Patient Identity Feed");
        public static final EventTypeCode ITI_45_PIXQuery = new EventTypeCode("ITI-45", "IHE Transactions", "PIX Query");
        public static final EventTypeCode ITI_46_PIXUpdateNotification = new EventTypeCode("ITI-46", "IHE Transactions", "PIX Update Notification");
        public static final EventTypeCode ITI_47_PatientDemographicsQuery = new EventTypeCode("ITI-47", "IHE Transactions", "Patient Demographics Query");
        public static final EventTypeCode ITI_51_MultiPatientQuery = new EventTypeCode("ITI-51", "IHE Transactions", "Multi-Patient Query");
        public static final EventTypeCode ITI_63_XCFFetch = new EventTypeCode("ITI-63", "IHE Transactions", "XCF Fetch");

        public EventTypeCode(String string, String string2, String string3) {
            this.code = string;
            this.codeSystemName = string2;
            this.displayName = string3;
        }

        @Override
        public void setCode(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDisplayName(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOriginalText(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystem(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystemName(String string) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class MediaType
    extends org.dcm4che3.audit.MediaType {
        public static final MediaType USBDiskEmulation = new MediaType("110030", "DCM", "USB Disk Emulation");
        public static final MediaType Email = new MediaType("110031", "DCM", "Email");
        public static final MediaType CD = new MediaType("110032", "DCM", "CD");
        public static final MediaType DVD = new MediaType("110033", "DCM", "DVD");
        public static final MediaType CompactFlash = new MediaType("110034", "DCM", "Compact Flash");
        public static final MediaType MultiMediaCard = new MediaType("110035", "DCM", "Multi-media Card");
        public static final MediaType SecureDigitalCard = new MediaType("110036", "DCM", "Secure Digital Card");
        public static final MediaType URI = new MediaType("110037", "DCM", "URI");
        public static final MediaType Film = new MediaType("110010", "DCM", "Film");
        public static final MediaType PaperDocument = new MediaType("110038", "DCM", "Paper Document");

        public MediaType(String string, String string2, String string3) {
            this.code = string;
            this.codeSystemName = string2;
            this.displayName = string3;
        }

        @Override
        public void setCode(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDisplayName(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOriginalText(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystem(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystemName(String string) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class NetworkAccessPointTypeCode {
        public static final String MachineName = "1";
        public static final String IPAddress = "2";
        public static final String TelephoneNumber = "3";
        public static final String EmailAddress = "4";
        public static final String URI = "5";
    }

    public static final class ParticipantObjectDataLifeCycle {
        public static final String OriginationCreation = "1";
        public static final String ImportCopyFromOriginal = "2";
        public static final String Amendment = "3";
        public static final String Verification = "4";
        public static final String Translation = "5";
        public static final String AccessUse = "6";
        public static final String DeIdentification = "7";
        public static final String AggregationSummarizationDerivation = "8";
        public static final String Report = "9";
        public static final String ExportCopyToTarget = "10";
        public static final String Disclosure = "11";
        public static final String ReceiptOfDisclosure = "12";
        public static final String Archiving = "13";
        public static final String LogicalDeletion = "14";
        public static final String PermanentErasurePhysicalDestruction = "15";
    }

    public static final class ParticipantObjectIDTypeCode
    extends org.dcm4che3.audit.ParticipantObjectIDTypeCode {
        public static final ParticipantObjectIDTypeCode MedicalRecordNumber = new ParticipantObjectIDTypeCode("1");
        public static final ParticipantObjectIDTypeCode PatientNumber = new ParticipantObjectIDTypeCode("2");
        public static final ParticipantObjectIDTypeCode EncounterNumber = new ParticipantObjectIDTypeCode("3");
        public static final ParticipantObjectIDTypeCode EnrolleeNumber = new ParticipantObjectIDTypeCode("4");
        public static final ParticipantObjectIDTypeCode SocialSecurityNumber = new ParticipantObjectIDTypeCode("5");
        public static final ParticipantObjectIDTypeCode AccountNumber = new ParticipantObjectIDTypeCode("6");
        public static final ParticipantObjectIDTypeCode GuarantorNumber = new ParticipantObjectIDTypeCode("7");
        public static final ParticipantObjectIDTypeCode ReportName = new ParticipantObjectIDTypeCode("8");
        public static final ParticipantObjectIDTypeCode ReportNumber = new ParticipantObjectIDTypeCode("9");
        public static final ParticipantObjectIDTypeCode SearchCriteria = new ParticipantObjectIDTypeCode("10");
        public static final ParticipantObjectIDTypeCode UserIdentifier = new ParticipantObjectIDTypeCode("11");
        public static final ParticipantObjectIDTypeCode URI = new ParticipantObjectIDTypeCode("12");
        public static final ParticipantObjectIDTypeCode StudyInstanceUID = new ParticipantObjectIDTypeCode("110180", "DCM", "Study Instance UID");
        public static final ParticipantObjectIDTypeCode SOPClassUID = new ParticipantObjectIDTypeCode("110181", "DCM", "SOP Class UID");
        public static final ParticipantObjectIDTypeCode NodeID = new ParticipantObjectIDTypeCode("110182", "DCM", "Node ID");
        public static final ParticipantObjectIDTypeCode ITI_PatientNumber = new ParticipantObjectIDTypeCode("2", "RFC-3881", "Patient Number");

        public ParticipantObjectIDTypeCode(String string) {
            this.code = string;
        }

        public ParticipantObjectIDTypeCode(String string, String string2, String string3) {
            this.code = string;
            this.codeSystemName = string2;
            this.displayName = string3;
        }

        @Override
        public void setCode(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDisplayName(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOriginalText(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystem(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystemName(String string) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ParticipantObjectTypeCode {
        public static final String Person = "1";
        public static final String SystemObject = "2";
        public static final String Organization = "3";
        public static final String Other = "4";
    }

    public static final class ParticipantObjectTypeCodeRole {
        public static final String Patient = "1";
        public static final String Location = "2";
        public static final String Report = "3";
        public static final String Resource = "4";
        public static final String MasterFile = "5";
        public static final String User = "6";
        public static final String List = "7";
        public static final String Doctor = "8";
        public static final String Subscriber = "9";
        public static final String Guarantor = "10";
        public static final String SecurityUserEntity = "11";
        public static final String SecurityUserGroup = "12";
        public static final String SecurityResource = "13";
        public static final String SecurityGranualarityDefinition = "14";
        public static final String Provider = "15";
        public static final String ReportDestination = "16";
        public static final String ReportLibrary = "17";
        public static final String Schedule = "18";
        public static final String Customer = "19";
        public static final String Job = "20";
        public static final String JobStream = "21";
        public static final String Table = "22";
        public static final String RoutingCriteria = "23";
        public static final String Query = "24";
    }

    public static final class RoleIDCode
    extends org.dcm4che3.audit.RoleIDCode {
        public static final RoleIDCode Application = new RoleIDCode("110150", "DCM", "Application");
        public static final RoleIDCode ApplicationLauncher = new RoleIDCode("110151", "DCM", "Application Launcher");
        public static final RoleIDCode Destination = new RoleIDCode("110152", "DCM", "Destination");
        public static final RoleIDCode Source = new RoleIDCode("110153", "DCM", "Source");
        public static final RoleIDCode DestinationMedia = new RoleIDCode("110154", "DCM", "Destination Media");
        public static final RoleIDCode SourceMedia = new RoleIDCode("110155", "DCM", "Source Media");

        public RoleIDCode(String string, String string2, String string3) {
            this.code = string;
            this.codeSystemName = string2;
            this.displayName = string3;
        }

        @Override
        public void setCode(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDisplayName(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOriginalText(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystem(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCodeSystemName(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

