/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.monitoring;

import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.cycling.LoadRequest;
import com.agfa.pacs.impaxee.glue.monitoring.AutomaticStudyMonitoring;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.cycling.CycleListProviderFactory;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class DataReloader {
    private static final ALogger LOGGER = ALogger.getLogger(DataReloader.class);
    private final Map<String, IObjectInfo> searchResults;
    private final int baseStudyDisplaySetCount;
    private final Set<IDisplaySet> displaySetsToRemove;
    private final Set<IObjectInfo> objectsToRemove;
    private final Set<IObjectInfo> objectsToLoad;

    DataReloader(Map<String, IObjectInfo> map, int n) {
        this.searchResults = map;
        this.baseStudyDisplaySetCount = n;
        this.displaySetsToRemove = new HashSet<IDisplaySet>();
        this.objectsToRemove = new HashSet<IObjectInfo>();
        this.objectsToLoad = new HashSet<IObjectInfo>();
    }

    void addAdditionalObjectInfos(Collection<IObjectInfo> collection) {
        this.objectsToLoad.addAll(collection);
    }

    void addModifiedDisplaySets(Collection<IDisplaySet> collection) {
        this.displaySetsToRemove.addAll(collection);
        for (IDisplaySet iDisplaySet : collection) {
            IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
            int n = iFrameObjectDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
                IObjectInfo iObjectInfo = (IObjectInfo)iFrameObjectData.getQueryObject();
                this.objectsToRemove.add(iObjectInfo);
                IObjectInfo iObjectInfo2 = this.searchResults.get(iObjectInfo.getSOPInstanceUID());
                if (iObjectInfo2 != null) {
                    this.objectsToLoad.add(iObjectInfo2);
                }
                ++n2;
            }
        }
    }

    void reload() throws Exception {
        if (this.displaySetsToRemove.size() == this.baseStudyDisplaySetCount) {
            this.reloadBaseStudies();
        } else {
            LOGGER.debug("Reloading {} display sets ({} objects removed, {} objects reloaded) ...", new Object[]{this.displaySetsToRemove.size(), this.objectsToRemove.size(), this.objectsToLoad.size()});
            DataManager.getInstance().removeDisplaySet(this.displaySetsToRemove.toArray(new IDisplaySet[this.displaySetsToRemove.size()]), true);
            this.removeObjects(this.objectsToRemove);
            new LoadRequest(false).simpleLoad(new ArrayList<IObjectInfo>(this.objectsToLoad), false);
            if (AutomaticStudyMonitoring.IS_REHANGUP_ENABLED) {
                DataSelectionManager.getInstance().reHangup();
            }
        }
    }

    private void reloadBaseStudies() throws Exception {
        LOGGER.debug("Reloading all base studies ...");
        for (IPatientInfo iPatientInfo : DataInfoUtilities.getLevel(this.objectsToLoad, IPatientInfo.class)) {
            DataManager.getInstance().removePatient(iPatientInfo.getKey(), true);
        }
        CycleListProviderFactory.getInstance().getCycleListProvider().addToCycleListAndDisplay(new ArrayList<IObjectInfo>(this.objectsToLoad), Base.isLoadRelevantWith());
    }

    private void removeObjects(Iterable<IObjectInfo> iterable) {
        for (IObjectInfo iObjectInfo : iterable) {
            ISeriesData iSeriesData = DataManager.getInstance().getSerie(iObjectInfo.getSeries().getKey());
            if (iSeriesData == null) continue;
            iSeriesData.removeObject(iObjectInfo.getKey());
        }
    }
}

